/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.util;

import net.minecraft.block.BlockBanner;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BannerUtil {
    public static ItemStack getBannerItemFromBlock(World world, BlockPos pos) {
        IBlockState blockstate = world.func_180495_p(pos);
        if (blockstate.func_177230_c() instanceof BlockBanner) {
            BlockBanner bannerblock = (BlockBanner)blockstate.func_177230_c();
            return bannerblock.func_185473_a(world, pos, blockstate);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isSameBanner(ItemStack bannerA, ItemStack bannerB) {
        if (BannerUtil.isAnyBanner(bannerA) && BannerUtil.isAnyBanner(bannerB)) {
            NBTTagCompound compound;
            boolean baseequal = ItemBanner.func_179225_h((ItemStack)bannerA) == ItemBanner.func_179225_h((ItemStack)bannerB);
            NBTTagList patternsA = null;
            NBTTagList patternsB = null;
            if (bannerA.func_77942_o() && bannerA.func_77978_p().func_150297_b("BlockEntityTag", 10) && (compound = bannerA.func_77978_p().func_74775_l("BlockEntityTag")).func_74764_b("Patterns")) {
                patternsA = compound.func_150295_c("Patterns", 10);
            }
            if (bannerB.func_77942_o() && bannerB.func_77978_p().func_150297_b("BlockEntityTag", 10) && (compound = bannerB.func_77978_p().func_74775_l("BlockEntityTag")).func_74764_b("Patterns")) {
                patternsB = compound.func_150295_c("Patterns", 10);
            }
            boolean bothnull = !(patternsA != null && patternsA.func_74745_c() != 0 || patternsB != null && patternsB.func_74745_c() != 0);
            return baseequal && (bothnull || patternsA.equals(patternsB));
        }
        return false;
    }

    public static boolean isSameBanner(ItemStack banner, Entity bannerHolder) {
        boolean match = false;
        if (bannerHolder instanceof EntityLivingBase) {
            ItemStack helmet = ((EntityLivingBase)bannerHolder).func_184582_a(EntityEquipmentSlot.HEAD);
            ItemStack mainhand = ((EntityLivingBase)bannerHolder).func_184582_a(EntityEquipmentSlot.MAINHAND);
            ItemStack offhand = ((EntityLivingBase)bannerHolder).func_184582_a(EntityEquipmentSlot.OFFHAND);
            if (BannerUtil.isAnyBanner(helmet)) {
                match |= BannerUtil.isSameBanner(banner, helmet);
            }
            if (BannerUtil.isAnyBanner(mainhand)) {
                match |= BannerUtil.isSameBanner(banner, mainhand);
            }
            if (BannerUtil.isAnyBanner(offhand)) {
                match |= BannerUtil.isSameBanner(banner, offhand);
            }
        }
        return match;
    }

    public static boolean isAnyBanner(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBanner || stack.func_77973_b() instanceof ItemShield;
    }
}

