/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.tileentity;

import betterwithaddons.block.ModBlocks;
import betterwithaddons.interaction.InteractionBWA;
import betterwithaddons.tileentity.TileEntityBase;
import betterwithmods.common.BWMBlocks;
import betterwithmods.util.DirUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityAqueductWater
extends TileEntityBase {
    private int distanceFromSource;
    private static final HashSet<ResourceLocation> WATER_SOURCES = new HashSet();
    private static final HashSet<Biome> BIOMES = new HashSet();

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && InteractionBWA.AQUEDUCT_IS_TANK) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && InteractionBWA.AQUEDUCT_IS_TANK) {
            return (T)new AqueductWrapper();
        }
        return super.getCapability(capability, facing);
    }

    public static void addWaterSource(ResourceLocation block) {
        WATER_SOURCES.add(block);
    }

    public int getDistanceFromSource() {
        return this.distanceFromSource;
    }

    public void setDistanceFromSource(int distanceFromSource) {
        this.distanceFromSource = distanceFromSource;
        this.func_70296_d();
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_74768_a("Distance", this.distanceFromSource);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.distanceFromSource = compound.func_74762_e("Distance");
    }

    public static int getMinDistance(World world, BlockPos checkpos) {
        int minDistance = 1000000;
        HashSet<BlockPos> corners = new HashSet<BlockPos>();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos neighborpos = checkpos.func_177972_a(facing);
            IBlockState state = world.func_180495_p(neighborpos);
            boolean isWater = false;
            int dist = TileEntityAqueductWater.getBlockDistanceFromSource(world, neighborpos, state, false);
            if (dist > -1) {
                minDistance = Math.min(minDistance, dist);
                isWater = true;
            }
            if (!isWater) continue;
            corners.add(neighborpos.func_177967_a(facing.func_176746_e(), 1));
            corners.add(neighborpos.func_177967_a(facing.func_176746_e(), -1));
        }
        for (BlockPos neighborpos : corners) {
            IBlockState state;
            int dist = TileEntityAqueductWater.getBlockDistanceFromSource(world, neighborpos, state = world.func_180495_p(neighborpos), false);
            if (dist <= -1) continue;
            minDistance = Math.min(minDistance, dist);
        }
        return minDistance;
    }

    public static int getBlockDistanceFromSource(World world, BlockPos pos, IBlockState state, boolean recursed) {
        boolean isValidBiome = true;
        if (!BIOMES.isEmpty()) {
            boolean bl = isValidBiome = BIOMES.contains(world.func_180494_b(pos)) == InteractionBWA.AQUEDUCT_BIOMES_IS_WHITELIST;
        }
        if (isValidBiome && TileEntityAqueductWater.isRealWaterSource(state)) {
            return InteractionBWA.AQUEDUCT_SOURCES_MINIMUM <= 0 || TileEntityAqueductWater.isEnoughWater(world, pos) ? 0 : -1;
        }
        if (state.func_177230_c() == BWMBlocks.TEMP_LIQUID_SOURCE && !recursed) {
            BlockPos pumppos = pos.func_177977_b();
            IBlockState pump = world.func_180495_p(pumppos);
            if (pump.func_177230_c() == BWMBlocks.PUMP) {
                EnumFacing facing = (EnumFacing)pump.func_177229_b((IProperty)DirUtils.HORIZONTAL);
                BlockPos pumpInput = pumppos.func_177972_a(facing);
                return TileEntityAqueductWater.getBlockDistanceFromSource(world, pumpInput, world.func_180495_p(pumpInput), false);
            }
        } else {
            if (state.func_177230_c() == ModBlocks.AQUEDUCT && !recursed) {
                return TileEntityAqueductWater.getBlockDistanceFromSource(world, pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()), true);
            }
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityAqueductWater) {
                return ((TileEntityAqueductWater)te).getDistanceFromSource();
            }
        }
        return -1;
    }

    public static boolean isRealWaterSource(IBlockState state) {
        return state.func_185904_a() == Material.field_151586_h && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 || WATER_SOURCES.contains(state.func_177230_c().getRegistryName());
    }

    public static boolean isEnoughWater(World world, BlockPos pos) {
        HashSet visited = Sets.newHashSet();
        ArrayList toVisit = Lists.newArrayList((Object[])new BlockPos[]{pos});
        int foundWater = 0;
        for (int i = 0; i < InteractionBWA.AQUEDUCT_SOURCES_SEARCH; ++i) {
            BlockPos visit = (BlockPos)toVisit.remove(0);
            if (visited.contains(visit)) continue;
            visited.add(visit);
            if (!TileEntityAqueductWater.isRealWaterSource(world.func_180495_p(visit))) continue;
            if (++foundWater >= InteractionBWA.AQUEDUCT_SOURCES_MINIMUM) {
                return true;
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                toVisit.add(visit.func_177972_a(facing));
            }
        }
        return false;
    }

    public static void reloadBiomeList() {
        BIOMES.clear();
        for (String str : InteractionBWA.AQUEDUCT_BIOME_STRINGS) {
            ResourceLocation location = new ResourceLocation(str);
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)location);
            if (biome == null || BIOMES.contains(biome)) continue;
            BIOMES.add(biome);
        }
    }

    public class AqueductWrapper
    implements IFluidHandler,
    IFluidTankProperties {
        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{this};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return resource.amount;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidStack drained;
            if (resource == null) {
                return null;
            }
            if (resource.getFluid() == FluidRegistry.WATER && (drained = ModBlocks.AQUEDUCT_WATER.drain(TileEntityAqueductWater.this.func_145831_w(), TileEntityAqueductWater.this.func_174877_v(), doDrain)) != null) {
                drained.amount = Math.min(drained.amount, resource.amount);
                return drained;
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (maxDrain <= 0) {
                return null;
            }
            FluidStack drained = ModBlocks.AQUEDUCT_WATER.drain(TileEntityAqueductWater.this.func_145831_w(), TileEntityAqueductWater.this.func_174877_v(), doDrain);
            if (drained != null) {
                drained.amount = Math.min(drained.amount, maxDrain);
                return drained;
            }
            return null;
        }

        @Nullable
        public FluidStack getContents() {
            return new FluidStack(FluidRegistry.WATER, InteractionBWA.AQUEDUCT_WATER_AMOUNT);
        }

        public int getCapacity() {
            return InteractionBWA.AQUEDUCT_WATER_AMOUNT;
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return true;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return true;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return fluidStack.getFluid() == FluidRegistry.WATER;
        }
    }
}

