/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.tileentity;

import betterwithaddons.block.ModBlocks;
import betterwithaddons.entity.EntitySpirit;
import betterwithaddons.interaction.InteractionEriottoMod;
import betterwithaddons.item.ModItems;
import betterwithaddons.tileentity.TileEntityBase;
import betterwithmods.api.BWMAPI;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import betterwithmods.common.blocks.mechanical.tile.TileEntityFilteredHopper;
import betterwithmods.util.InvUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityAncestrySand
extends TileEntityBase
implements ITickable,
IMechanicalPower {
    private int spirits = 0;
    private int nextCheck = 0;
    private List<EntitySpirit> attractedSpirits = new ArrayList<EntitySpirit>();
    private boolean shouldSync;

    public int getSpirits() {
        return this.spirits;
    }

    public void setSpirits(int n) {
        this.spirits = Math.min(n, InteractionEriottoMod.SOULSAND_MAX_SPIRITS);
        if (this.spirits <= 0) {
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150425_aM.func_176223_P());
        }
        this.shouldSync = true;
    }

    public void addSpirits(int n) {
        this.setSpirits(this.spirits + n);
    }

    public void consumeSpirits(int n) {
        this.setSpirits(this.spirits - n);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_74768_a("Spirits", this.spirits);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.spirits = compound.func_74762_e("Spirits");
    }

    public void fillBottles() {
        TileEntity te;
        IBlockState hopper = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        if (this.spirits <= InteractionEriottoMod.BOTTLE_MAX_SPIRITS) {
            return;
        }
        if (hopper.func_177230_c() != BWMBlocks.SINGLE_MACHINES || hopper.func_177229_b((IProperty)BlockMechMachines.TYPE) != BlockMechMachines.EnumType.HOPPER) {
            return;
        }
        boolean isOn = false;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        boolean bl = isOn = this.calculateInput() > 0;
        if (isOn && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) instanceof TileEntityFilteredHopper) {
            TileEntityFilteredHopper tileHopper = (TileEntityFilteredHopper)te;
            IItemHandler handler = (IItemHandler)tileHopper.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            ItemStack stack = new ItemStack((Item)ModItems.ANCESTRY_BOTTLE);
            ItemStack consumed = new ItemStack(Items.field_151069_bo);
            if (tileHopper.getFilterStack().func_190926_b() && InvUtils.canInsert((IItemHandler)handler, (ItemStack)stack, (int)1) && InvUtils.getFirstOccupiedStackOfItem((IItemHandler)handler, (ItemStack)consumed) >= 0) {
                InvUtils.consumeItemsInInventory((IItemHandler)handler, (ItemStack)consumed, (int)1, (boolean)false);
                InvUtils.insert((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                this.consumeSpirits(InteractionEriottoMod.BOTTLE_MAX_SPIRITS);
            }
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        float maxdist = 8.0f;
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c);
        if (this.nextCheck-- < 0) {
            this.attractedSpirits = this.field_145850_b.func_72872_a(EntitySpirit.class, aabb.func_186662_g((double)maxdist - 0.5));
            this.nextCheck = 50;
        }
        Vec3d middleOfBlock = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5);
        if (this.spirits < InteractionEriottoMod.SOULSAND_MAX_SPIRITS) {
            for (EntitySpirit spirit : this.attractedSpirits) {
                double dz;
                double dy;
                double dx;
                double dist;
                double d5;
                double spiritdist = spirit.func_70092_e(middleOfBlock.field_72450_a, middleOfBlock.field_72448_b + 0.5, middleOfBlock.field_72449_c);
                if (spiritdist < (double)1.2f) {
                    if (this.spirits >= InteractionEriottoMod.SOULSAND_MAX_SPIRITS) continue;
                    int cachedSpirits = spirit.getSpiritValue();
                    int consume = Math.min(InteractionEriottoMod.SOULSAND_MAX_SPIRITS - this.spirits, cachedSpirits);
                    this.addSpirits(consume);
                    if ((cachedSpirits -= consume) <= 0) {
                        spirit.func_70106_y();
                    }
                    spirit.setSpiritValue(cachedSpirits);
                    continue;
                }
                if (spiritdist > (double)(maxdist * maxdist) || !((d5 = 1.0 - (dist = Math.sqrt((dx = (middleOfBlock.field_72450_a - spirit.field_70165_t) / 8.0) * dx + (dy = (middleOfBlock.field_72448_b - spirit.field_70163_u) / 8.0) * dy + (dz = (middleOfBlock.field_72449_c - spirit.field_70161_v) / 8.0) * dz))) > 0.0)) continue;
                d5 *= d5;
                spirit.field_70159_w += dx / dist * d5 * 0.1;
                spirit.field_70181_x += dy / dist * d5 * 0.1;
                spirit.field_70179_y += dz / dist * d5 * 0.1;
            }
        }
        this.fillBottles();
        if (this.shouldSync) {
            this.syncTE();
            this.shouldSync = false;
        }
    }

    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    public int getMechanicalInput(EnumFacing facing) {
        return BWMAPI.IMPLEMENTATION.getPowerOutput(this.field_145850_b, this.field_174879_c.func_177972_a(facing), facing.func_176734_d());
    }

    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    public Block getBlock() {
        return ModBlocks.ANCESTRY_SAND;
    }

    public World getBlockWorld() {
        return this.func_145831_w();
    }

    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }
}

