/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.item;

import betterwithaddons.block.ColorHandlers;
import betterwithaddons.block.IColorable;
import betterwithaddons.util.ItemUtil;
import betterwithaddons.util.NabeResultPoison;
import betterwithaddons.util.NabeResultTea;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTeaCup
extends Item
implements IColorable {
    public static final int MAX_STACK_SIZE = 8;

    public ItemTeaCup() {
        this.func_77627_a(true);
        this.func_77625_d(8);
        this.func_185043_a(new ResourceLocation("fillmodel"), (stack, worldIn, entityIn) -> ItemTeaCup.isFilled(stack) ? 1.0f : 0.0f);
    }

    public ItemStack getEmpty() {
        return new ItemStack((Item)this);
    }

    public ItemStack getFilled(NabeResultTea liquid) {
        ItemStack filled = new ItemStack((Item)this);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("type", liquid.isCeremonial ? "ceremonial" : "tea");
        compound.func_74768_a("color", liquid.getColor());
        compound.func_74778_a("teaType", liquid.mainType.getName());
        compound.func_74768_a("strength", liquid.strength);
        compound.func_74768_a("sugar", liquid.sugar);
        compound.func_74768_a("milk", liquid.milk);
        compound.func_74782_a("effects", (NBTBase)ItemUtil.serializePotionEffects(liquid.effects));
        filled.func_77982_d(compound);
        return filled;
    }

    public ItemStack getFilled(NabeResultPoison liquid) {
        ItemStack filled = new ItemStack((Item)this);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("type", "poison");
        compound.func_74768_a("color", liquid.getColor());
        compound.func_74782_a("effects", (NBTBase)ItemUtil.serializePotionEffects(Lists.newArrayList((Object[])new PotionEffect[]{new PotionEffect(MobEffects.field_76436_u, 1000)})));
        filled.func_77982_d(compound);
        return filled;
    }

    public static boolean isFilled(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        return compound != null && compound.func_74764_b("type");
    }

    public List<PotionEffect> getEffects(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        return compound != null ? ItemUtil.deserializePotionEffects(compound.func_150295_c("effects", 10)) : new ArrayList<PotionEffect>();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)this.getEmpty());
        }
    }

    private void affectEntity(EntityLivingBase entity, PotionEffect effect) {
        if (effect.func_188419_a().func_76403_b()) {
            effect.func_188419_a().func_180793_a(null, null, entity, effect.func_76458_c(), 1.0);
        } else {
            entity.func_70690_d(effect);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        EntityPlayer entityplayer;
        EntityPlayer entityPlayer = entityplayer = entityLiving instanceof EntityPlayer ? (EntityPlayer)entityLiving : null;
        if (!worldIn.field_72995_K) {
            List<PotionEffect> effects = this.getEffects(stack);
            effects.forEach(effect -> this.affectEntity(entityLiving, (PotionEffect)effect));
        }
        if (entityplayer instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)entityplayer, stack);
        }
        if (entityplayer != null) {
            entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
        }
        if (entityplayer == null || !entityplayer.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                return this.getEmpty();
            }
            if (entityplayer != null) {
                entityplayer.field_71071_by.func_70441_a(this.getEmpty());
            }
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 35;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!ItemTeaCup.isFilled(stack)) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public String func_77653_i(ItemStack stack) {
        if (ItemTeaCup.isFilled(stack)) {
            NBTTagCompound compound = stack.func_77978_p();
            assert (compound != null);
            String type = compound.func_74779_i("type");
            String teaType = compound.func_74779_i("teaType");
            int strength = compound.func_74762_e("strength");
            int sugar = compound.func_74762_e("sugar");
            int milk = compound.func_74762_e("milk");
            return I18n.func_74837_a((String)("item.teacup." + type + ".name"), (Object[])new Object[]{I18n.func_74838_a((String)("tea.strength." + strength)), I18n.func_74838_a((String)("tea.sugar." + sugar)), I18n.func_74838_a((String)("tea.milk." + milk)), I18n.func_74838_a((String)("tea.type." + teaType))});
        }
        return I18n.func_74838_a((String)"item.teacup.empty.name");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        List<PotionEffect> effects = this.getEffects(stack);
        if (!effects.isEmpty()) {
            ItemUtil.addPotionEffectTooltip(effects, tooltip, 1.0f);
        }
    }

    @Override
    public IBlockColor getBlockColor() {
        return null;
    }

    @Override
    public IItemColor getItemColor() {
        return ColorHandlers.TEACUP_COLORING;
    }
}

