/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.interaction.jei.category;

import betterwithaddons.interaction.jei.wrapper.NetRecipeWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public abstract class NetRecipeCategory
extends BlankRecipeCategory<NetRecipeWrapper> {
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final IDrawable arrow;

    public NetRecipeCategory(IGuiHelper helper) {
        ResourceLocation location = this.getBackgroundResource();
        this.background = helper.createDrawable(location, 0, 0, 119, 75);
        IDrawableStatic arrowDrawable = helper.createDrawable(location, 120, 0, 29, 58);
        this.arrow = helper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 43, 11);
    }

    protected abstract ResourceLocation getBackgroundResource();

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, NetRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 19, 11);
        guiItemStacks.init(1, true, 51, 51);
        guiItemStacks.init(2, false, 83, 11);
        guiItemStacks.init(3, false, 83, 51);
        guiItemStacks.set(0, recipeWrapper.getInputWithoutSand());
        guiItemStacks.set(1, recipeWrapper.getSandInput());
        guiItemStacks.set(2, recipeWrapper.getUpperOutputs());
        guiItemStacks.set(3, recipeWrapper.getLowerOutputs());
    }

    public String getModName() {
        return "Better With Addons";
    }
}

