/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.handler;

import betterwithaddons.block.BlockWorldScaleActive;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class WorldScaleData
extends WorldSavedData {
    public static final String ID = "WorldScaleInfo";
    private HashMap<ChunkPos, BlockPos> WorldScales = new HashMap();
    private long lastCleanup = 0L;
    private World worldObj;

    public WorldScaleData(String name) {
        super(name);
    }

    public WorldScaleData() {
        this(ID);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList shardlist = nbt.func_150295_c("worldShards", 10);
        for (int i = 0; i < shardlist.func_74745_c(); ++i) {
            NBTTagCompound shardcompound = shardlist.func_150305_b(i);
            ChunkPos chunkpos = new ChunkPos(shardcompound.func_74762_e("chunkX"), shardcompound.func_74762_e("chunkZ"));
            BlockPos shardpos = new BlockPos(shardcompound.func_74762_e("blockX"), shardcompound.func_74762_e("blockY"), shardcompound.func_74762_e("blockZ"));
            this.WorldScales.put(chunkpos, shardpos);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList shardlist = new NBTTagList();
        for (Map.Entry<ChunkPos, BlockPos> entry : this.WorldScales.entrySet()) {
            NBTTagCompound shardcompound = new NBTTagCompound();
            ChunkPos chunkpos = entry.getKey();
            BlockPos shardpos = entry.getValue();
            shardcompound.func_74768_a("chunkX", chunkpos.field_77276_a);
            shardcompound.func_74768_a("chunkZ", chunkpos.field_77275_b);
            shardcompound.func_74768_a("blockX", shardpos.func_177958_n());
            shardcompound.func_74768_a("blockY", shardpos.func_177956_o());
            shardcompound.func_74768_a("blockZ", shardpos.func_177952_p());
            shardlist.func_74742_a((NBTBase)shardcompound);
        }
        nbt.func_74782_a("worldShards", (NBTBase)shardlist);
        return nbt;
    }

    public BlockPos getNearbyScale(BlockPos pos) {
        ChunkPos chunkpos = new ChunkPos(pos);
        if (this.WorldScales.containsKey(chunkpos)) {
            return this.WorldScales.get(chunkpos);
        }
        return null;
    }

    public boolean isClaimed(ChunkPos chunkpos) {
        return this.WorldScales.containsKey(chunkpos);
    }

    public void claimChunk(ChunkPos chunkpos, BlockPos shardpos) {
        if (!this.isClaimed(chunkpos)) {
            this.WorldScales.put(chunkpos, shardpos);
            this.func_76185_a();
        }
    }

    public void unclaimChunk(ChunkPos chunkpos) {
        if (this.isClaimed(chunkpos)) {
            this.WorldScales.remove(chunkpos);
            this.func_76185_a();
        }
    }

    public void cleanup() {
        long currenttick = this.worldObj.func_82737_E();
        if (currenttick <= this.lastCleanup + 100L) {
            return;
        }
        boolean dirty = this.WorldScales.entrySet().removeIf(x -> this.worldObj.func_175667_e((BlockPos)x.getValue()) && !(this.worldObj.func_180495_p((BlockPos)x.getValue()).func_177230_c() instanceof BlockWorldScaleActive));
        if (dirty) {
            this.func_76185_a();
        }
        this.lastCleanup = currenttick;
    }

    public static WorldScaleData getInstance(World world) {
        return null;
    }
}

