/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.handler;

import betterwithaddons.interaction.InteractionBWA;
import betterwithaddons.item.ModItems;
import betterwithaddons.util.InventoryUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RotHandler {
    public static final String CREATION_TIME_TAG = "TimeOfCreation";
    private LinkedList<EntityItem> TrackedItems = new LinkedList();
    private LinkedList<EntityItem> TrackedItemsAdd = new LinkedList();
    private Iterator<EntityItem> TrackedItemsIterator;
    public static final ResourceLocation ROT = new ResourceLocation("betterwithaddons", "rot");
    public static final long ONE_DAY = 24000L;
    public static long MINECRAFT_DATE = -1L;
    static Multimap<Item, RotInfo> rottingItems = HashMultimap.create();

    public static void addRottingItem(ItemStack matchItem) {
        RotHandler.addRottingItem(matchItem, InteractionBWA.MISC_ROT_TIME, "food", new ItemStack((Item)ModItems.ROTTEN_FOOD));
    }

    public static void addRottingItem(ItemStack matchItem, long timeToRot) {
        RotHandler.addRottingItem(matchItem, timeToRot, "food", new ItemStack((Item)ModItems.ROTTEN_FOOD));
    }

    public static void addRottingItem(ItemStack matchItem, long timeToRot, String baseName, ItemStack rottedItem) {
        rottingItems.put((Object)matchItem.func_77973_b(), (Object)new RotInfo(matchItem, timeToRot, baseName, rottedItem));
    }

    public static void addRottingItem(Item item, RotInfo rotInfo) {
        rottingItems.put((Object)item, (Object)rotInfo);
    }

    public static void removeRottingItem(ItemStack matchItem) {
        ArrayList toRemove = rottingItems.get((Object)matchItem.func_77973_b()).stream().filter(rotInfo -> rotInfo.matches(matchItem)).collect(Collectors.toCollection(ArrayList::new));
        for (RotInfo info : toRemove) {
            rottingItems.remove((Object)matchItem.func_77973_b(), (Object)info);
        }
    }

    public static boolean isRottingItem(ItemStack stack) {
        return rottingItems.containsKey((Object)stack.func_77973_b());
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        ItemStack stack;
        Entity entity = event.getEntity();
        World world = event.getWorld();
        if (entity instanceof EntityItem && !(stack = ((EntityItem)entity).func_92059_d()).func_190926_b() && RotHandler.isRottingItem(stack) && !entity.field_70128_L) {
            this.TrackedItemsAdd.add((EntityItem)entity);
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent tickEvent) {
        World world = tickEvent.world;
        if (!world.field_72995_K && tickEvent.phase == TickEvent.Phase.END) {
            if (world.field_73011_w.getDimension() == 0) {
                MINECRAFT_DATE = tickEvent.world.func_82737_E() / 24000L * 24000L;
            }
            this.handleRottingWorldItems();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (!world.field_72995_K && world.func_82737_E() % 20L == 0L && event.phase == TickEvent.Phase.END) {
            block0: for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
                ItemStack stack = player.field_71071_by.func_70301_a(slot);
                if (stack.func_190926_b() || !RotHandler.isRottingItem(stack)) continue;
                long timeOfCreation = RotHandler.getCreationDate(stack);
                if (timeOfCreation == -1L) {
                    timeOfCreation = MINECRAFT_DATE;
                    RotHandler.setCreationDate(stack, timeOfCreation);
                }
                for (RotInfo info : rottingItems.get((Object)stack.func_77973_b())) {
                    if (!info.shouldSpoil(stack, timeOfCreation)) continue;
                    ItemStack containerItem = stack.func_77973_b().getContainerItem(stack);
                    containerItem.func_190920_e(stack.func_190916_E());
                    ItemStack rottenItem = info.getRottenStack(stack);
                    if (containerItem.func_190926_b()) {
                        player.field_71071_by.func_70299_a(slot, rottenItem);
                        continue block0;
                    }
                    player.field_71071_by.func_70299_a(slot, containerItem);
                    InventoryUtil.addItemToPlayer(player, rottenItem);
                    continue block0;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public void onToolTip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (RotHandler.isRottingItem(stack)) {
            long timeOfCreation = RotHandler.getCreationDate(stack);
            if (timeOfCreation == -1L) {
                return;
            }
            for (RotInfo info : rottingItems.get((Object)stack.func_77973_b())) {
                if (!info.matches(stack)) continue;
                String prefix = I18n.func_135052_a((String)info.getUnlocalizedName(stack, timeOfCreation), (Object[])new Object[0]);
                if (prefix.length() > 0) {
                    prefix = prefix + " ";
                }
                event.getToolTip().set(0, prefix + (String)event.getToolTip().get(0));
                break;
            }
        }
    }

    private void handleRottingWorldItems() {
        if (this.TrackedItemsIterator == null || !this.TrackedItemsIterator.hasNext()) {
            for (EntityItem entity : this.TrackedItemsAdd) {
                this.rotOneItem(entity);
                this.TrackedItems.add(entity);
            }
            this.TrackedItemsAdd.clear();
            this.TrackedItemsIterator = this.TrackedItems.iterator();
        } else {
            EntityItem entity = this.TrackedItemsIterator.next();
            World world = entity.field_70170_p;
            ItemStack stack = entity.func_92059_d();
            boolean remove = false;
            if (entity.field_70128_L || stack.func_190926_b() || !RotHandler.isRottingItem(stack)) {
                remove = true;
            } else {
                this.rotOneItem(entity);
            }
            if (remove) {
                this.TrackedItemsIterator.remove();
            }
        }
    }

    private void rotOneItem(EntityItem entity) {
        World world = entity.field_70170_p;
        ItemStack stack = entity.func_92059_d();
        if (!RotHandler.isRottingItem(stack)) {
            return;
        }
        long timeOfCreation = RotHandler.getCreationDate(stack);
        if (timeOfCreation == -1L) {
            timeOfCreation = MINECRAFT_DATE;
            RotHandler.setCreationDate(stack, timeOfCreation);
        }
        for (RotInfo info : rottingItems.get((Object)stack.func_77973_b())) {
            if (!info.shouldSpoil(stack, timeOfCreation)) continue;
            ItemStack containerItem = stack.func_77973_b().getContainerItem(stack);
            containerItem.func_190920_e(stack.func_190916_E());
            ItemStack rottenItem = info.getRottenStack(stack);
            if (containerItem.func_190926_b()) {
                entity.func_92058_a(rottenItem);
                if (!rottenItem.func_190926_b()) break;
                entity.func_70106_y();
                break;
            }
            entity.func_92058_a(containerItem);
            if (rottenItem.func_190926_b()) break;
            EntityItem result = new EntityItem(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, rottenItem);
            result.func_174869_p();
            world.func_72838_d((Entity)result);
            break;
        }
    }

    public static long getCreationDate(ItemStack stack) {
        if (!RotHandler.isRottingItem(stack)) {
            return -1L;
        }
        NBTTagCompound compound = stack.func_77978_p();
        return compound != null && compound.func_74764_b(CREATION_TIME_TAG) ? compound.func_74763_f(CREATION_TIME_TAG) : -1L;
    }

    public static void setCreationDate(ItemStack stack, long value) {
        if (!RotHandler.isRottingItem(stack)) {
            return;
        }
        stack.func_77983_a(CREATION_TIME_TAG, (NBTBase)new NBTTagLong(value));
    }

    @SubscribeEvent
    public void rotAttachCapability(AttachCapabilitiesEvent<ItemStack> event) {
        NBTTagCompound compound;
        ItemStack stack = (ItemStack)event.getObject();
        if (RotHandler.isRottingItem(stack) && MINECRAFT_DATE != -1L && ((compound = stack.func_77978_p()) == null || !compound.func_74764_b(CREATION_TIME_TAG))) {
            stack.func_77983_a(CREATION_TIME_TAG, (NBTBase)new NBTTagLong(MINECRAFT_DATE));
        }
    }

    public static class RotInfo {
        ItemStack itemStack;
        ItemStack rottedStack;
        String baseName;
        long spoilTime;

        public RotInfo(ItemStack matchStack) {
            this(matchStack, InteractionBWA.MISC_ROT_TIME, "food", new ItemStack((Item)ModItems.ROTTEN_FOOD));
        }

        public RotInfo(ItemStack matchStack, long spoilTime, String baseName, ItemStack rotStack) {
            this.itemStack = matchStack;
            this.spoilTime = spoilTime;
            this.baseName = baseName;
            this.rottedStack = rotStack;
        }

        public boolean matches(ItemStack stack) {
            return stack.func_77973_b() == this.itemStack.func_77973_b() && (stack.func_77960_j() == this.itemStack.func_77960_j() || this.itemStack.func_77960_j() == Short.MAX_VALUE);
        }

        public boolean shouldSpoil(ItemStack stack, long creationDate) {
            return this.matches(stack) && MINECRAFT_DATE >= creationDate + this.spoilTime;
        }

        public ItemStack getRottenStack(ItemStack stack) {
            ItemStack returnStack = this.rottedStack.func_77946_l();
            returnStack.func_190920_e(stack.func_190916_E());
            return returnStack;
        }

        public String getUnlocalizedName(ItemStack stack, long creationDate) {
            double rotPercent = (double)(MINECRAFT_DATE - creationDate) / (double)this.spoilTime;
            int rotPercentInt = Math.min(100, (int)(rotPercent * 100.0));
            String returnKey = this.getLocalizationKey(stack.func_77977_a(), rotPercentInt);
            if (returnKey == null) {
                returnKey = this.getLocalizationKey(this.baseName, rotPercentInt);
            }
            return returnKey != null ? returnKey : this.baseName + ".rot";
        }

        protected String getLocalizationKey(String baseName, int percent) {
            percent = percent / 25 * 25;
            String testkey = baseName + ".rot." + percent;
            if (I18n.func_188566_a((String)testkey)) {
                return testkey;
            }
            return null;
        }
    }
}

