/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.handler;

import betterwithaddons.handler.RandomBlockTickEvent;
import betterwithaddons.interaction.InteractionBWR;
import betterwithaddons.util.ItemUtil;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockAesthetic;
import betterwithmods.common.registry.heat.BWMHeatRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RenewablesHandler {
    public static final ResourceLocation ARTIFICIAL_BLAZE = new ResourceLocation("betterwithaddons", "artificial_blaze");
    @CapabilityInject(value=ArtificialBlaze.class)
    public static Capability<ArtificialBlaze> ARTIFICIAL_BLAZE_CAP;

    @SubscribeEvent
    public void dungRinsing(RandomBlockTickEvent event) {
        World world = event.getWorld();
        IBlockState state = event.getState();
        BlockPos pos = event.getPos();
        Random random = event.getRandom();
        if (world.field_72995_K || !InteractionBWR.DUNG_TO_DIRT || state.func_177230_c() != BWMBlocks.AESTHETIC || state.func_177229_b((IProperty)BlockAesthetic.TYPE) != BlockAesthetic.EnumType.DUNG) {
            return;
        }
        IBlockState water = world.func_180495_p(pos.func_177984_a());
        if (water.func_185904_a() != Material.field_151586_h) {
            return;
        }
        int fireIntensity = InteractionBWR.DUNG_TO_DIRT_AMBIENT_TEMP;
        for (int i = 1; i <= 3; ++i) {
            if (world.func_175677_d(pos.func_177979_c(i), true)) continue;
            fireIntensity += this.getCurrentFireIntensity(world, pos.func_177979_c(i));
            break;
        }
        if (random.nextInt(InteractionBWR.DUNG_TO_DIRT_THRESHOLD) < fireIntensity) {
            world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
            if (InteractionBWR.SAND_TO_CLAY && this.isSand(world, pos.func_177977_b())) {
                world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f);
                world.func_175656_a(pos.func_177977_b(), Blocks.field_150435_aG.func_176223_P());
            }
        }
    }

    public boolean isSand(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block == Blocks.field_150354_m;
    }

    public int getCurrentFireIntensity(World world, BlockPos pos) {
        int fireFactor = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos target = pos.func_177982_a(x, 0, z);
                fireFactor += BWMHeatRegistry.getHeat((World)world, (BlockPos)target);
            }
        }
        return fireFactor;
    }

    @SubscribeEvent
    public void meltHellfire(RandomBlockTickEvent event) {
        World world = event.getWorld();
        IBlockState state = event.getState();
        BlockPos pos = event.getPos();
        Random rand = event.getRandom();
        if (world.field_72995_K || !InteractionBWR.MELT_HELLFIRE || state.func_177230_c() != BWMBlocks.AESTHETIC || state.func_177229_b((IProperty)BlockAesthetic.TYPE) != BlockAesthetic.EnumType.HELLFIRE) {
            return;
        }
        int sources = 0;
        boolean hasSource = false;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    IBlockState lavaState = world.func_180495_p(pos.func_177982_a(x, y, z));
                    if (lavaState.func_185904_a() != Material.field_151587_i) continue;
                    ++sources;
                    hasSource |= (Integer)lavaState.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
                }
            }
        }
        if (hasSource && rand.nextInt(InteractionBWR.MELT_HELLFIRE_THRESHOLD) < sources) {
            world.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
            for (int i = 0; i < 3; ++i) {
                world.func_175718_b(2004, pos, 0);
            }
            world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (rand.nextFloat() - rand.nextFloat()) * 0.8f);
        }
    }

    @SubscribeEvent
    public void makeBlazeGolem(BlockEvent.NeighborNotifyEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState head = event.getState();
        if (!world.field_72995_K && InteractionBWR.BLAZE_GOLEMS && head.func_177230_c() == Blocks.field_150465_bP) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TileEntitySkull) || ((TileEntitySkull)te).func_145904_a() != 0) {
                return;
            }
            BlockPos body = pos.func_177977_b();
            BlockPos feet = pos.func_177979_c(2);
            if (world.func_180495_p(body).func_177230_c() == Blocks.field_150340_R && world.func_180495_p(body.func_177978_c()).func_177230_c() == Blocks.field_150411_aY && world.func_180495_p(body.func_177968_d()).func_177230_c() == Blocks.field_150411_aY && world.func_180495_p(body.func_177974_f()).func_177230_c() == Blocks.field_150411_aY && world.func_180495_p(body.func_177976_e()).func_177230_c() == Blocks.field_150411_aY && world.func_180495_p(feet).func_185904_a() == Material.field_151581_o) {
                world.func_175698_g(pos);
                world.func_175698_g(body);
                world.func_175698_g(body.func_177978_c());
                world.func_175698_g(body.func_177968_d());
                world.func_175698_g(body.func_177974_f());
                world.func_175698_g(body.func_177976_e());
                world.func_175698_g(feet);
                this.spawnArtificalBlaze(world, feet, true);
            }
        }
    }

    @SubscribeEvent
    public void feedBlaze(LivingEvent.LivingUpdateEvent event) {
        if (!InteractionBWR.BLAZE_BREEDING) {
            return;
        }
        Entity entity = event.getEntity();
        World world = entity.field_70170_p;
        Random random = world.field_73012_v;
        BlockPos pos = entity.func_180425_c();
        if (!world.field_72995_K && entity instanceof EntityBlaze) {
            int radius;
            BlockPos checkPos;
            EntityBlaze blaze = (EntityBlaze)entity;
            ArtificialBlaze blazeCap = (ArtificialBlaze)blaze.getCapability(ARTIFICIAL_BLAZE_CAP, null);
            --blazeCap.breedingDelay;
            if (blazeCap.breedingDelay > 0) {
                return;
            }
            if (blazeCap.isArtificial) {
                PotionEffect effect = new PotionEffect(MobEffects.field_76426_n);
                effect.func_100012_b(true);
                blaze.func_70690_d(effect);
            }
            if (!BiomeDictionary.hasType((Biome)world.func_180494_b(checkPos = pos.func_177982_a(random.nextInt((radius = InteractionBWR.BLAZE_BREEDING_RANGE) * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius)), (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                blazeCap.breedingDelay = InteractionBWR.BLAZE_BREEDING_DELAY;
                return;
            }
            if (world.func_180495_p(checkPos).func_185904_a() != Material.field_151581_o) {
                return;
            }
            if (!this.consumeNearbyBlazeFood(world, pos)) {
                return;
            }
            this.spawnArtificalBlaze(world, checkPos, blazeCap.isArtificial);
            world.func_175698_g(checkPos);
            blazeCap.breedingDelay = InteractionBWR.BLAZE_BREEDING_DELAY;
        }
    }

    public boolean consumeNearbyBlazeFood(World world, BlockPos pos) {
        AxisAlignedBB aabb = new AxisAlignedBB(pos);
        aabb.func_72321_a(2.0, 2.0, 2.0);
        List items = world.func_72872_a(EntityItem.class, aabb);
        for (EntityItem item : items) {
            ItemStack stack = item.func_92059_d();
            if (!this.isBlazeFood(stack) || item.field_70128_L || item.func_174874_s()) continue;
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                item.func_70106_y();
            }
            return true;
        }
        return false;
    }

    public boolean isBlazeFood(ItemStack stack) {
        return ItemUtil.matchesOreDict(stack, "listAllBlazeFoods");
    }

    public void spawnArtificalBlaze(World world, BlockPos pos, boolean artificial) {
        EntityBlaze blaze = new EntityBlaze(world);
        blaze.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        ((ArtificialBlaze)blaze.getCapability(RenewablesHandler.ARTIFICIAL_BLAZE_CAP, null)).isArtificial = artificial;
        world.func_72838_d((Entity)blaze);
        for (int i = 0; i < 6; ++i) {
            world.func_175718_b(2004, pos.func_177981_b(i % 3), 0);
        }
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(ArtificialBlaze.class, (Capability.IStorage)new Capability.IStorage<ArtificialBlaze>(){

            @Nullable
            public NBTBase writeNBT(Capability<ArtificialBlaze> capability, ArtificialBlaze instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<ArtificialBlaze> capability, ArtificialBlaze instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTTagCompound)nbt);
            }
        }, ArtificialBlaze::new);
    }

    @SubscribeEvent
    public void blazeAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof EntityBlaze) {
            event.addCapability(ARTIFICIAL_BLAZE, (ICapabilityProvider)new ArtificialBlaze());
        }
    }

    @SubscribeEvent
    public void blazeDespawn(LivingSpawnEvent.AllowDespawn event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityBlaze && ((ArtificialBlaze)entity.getCapability(RenewablesHandler.ARTIFICIAL_BLAZE_CAP, null)).isArtificial) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    @SideOnly(value=Side.CLIENT)
    public void renderQuartzTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        NBTTagCompound compound = stack.func_77978_p();
        if (!stack.func_190926_b() && compound != null && compound.func_74764_b("QuartzCrystal")) {
            int growth = compound.func_74762_e("QuartzCrystalGrowth");
            int souls = compound.func_74762_e("QuartzSouls");
            event.getToolTip().add(TextFormatting.LIGHT_PURPLE + this.getSaturationString(growth, false));
            if (souls > 0) {
                event.getToolTip().add(TextFormatting.DARK_RED + this.getSoulString(souls, 27, false));
            }
        }
    }

    private String getSaturationString(int growth, boolean verbose) {
        float percentage = (float)growth / 20.0f;
        if (verbose) {
            return I18n.func_135052_a((String)"tooltip.quartz.verbose", (Object[])new Object[]{(int)(percentage * 100.0f)});
        }
        float epsilon = 1.0E-5f;
        if (percentage > 1.0f - epsilon) {
            return I18n.func_135052_a((String)"tooltip.quartz.almostready", (Object[])new Object[0]);
        }
        if (percentage > 0.75f - epsilon) {
            return I18n.func_135052_a((String)"tooltip.quartz.readysoon", (Object[])new Object[0]);
        }
        if (percentage > 0.5f - epsilon) {
            return I18n.func_135052_a((String)"tooltip.quartz.halfway", (Object[])new Object[0]);
        }
        if (percentage > 0.25f - epsilon) {
            return I18n.func_135052_a((String)"tooltip.quartz.longway", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"tooltip.quartz.starting", (Object[])new Object[0]);
    }

    private String getSoulString(int souls, int maxsouls, boolean verbose) {
        if (verbose) {
            return I18n.func_135052_a((String)"tooltip.souls.verbose", (Object[])new Object[]{souls});
        }
        if (souls >= maxsouls) {
            return I18n.func_135052_a((String)"tooltip.souls.danger", (Object[])new Object[0]);
        }
        if (souls >= maxsouls / 2) {
            return I18n.func_135052_a((String)"tooltip.souls.half", (Object[])new Object[0]);
        }
        if (souls >= 3) {
            return I18n.func_135052_a((String)"tooltip.souls.three", (Object[])new Object[0]);
        }
        if (souls >= 2) {
            return I18n.func_135052_a((String)"tooltip.souls.two", (Object[])new Object[0]);
        }
        if (souls >= 1) {
            return I18n.func_135052_a((String)"tooltip.souls.one", (Object[])new Object[0]);
        }
        return null;
    }

    public static class ArtificialBlaze
    implements ICapabilitySerializable<NBTTagCompound> {
        public boolean isArtificial = false;
        public int breedingDelay = 0;

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == ARTIFICIAL_BLAZE_CAP;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? this : null);
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("BreedingDelay", this.breedingDelay);
            nbt.func_74757_a("IsArtificial", this.isArtificial);
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.breedingDelay = nbt.func_74762_e("BreedingDelay");
            this.isArtificial = nbt.func_74767_n("IsArtificial");
        }
    }
}

