/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.handler;

import betterwithaddons.crafting.manager.CraftingManagerPacking;
import betterwithaddons.crafting.recipes.PackingRecipe;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class HardcorePackingHandler {
    Set<TileEntityPiston> activePistons = Collections.synchronizedSet(new HashSet());

    @SubscribeEvent
    public void hardcorePackingInit(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity te = (TileEntity)event.getObject();
        if (te instanceof TileEntityPiston) {
            this.activePistons.add((TileEntityPiston)te);
        }
    }

    @SubscribeEvent
    public void hardcorePackingCompress(TickEvent.WorldTickEvent event) {
        if (event.world == null || event.world.field_72995_K) {
            return;
        }
        TileEntityPiston[] toIterate = this.activePistons.toArray(new TileEntityPiston[this.activePistons.size()]);
        HashSet<TileEntityPiston> toRemove = new HashSet<TileEntityPiston>();
        for (TileEntityPiston piston : toIterate) {
            IBlockState compressState;
            World world = piston.func_145831_w();
            toRemove.add(piston);
            if (world == null || world.field_72995_K || piston == null || !piston.func_145868_b()) continue;
            BlockPos pos = piston.func_174877_v();
            EnumFacing facing = piston.func_174930_e();
            BlockPos shovePos = piston.func_174877_v();
            IBlockState shoveState = piston.func_174927_b();
            BlockPos compressPos = shovePos.func_177972_a(facing);
            if (!this.isEmpty(world, compressPos, compressState = world.func_180495_p(compressPos)) || !this.isSurrounded(world, compressPos, facing.func_176734_d())) continue;
            AxisAlignedBB blockMask = new AxisAlignedBB(shovePos).func_111270_a(new AxisAlignedBB(compressPos));
            List items = world.func_72872_a(EntityItem.class, blockMask);
            PackingRecipe recipe = CraftingManagerPacking.getInstance().getMostValidRecipe(compressState, items);
            if (recipe == null || !recipe.consumeIngredients(items)) continue;
            world.func_175656_a(compressPos, recipe.getOutput(compressState, items));
        }
        this.activePistons.removeAll(toRemove);
    }

    public boolean isEmpty(World world, BlockPos shovePos, IBlockState shoveState) {
        return shoveState.func_177230_c().isAir(shoveState, (IBlockAccess)world, shovePos) || shoveState.func_177230_c().func_176200_f((IBlockAccess)world, shovePos);
    }

    public boolean isSurrounded(World world, BlockPos pos, EnumFacing except) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos wallPos;
            IBlockState wallState;
            if (facing == except || (wallState = world.func_180495_p(wallPos = pos.func_177972_a(facing))).func_193401_d((IBlockAccess)world, wallPos, facing.func_176734_d()) == BlockFaceShape.SOLID) continue;
            return false;
        }
        return true;
    }
}

