/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.entity;

import betterwithaddons.entity.EntitySpirit;
import betterwithaddons.entity.IHasSpirits;
import betterwithaddons.interaction.InteractionEriottoMod;
import betterwithaddons.item.ItemSamuraiArmor;
import betterwithaddons.util.SimpleWeightItem;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityKarateZombie
extends EntityZombie
implements IHasSpirits {
    private static final String TAG_SPIRITS = "spirits";
    private static final String TAG_MOVE = "karate_move";
    private static final String TAG_MOVETIMEOUT = "karate_move_timeout";
    private static final String TAG_MOVETIME = "karate_move_time";
    private static final String TAG_PERFORMING = "performing";
    private static final DataParameter<Integer> SPIRITS = EntityDataManager.func_187226_a(EntityKarateZombie.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MOVE = EntityDataManager.func_187226_a(EntityKarateZombie.class, (DataSerializer)DataSerializers.field_187192_b);
    int moveTime = -1;
    int moveTimeout = 0;
    boolean performingMove = false;
    int spawnSpirits = InteractionEriottoMod.KARATE_ZOMBIE_SPAWN_MIN_SPIRITS + this.field_70146_Z.nextInt(InteractionEriottoMod.KARATE_ZOMBIE_SPAWN_MAX_SPIRITS - InteractionEriottoMod.KARATE_ZOMBIE_SPAWN_MIN_SPIRITS);

    public EntityKarateZombie(World worldIn) {
        super(worldIn);
        this.setSpirits(this.spawnSpirits);
    }

    @Override
    public int getSpirits() {
        return (Integer)this.field_70180_af.func_187225_a(SPIRITS);
    }

    @Override
    public void setSpirits(int n) {
        this.field_70180_af.func_187227_b(SPIRITS, (Object)Math.min(n, InteractionEriottoMod.KARATE_ZOMBIE_MAX_SPIRITS));
    }

    public MartialArts getMove() {
        return this.getMove((Integer)this.field_70180_af.func_187225_a(MOVE));
    }

    public MartialArts getMove(int n) {
        MartialArts[] artses = MartialArts.values();
        return artses[MathHelper.func_76125_a((int)n, (int)0, (int)(artses.length - 1))];
    }

    public void setMove(MartialArts n) {
        this.field_70180_af.func_187227_b(MOVE, (Object)n.ordinal());
    }

    private int getMoveInternal() {
        return (Integer)this.field_70180_af.func_187225_a(MOVE);
    }

    private void setMoveInternal(int n) {
        this.field_70180_af.func_187227_b(MOVE, (Object)n);
    }

    public void addSpirits(int n) {
        this.setSpirits(this.getSpirits() + n);
        this.updateStats(this.getPower());
        this.func_70691_i((float)n / 2.0f);
    }

    public MartialArts getCurrentMove() {
        return this.getMove();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(EntityZombie.field_110186_bp).func_111128_a(0.0);
    }

    protected void func_175456_n() {
        super.func_175456_n();
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, target -> this.isInFullSamuraiArmor((EntityPlayer)target) && this.getLevel() <= 1, 6.0f, 1.0, 1.2));
    }

    private boolean isInFullSamuraiArmor(EntityPlayer target) {
        ItemStack helmet = target.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack chest = target.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack legs = target.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack boots = target.func_184582_a(EntityEquipmentSlot.FEET);
        return helmet.func_77973_b() instanceof ItemSamuraiArmor && chest.func_77973_b() instanceof ItemSamuraiArmor && legs.func_77973_b() instanceof ItemSamuraiArmor && boots.func_77973_b() instanceof ItemSamuraiArmor;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.isARealAmerican() && !this.field_70170_p.field_72995_K) {
            int j;
            for (int i = (int)((double)this.getSpirits() * InteractionEriottoMod.KARATE_ZOMBIE_DROP_MULTIPLIER); i > 0; i -= j) {
                j = EntitySpirit.getSpiritSplit(i);
                this.field_70170_p.func_72838_d((Entity)new EntitySpirit(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
        }
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return true;
    }

    public Entity getCarriedPassenger() {
        for (Entity entity : this.func_184188_bt()) {
            if (entity == this.func_184179_bs()) continue;
            return entity;
        }
        return null;
    }

    public boolean func_70652_k(Entity entityIn) {
        MartialArts currentMove = this.getCurrentMove();
        if (entityIn.func_184187_bx() == this || currentMove == MartialArts.Disarm) {
            return false;
        }
        boolean success = super.func_70652_k(entityIn);
        if ((currentMove == MartialArts.Suplex || currentMove == MartialArts.Throw) && success && entityIn instanceof EntityLivingBase && this.getCarriedPassenger() == null && this.moveTime <= 0) {
            this.pickup(entityIn);
        }
        return success;
    }

    private void pickup(Entity entityIn) {
        boolean success = entityIn.func_184205_a((Entity)this, true);
        if (success) {
            this.moveTime = this.getMoveTime(this.getCurrentMove());
            this.performingMove = true;
            if (entityIn instanceof EntityPlayer) {
                ((EntityPlayer)entityIn).func_146105_b((ITextComponent)new TextComponentTranslation("hint.struggle", new Object[0]), true);
            }
        }
    }

    private int getMoveTime(MartialArts move) {
        switch (move) {
            case Throw: {
                return 20;
            }
            case Suplex: {
                return (int)MathHelper.func_151238_b((double)20.0, (double)10.0, (double)this.getPower());
            }
            case Disarm: {
                return (int)MathHelper.func_151238_b((double)20.0, (double)40.0, (double)this.getPower());
            }
        }
        return 0;
    }

    private int getMoveTimeout(MartialArts move) {
        switch (move) {
            case Disarm: {
                return (int)MathHelper.func_151238_b((double)10.0, (double)20.0, (double)this.getPower());
            }
        }
        return (int)MathHelper.func_151238_b((double)60.0, (double)20.0, (double)this.getPower());
    }

    private void randomizeMove() {
        int level = this.getLevel();
        ArrayList nextMoves = Lists.newArrayList();
        nextMoves.add(new SimpleWeightItem<MartialArts>(MartialArts.Attack, 100));
        if (level >= 2) {
            nextMoves.add(new SimpleWeightItem<MartialArts>(MartialArts.Throw, 80));
        }
        if (level >= 4) {
            nextMoves.add(new SimpleWeightItem<MartialArts>(MartialArts.Suplex, 80));
        }
        if (level >= 6) {
            nextMoves.add(new SimpleWeightItem<MartialArts>(MartialArts.Disarm, 40));
        }
        MartialArts currentMove = (MartialArts)((Object)((SimpleWeightItem)WeightedRandom.func_76271_a((Random)this.field_70146_Z, (List)nextMoves)).getItem());
        this.moveTimeout = this.getMoveTimeout(currentMove);
        this.performingMove = false;
        this.setMove(currentMove);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData data = super.func_180482_a(difficulty, livingdata);
        return data;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPIRITS, (Object)0);
        this.field_70180_af.func_187214_a(MOVE, (Object)0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        EntityLivingBase entity = this.func_70638_az();
        boolean success = super.func_70097_a(source, amount);
        if (this.func_184179_bs() != null && source.func_76364_f() instanceof EntityLivingBase) {
            entity = (EntityLivingBase)source.func_76364_f();
        }
        if (success && this.getCurrentMove() == MartialArts.Disarm && !this.field_70128_L) {
            if (entity == source.func_76364_f() && entity != null) {
                this.disarm(entity);
            }
            this.randomizeMove();
        }
        return success;
    }

    private void disarm(EntityLivingBase entity) {
        ItemStack mainhand = entity.func_184586_b(EnumHand.MAIN_HAND);
        ItemStack offhand = entity.func_184586_b(EnumHand.OFF_HAND);
        if (!(mainhand.func_77973_b() instanceof ItemShield) && !(offhand.func_77973_b() instanceof ItemShield)) {
            if (!EnchantmentHelper.func_190938_b((ItemStack)mainhand)) {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                entity.func_70099_a(mainhand, 0.0f);
            }
            if (!EnchantmentHelper.func_190938_b((ItemStack)offhand)) {
                entity.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                entity.func_70099_a(offhand, 0.0f);
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        float mult = damageMultiplier;
        Entity carriedPassenger = this.getCarriedPassenger();
        if (carriedPassenger != null && this.getCurrentMove() == MartialArts.Suplex) {
            this.forceDismount(carriedPassenger);
            float[] ret = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance, (float)damageMultiplier);
            if (ret == null) {
                return;
            }
            distance = ret[0];
            damageMultiplier = ret[1];
            PotionEffect potioneffect = this.func_70660_b(MobEffects.field_76430_j);
            float f = potioneffect == null ? 0.0f : (float)(potioneffect.func_76458_c() + 1);
            int i = MathHelper.func_76123_f((float)((distance - 3.0f - f) * damageMultiplier));
            if (i > 0) {
                this.func_184185_a(this.func_184588_d(i), 1.0f, 1.0f);
                carriedPassenger.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)i);
            }
            mult = 0.0f;
            this.randomizeMove();
        }
        super.func_180430_e(distance, mult);
    }

    public boolean isARealAmerican() {
        return this.func_145818_k_() && this.func_95999_t().toLowerCase().equals("hulk hogan");
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isARealAmerican()) {
            this.addSpirits(InteractionEriottoMod.KARATE_ZOMBIE_MAX_SPIRITS - this.getSpirits());
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            double power = this.getPower();
            --this.moveTime;
            --this.moveTimeout;
            float rad = (float)Math.PI / 180;
            Entity carried = this.getCarriedPassenger();
            switch (this.getCurrentMove()) {
                case Suplex: {
                    if (this.moveTime != 0 || carried == null) break;
                    double jumppower = MathHelper.func_151238_b((double)1.5, (double)2.0, (double)power);
                    this.func_70024_g((double)MathHelper.func_76126_a((float)(this.field_70177_z * rad)) * 0.1, jumppower, (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * rad))) * 0.1);
                    break;
                }
                case Throw: {
                    if (this.moveTime != 0 || carried == null) break;
                    double throwpower = MathHelper.func_151238_b((double)1.0, (double)2.0, (double)power);
                    this.forceDismount(carried);
                    carried.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
                    carried.func_70024_g(throwpower * (double)(-MathHelper.func_76126_a((float)(this.field_70177_z * rad))), 0.0, throwpower * (double)MathHelper.func_76134_b((float)(this.field_70177_z * rad)));
                    this.randomizeMove();
                }
            }
            if (this.moveTimeout <= 0 && !this.performingMove) {
                this.randomizeMove();
            }
        }
    }

    @Override
    public boolean canAbsorbSpirits() {
        if (this.isARealAmerican()) {
            return false;
        }
        if (this.func_184179_bs() != null && this.func_110143_aJ() < this.func_110138_aP()) {
            return true;
        }
        return this.getSpirits() < InteractionEriottoMod.KARATE_ZOMBIE_MAX_SPIRITS;
    }

    @Override
    public int absorbSpirits(int n) {
        int consume = Math.min(InteractionEriottoMod.KARATE_ZOMBIE_MAX_SPIRITS - this.getSpirits(), n);
        this.addSpirits(consume);
        return n - consume;
    }

    private void updateStats(double power) {
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(MathHelper.func_151238_b((double)3.0, (double)6.0, (double)power));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(MathHelper.func_151238_b((double)0.23, (double)0.5, (double)power));
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(MathHelper.func_151238_b((double)0.0, (double)0.8, (double)power));
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(MathHelper.func_151238_b((double)2.0, (double)10.0, (double)power));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(MathHelper.func_151238_b((double)20.0, (double)100.0, (double)power));
    }

    private void forceDismount(Entity passenger) {
        passenger.func_184210_p();
    }

    private double getPower() {
        return (double)this.getSpirits() / (double)InteractionEriottoMod.KARATE_ZOMBIE_MAX_SPIRITS;
    }

    public int getLevel() {
        return this.getSpirits() / InteractionEriottoMod.KARATE_ZOMBIE_SPIRIT_PER_LEVEL;
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.setSpirits(compound.func_74762_e(TAG_SPIRITS));
        this.setMoveInternal(compound.func_74762_e(TAG_MOVE));
        this.moveTime = compound.func_74762_e(TAG_MOVETIME);
        this.moveTimeout = compound.func_74762_e(TAG_MOVETIMEOUT);
        this.performingMove = compound.func_74767_n(TAG_PERFORMING);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a(TAG_SPIRITS, this.getSpirits());
        compound.func_74768_a(TAG_MOVE, this.getMoveInternal());
        compound.func_74768_a(TAG_MOVETIME, this.moveTime);
        compound.func_74768_a(TAG_MOVETIMEOUT, this.moveTimeout);
        compound.func_74757_a(TAG_PERFORMING, this.performingMove);
    }

    public static enum MartialArts {
        Attack,
        Suplex,
        Throw,
        Disarm;

    }
}

