/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.enchantment;

import java.util.HashSet;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDamage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EnchantmentSharpnessOther
extends EnchantmentDamage {
    private static ThreadLocal<Entity> lastTarget = new ThreadLocal();
    private static HashSet<String> creatureTypes = new HashSet();
    private static HashSet<Class<? extends Entity>> creatureByClass = new HashSet();
    private static HashSet<String> creatureByResourceName = new HashSet();

    public static void reset() {
        creatureTypes.clear();
        creatureByClass.clear();
        creatureByResourceName.clear();
    }

    public static void register(String resourceName) {
        creatureByResourceName.add(resourceName);
    }

    public static void register(Class<? extends Entity> clazz) {
        creatureByClass.add(clazz);
    }

    public static void registerType(String type) {
        creatureTypes.add(type);
    }

    public static void registerType(EnumCreatureAttribute type) {
        EnchantmentSharpnessOther.registerType(type.name());
    }

    public static void registerByClass(ResourceLocation resourceName) {
        EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(resourceName);
        creatureByClass.add(entry.getEntityClass());
    }

    public EnchantmentSharpnessOther(Enchantment.Rarity rarityIn, EntityEquipmentSlot ... slots) {
        super(rarityIn, 0, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onAttack(AttackEntityEvent event) {
        Entity target = event.getTarget();
        lastTarget.set(target);
    }

    private boolean appliesToEntity(Entity entity) {
        if (entity == null) {
            return true;
        }
        ResourceLocation name = EntityList.func_191301_a((Entity)entity);
        if (name == null || creatureByResourceName.contains(name.toString())) {
            return false;
        }
        return !EnchantmentSharpnessOther.get(entity.getClass());
    }

    private boolean appliesToCreatureType(EnumCreatureAttribute creatureType) {
        return !creatureTypes.contains(creatureType.name());
    }

    private static boolean get(Class<? extends Entity> clazz) {
        if (creatureByClass.contains(clazz)) {
            return true;
        }
        if (clazz != Entity.class) {
            return EnchantmentSharpnessOther.get(clazz.getSuperclass());
        }
        return false;
    }

    public float func_152376_a(int level, EnumCreatureAttribute creatureType) {
        Entity target = lastTarget.get();
        if (target != null && this.appliesToCreatureType(creatureType) && this.appliesToEntity(target)) {
            return super.func_152376_a(level, creatureType);
        }
        return 0.0f;
    }
}

