/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.crafting.manager;

import betterwithaddons.block.EriottoMod.BlockCherryBox;
import betterwithaddons.crafting.recipes.CherryBoxRecipe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public abstract class CraftingManagerCherryBox {
    private final ArrayList<CherryBoxRecipe> recipes = new ArrayList();

    public BlockCherryBox.CherryBoxType getType() {
        return BlockCherryBox.CherryBoxType.NONE;
    }

    public void addRecipe(Ingredient input, ItemStack output) {
        this.recipes.add(this.createRecipe(input, output));
    }

    public void addRecipe(CherryBoxRecipe recipe) {
        this.recipes.add(recipe);
    }

    protected CherryBoxRecipe createRecipe(Ingredient input, ItemStack output) {
        return new CherryBoxRecipe(this.getType(), input, output);
    }

    public List<CherryBoxRecipe> findRecipeForRemoval(@Nonnull ItemStack input) {
        return this.recipes.stream().filter(recipe -> recipe.matchesInput(input)).collect(Collectors.toList());
    }

    @Nullable
    public ItemStack getWorkResult(ItemStack input) {
        CherryBoxRecipe entry;
        Iterator<CherryBoxRecipe> var2 = this.recipes.iterator();
        do {
            if (var2.hasNext()) continue;
            return ItemStack.field_190927_a;
        } while (!(entry = var2.next()).matchesInput(input));
        return entry.getOutput(input);
    }

    public List<CherryBoxRecipe> getRecipes() {
        return this.recipes;
    }
}

