/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.client;

import betterwithaddons.client.ToolShardOverrideHandler;
import betterwithaddons.client.models.ModelToolShardInner;
import betterwithaddons.interaction.InteractionBWA;
import betterwithaddons.util.ItemUtil;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ToolShardModelHandler {
    Method getVariantNames;
    public static IModelState STATE;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onModelBake(ModelBakeEvent event) {
        if (!InteractionBWA.ARMOR_SHARD_RENDER) {
            return;
        }
        for (Item item : Item.field_150901_e) {
            if (!ItemUtil.isTool(item)) continue;
            for (String s : this.getVariantNames(event.getModelLoader(), item)) {
                ResourceLocation file = this.getItemLocation(s);
                ModelResourceLocation memory = ModelLoader.getInventoryVariant((String)s);
                IModel model = null;
                try {
                    model = ModelLoaderRegistry.getModel((ResourceLocation)file);
                }
                catch (Exception e) {
                    try {
                        model = ModelLoaderRegistry.getModel((ResourceLocation)memory);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (model == null) continue;
                ModelToolShardInner brokenmodel = new ModelToolShardInner((ImmutableList<ResourceLocation>)ImmutableList.copyOf((Collection)model.getTextures()));
                IBakedModel bakedbrokenmodel = brokenmodel.bake(STATE, DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
                ToolShardOverrideHandler.addModel(item, bakedbrokenmodel);
            }
        }
    }

    protected List<String> getVariantNames(ModelLoader loader, Item item) {
        if (this.getVariantNames == null) {
            this.getVariantNames = ReflectionHelper.findMethod(ModelBakery.class, (String)"getVariantNames", (String)"func_177596_a", (Class[])new Class[]{Item.class});
        }
        try {
            return (List)this.getVariantNames.invoke((Object)loader, item);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return new ArrayList<String>();
    }

    protected ResourceLocation getItemLocation(String location) {
        ResourceLocation resourcelocation = new ResourceLocation(location.replaceAll("#.*", ""));
        return new ResourceLocation(resourcelocation.func_110624_b(), "item/" + resourcelocation.func_110623_a());
    }
}

