/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block.EriottoMod;

import betterwithaddons.BetterWithAddons;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockZenSand
extends BlockFalling {
    protected static final AxisAlignedBB SOUL_SAND_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);
    public static final PropertyEnum<SandDirection> SHAPE = PropertyEnum.func_177709_a((String)"shape", SandDirection.class);
    boolean shouldFall;
    boolean shouldSlow;
    Supplier<IBlockState> baseStateDelegate;

    public BlockZenSand(String name, Supplier<IBlockState> baseStateDelegate) {
        this.func_149663_c(name);
        this.setRegistryName(new ResourceLocation("betterwithaddons", name));
        this.func_149647_a(BetterWithAddons.instance.creativeTab);
        this.func_149672_a(SoundType.field_185855_h);
        this.setHarvestLevel("shovel", 0);
        this.baseStateDelegate = baseStateDelegate;
    }

    public BlockZenSand setShouldFall() {
        this.shouldFall = true;
        return this;
    }

    public BlockZenSand setShouldSlow() {
        this.shouldSlow = true;
        return this;
    }

    public IBlockState getBaseState() {
        return this.baseStateDelegate.get();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getBaseState().func_177230_c().func_180660_a(this.getBaseState(), rand, fortune);
    }

    public int func_180651_a(IBlockState state) {
        return this.getBaseState().func_177230_c().func_180651_a(this.getBaseState());
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.shouldSlow ? SOUL_SAND_AABB : field_185505_j;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (this.shouldSlow) {
            entityIn.field_70159_w *= 0.4;
            entityIn.field_70179_y *= 0.4;
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"tooltip.zen_sand", (Object[])new Object[0]));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float x, float y, float z) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() instanceof ItemHoe && facing == EnumFacing.UP && world.func_175623_d(pos.func_177984_a())) {
            int hook = ForgeEventFactory.onHoeUse((ItemStack)heldItem, (EntityPlayer)player, (World)world, (BlockPos)pos);
            if (hook != 0) {
                return hook > 0;
            }
            EnumFacing clickedFacing = this.getClickedSegment(x, z);
            if (clickedFacing == EnumFacing.UP) {
                return false;
            }
            SandDirection sandDirection = (SandDirection)((Object)state.func_177229_b(SHAPE));
            EnumFacing dir1 = sandDirection.direction1;
            EnumFacing dir2 = sandDirection.direction2;
            boolean south = (double)z > 0.5;
            boolean east = (double)x > 0.5;
            switch (sandDirection) {
                case NORTH_SOUTH: {
                    world.func_180501_a(pos, state.func_177226_a(SHAPE, (Comparable)((Object)SandDirection.getByDirections(east ? EnumFacing.EAST : EnumFacing.WEST, south ? EnumFacing.NORTH : EnumFacing.SOUTH))), 3);
                    break;
                }
                case EAST_WEST: {
                    world.func_180501_a(pos, state.func_177226_a(SHAPE, (Comparable)((Object)SandDirection.getByDirections(east ? EnumFacing.WEST : EnumFacing.EAST, south ? EnumFacing.SOUTH : EnumFacing.NORTH))), 3);
                    break;
                }
                default: {
                    if (dir1.func_176740_k() == clickedFacing.func_176740_k()) {
                        world.func_180501_a(pos, state.func_177226_a(SHAPE, (Comparable)((Object)SandDirection.getByDirections(dir1, clickedFacing))), 3);
                        break;
                    }
                    world.func_180501_a(pos, state.func_177226_a(SHAPE, (Comparable)((Object)SandDirection.getByDirections(dir2, clickedFacing))), 3);
                }
            }
            return true;
        }
        return false;
    }

    public EnumFacing getClickedSegment(float x, float z) {
        boolean isEast = (x -= 0.5f) > 0.0f && Math.abs(z -= 0.5f) < Math.abs(x);
        boolean isWest = x <= 0.0f && Math.abs(z) < Math.abs(x);
        boolean isSouth = z > 0.0f && Math.abs(x) <= Math.abs(z);
        boolean isNorth = z <= 0.0f && Math.abs(x) <= Math.abs(z);
        EnumFacing block1facing = EnumFacing.UP;
        if (isEast) {
            block1facing = EnumFacing.EAST;
        }
        if (isWest) {
            block1facing = EnumFacing.WEST;
        }
        if (isSouth) {
            block1facing = EnumFacing.SOUTH;
        }
        if (isNorth) {
            block1facing = EnumFacing.NORTH;
        }
        return block1facing;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!worldIn.field_72995_K && entityIn.canTrample(worldIn, (Block)this, pos, fallDistance)) {
            worldIn.func_175656_a(pos, this.getBaseState());
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            worldIn.func_175656_a(pos, this.getBaseState());
        }
    }

    public void func_180650_b(World worldIn, @Nonnull BlockPos pos, IBlockState state, Random rand) {
        if (this.shouldFall) {
            this.checkFallable(worldIn, pos);
        }
    }

    private void checkFallable(World worldIn, BlockPos pos) {
        if ((worldIn.func_175623_d(pos.func_177977_b()) || BlockZenSand.func_185759_i((IBlockState)worldIn.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0) {
            worldIn.func_180501_a(pos, this.getBaseState(), 2);
            worldIn.func_189507_a(pos, this.getBaseState(), worldIn.field_73012_v);
        }
    }

    public int func_189876_x(IBlockState state) {
        Block block = this.getBaseState().func_177230_c();
        return block instanceof BlockFalling ? ((BlockFalling)block).func_189876_x(this.getBaseState()) : super.func_189876_x(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SHAPE});
    }

    public int func_176201_c(IBlockState state) {
        return ((SandDirection)((Object)state.func_177229_b(SHAPE))).getMetadata();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SHAPE, (Comparable)((Object)SandDirection.byMetadata(meta)));
    }

    public static enum SandDirection implements IStringSerializable
    {
        NORTH_SOUTH(0, "north_south", EnumFacing.NORTH, EnumFacing.SOUTH),
        EAST_WEST(1, "east_west", EnumFacing.EAST, EnumFacing.WEST),
        SOUTH_EAST(2, "south_east", EnumFacing.SOUTH, EnumFacing.EAST),
        SOUTH_WEST(3, "south_west", EnumFacing.SOUTH, EnumFacing.WEST),
        NORTH_WEST(4, "north_west", EnumFacing.NORTH, EnumFacing.WEST),
        NORTH_EAST(5, "north_east", EnumFacing.NORTH, EnumFacing.EAST);

        private static final SandDirection[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final EnumFacing direction1;
        private final EnumFacing direction2;

        private SandDirection(int meta, String name, EnumFacing direction1, EnumFacing direction2) {
            this.meta = meta;
            this.name = name;
            this.direction1 = direction1;
            this.direction2 = direction2;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public EnumFacing getDirection1() {
            return this.direction1;
        }

        public EnumFacing getDirection2() {
            return this.direction2;
        }

        public String toString() {
            return this.name;
        }

        public static SandDirection getByDirections(EnumFacing dir) {
            return SandDirection.getByDirections(dir, dir);
        }

        public static SandDirection getByDirections(EnumFacing dir1, EnumFacing dir2) {
            if (dir1 == dir2) {
                return dir1.func_176740_k() == EnumFacing.Axis.X ? EAST_WEST : NORTH_SOUTH;
            }
            for (SandDirection dir : SandDirection.values()) {
                if ((dir1 != dir.direction1 || dir2 != dir.direction2) && (dir1 != dir.direction2 || dir2 != dir.direction1)) continue;
                return dir;
            }
            return NORTH_SOUTH;
        }

        public static SandDirection byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new SandDirection[SandDirection.values().length];
            SandDirection[] sandDirectionArray = SandDirection.values();
            int n = sandDirectionArray.length;
            for (int i = 0; i < n; ++i) {
                SandDirection dir;
                SandDirection.META_LOOKUP[dir.getMetadata()] = dir = sandDirectionArray[i];
            }
        }
    }
}

