/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block.EriottoMod;

import betterwithaddons.BetterWithAddons;
import betterwithaddons.block.ColorHandlers;
import betterwithaddons.block.IColorable;
import betterwithaddons.block.ModBlocks;
import betterwithaddons.item.ModItems;
import betterwithaddons.tileentity.TileEntityTea;
import betterwithaddons.util.IHasVariants;
import betterwithaddons.util.TeaType;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockCropTea
extends BlockCrops
implements IHasVariants,
IColorable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)8);

    public BlockCropTea() {
        this.func_149663_c("crop_tea");
        this.setRegistryName(new ResourceLocation("betterwithaddons", "crop_tea"));
        this.func_149647_a(BetterWithAddons.instance.creativeTab);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.func_176475_e(world, pos, state);
        if (world.func_175671_l(pos.func_177984_a()) >= 6) {
            int meta = this.func_185527_x(state);
            float chance = BlockCropTea.func_180672_a((Block)this, (World)world, (BlockPos)pos);
            TileEntity tile = world.func_175625_s(pos);
            if (meta < 7) {
                if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(25.0f / chance) + 1) == 0 ? 1 : 0) != 0)) {
                    world.func_175656_a(pos, this.func_185528_e(meta + 1));
                    ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
                }
            } else if (meta == 7) {
                DimensionType dimension = world.field_73011_w.func_186058_p();
                TeaType grownType = null;
                if (rand.nextInt(100) < 2) {
                    world.func_175656_a(pos, Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.DEAD_BUSH));
                } else {
                    grownType = dimension == DimensionType.NETHER ? TeaType.NETHER : (dimension == DimensionType.THE_END ? TeaType.END : TeaType.getByLocation(world, pos, rand));
                }
                if (grownType != null && tile instanceof TileEntityTea) {
                    if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
                        ((TileEntityTea)tile).setType(grownType);
                        world.func_175656_a(pos, this.func_185528_e(8));
                        ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
                    }
                } else {
                    world.func_175656_a(pos, Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.DEAD_BUSH));
                }
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185515_b;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    protected Item func_149866_i() {
        return Item.func_150898_a((Block)ModBlocks.TEA);
    }

    protected Item func_149865_P() {
        return Items.field_190931_a;
    }

    protected PropertyInteger func_185524_e() {
        return AGE;
    }

    public TeaType getType(IBlockAccess world, BlockPos pos, IBlockState state) {
        if (world == null || pos == null) {
            return TeaType.WHITE;
        }
        TileEntity tile = world.func_175625_s(pos);
        return this.getType(tile);
    }

    public TeaType getType(TileEntity tile) {
        return tile instanceof TileEntityTea ? ((TileEntityTea)tile).getType() : TeaType.WHITE;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
        NonNullList items = NonNullList.func_191196_a();
        this.getDrops((NonNullList<ItemStack>)items, (IBlockAccess)worldIn, pos, state, te, 0);
        float chance = ForgeEventFactory.fireBlockHarvesting((List)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortuneLevel, (float)1.0f, (boolean)silkTouch, (EntityPlayer)player);
        this.harvesters.set(player);
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            items.stream().filter(item -> chance >= 1.0f || worldIn.field_73012_v.nextFloat() <= chance).forEach(item -> BlockCropTea.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item));
        }
        this.harvesters.set(null);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        this.getDrops(drops, world, pos, state, null, fortune);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, TileEntity tile, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int age = this.func_185527_x(state);
        if (age >= this.func_185526_g()) {
            TeaType type = this.getType(tile);
            if (rand.nextInt(3) == 0 && type != TeaType.END && type != TeaType.NETHER) {
                type = TeaType.WHITE;
            }
            drops.add((Object)ModItems.TEA_LEAVES.getStack(type, rand.nextInt(3) + 1));
            for (int i = 0; i < 3 + fortune; ++i) {
                if (rand.nextInt(2) != 0) continue;
                drops.add((Object)new ItemStack(this.func_149866_i(), 1, 0));
            }
        }
        drops.add((Object)new ItemStack(this.func_149866_i(), 1));
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            NonNullList drops = NonNullList.func_191196_a();
            this.getDrops((NonNullList<ItemStack>)drops, (IBlockAccess)worldIn, pos, state, worldIn.func_175625_s(pos), fortune);
            chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack drop : drops) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockCropTea.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityTea();
    }

    @Override
    public List<ModelResourceLocation> getVariantModels() {
        return Lists.newArrayList((Object[])new ModelResourceLocation[]{new ModelResourceLocation("betterwithaddons:seed_tea", "inventory")});
    }

    @Override
    public String getVariantName(int meta) {
        return null;
    }

    @Override
    public IBlockColor getBlockColor() {
        return ColorHandlers.TEA_COLORING;
    }

    @Override
    public IItemColor getItemColor() {
        return null;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return this.func_185527_x(state) < this.func_185526_g();
    }

    protected int func_185529_b(World worldIn) {
        return 1;
    }
}

