/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.BetterWithAddons;
import betterwithaddons.block.BlockBase;
import betterwithaddons.item.ModItems;
import betterwithaddons.util.IHasVariants;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class BlockWorldScaleOre
extends BlockBase
implements IHasVariants {
    public static final PropertyInteger CRACKED = PropertyInteger.func_177719_a((String)"cracked", (int)0, (int)5);

    public BlockWorldScaleOre() {
        super("world_scale_ore", Material.field_151576_e);
        this.func_149711_c(15.0f).func_149752_b(500.0f);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean isBroken(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)CRACKED) >= 4;
    }

    public boolean isBlock(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)CRACKED) >= 5;
    }

    public void addCracks(World worldIn, BlockPos pos, IBlockState state, int n) {
        if (state.func_177230_c() instanceof BlockWorldScaleOre && !this.isBroken(state)) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)CRACKED, (Comparable)Integer.valueOf(Math.max(Math.min((Integer)state.func_177229_b((IProperty)CRACKED) + n, 5), 0))), 2);
            worldIn.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand;
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        if (this.isBroken(state)) {
            if (!this.isBlock(state)) {
                drops.add((Object)new ItemStack((Item)ModItems.WORLD_SHARD, rand.nextInt(2) + 3));
            } else {
                super.getDrops(drops, world, pos, state, fortune);
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.isBlock(state) ? 1 : 0);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)CRACKED, (Comparable)Integer.valueOf(meta == 0 ? 0 : 5));
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CRACKED, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)CRACKED);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CRACKED});
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab.equals((Object)BetterWithAddons.instance.creativeTab)) {
            items.add((Object)new ItemStack((Block)this, 1, 0));
            items.add((Object)new ItemStack((Block)this, 1, 1));
        }
    }

    @Override
    public List<ModelResourceLocation> getVariantModels() {
        ArrayList<ModelResourceLocation> rlist = new ArrayList<ModelResourceLocation>();
        rlist.add(new ModelResourceLocation(this.getRegistryName(), "cracked=0"));
        rlist.add(new ModelResourceLocation(this.getRegistryName(), "cracked=5"));
        return rlist;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return (player.func_184812_l_() || this.isBroken(state) && this.exposedToElements(world, pos)) && super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean exposedToElements(World world, BlockPos pos) {
        boolean isWaterAbove;
        Biome biome = world.func_180494_b(pos);
        boolean isHot = biome.func_150561_m() == Biome.TempCategory.WARM;
        boolean isRaining = world.func_175727_C(pos);
        boolean isCold = biome.func_150559_j();
        boolean isHumid = biome.func_76738_d();
        boolean isDaytime = world.func_72935_r();
        boolean bl = isWaterAbove = world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151586_h;
        if (isHot && !isHumid && isDaytime) {
            return true;
        }
        if (isCold && isRaining) {
            return true;
        }
        return isWaterAbove;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        float modifier = 1.0f;
        if (!this.exposedToElements(worldIn, pos)) {
            modifier = 15.0f;
        }
        return super.func_176195_g(blockState, worldIn, pos) * modifier;
    }

    @Override
    public String getVariantName(int meta) {
        return meta > 0 ? "broken" : null;
    }
}

