/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.block.BlockBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockModPane
extends BlockBase {
    public static PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private ArrayList<Block> compatiblePanes = new ArrayList();

    public void addCompatiblePane(Block block) {
        this.compatiblePanes.add(block);
    }

    protected BlockModPane(String name, Material materialIn) {
        super(name, materialIn);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean p_185477_7_) {
        AxisAlignedBB extX;
        state = state.func_185899_b((IBlockAccess)world, pos);
        float minY = 0.001f;
        float maxY = 0.999f;
        float minX = 0.4375f;
        float maxX = 0.5625f;
        float minZ = 0.4375f;
        float maxZ = 0.5625f;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            minZ = 0.0f;
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            maxZ = 1.0f;
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            minX = 0.0f;
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            maxX = 1.0f;
        }
        AxisAlignedBB stick = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625);
        BlockModPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)stick);
        if (minZ == 0.0f || maxZ == 1.0f) {
            extX = new AxisAlignedBB(0.4375, (double)minY, (double)minZ, 0.5625, (double)maxY, (double)maxZ);
            BlockModPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)extX);
        }
        if (minX == 0.0f || maxX == 1.0f) {
            extX = new AxisAlignedBB((double)minX, (double)minY, 0.4375, (double)maxX, (double)maxY, 0.5625);
            BlockModPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)extX);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_185899_b(world, pos);
        float minY = 0.0f;
        float maxY = 1.0f;
        float minX = 0.4375f;
        float maxX = 0.5625f;
        float minZ = 0.4375f;
        float maxZ = 0.5625f;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            minZ = 0.0f;
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            maxZ = 1.0f;
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            minX = 0.0f;
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            maxX = 1.0f;
        }
        return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return !(block instanceof BlockPane) && block == this || state.func_185914_p() || block.isSideSolid(state, world, pos, facing.func_176734_d()) || this.compatiblePanes.contains(block);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return !this.canConnectTo(blockAccess, pos.func_177972_a(side), side);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean north = this.canConnectTo(world, pos.func_177978_c(), EnumFacing.NORTH);
        boolean east = this.canConnectTo(world, pos.func_177974_f(), EnumFacing.EAST);
        boolean south = this.canConnectTo(world, pos.func_177968_d(), EnumFacing.SOUTH);
        boolean west = this.canConnectTo(world, pos.func_177976_e(), EnumFacing.WEST);
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(north)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(east)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(south)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(west));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        boolean connects = this.canConnectTo(worldIn, pos.func_177972_a(face), face);
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? (connects ? BlockFaceShape.MIDDLE_POLE_THIN : BlockFaceShape.UNDEFINED) : BlockFaceShape.CENTER_SMALL;
    }
}

