/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.block.BlockBase;
import betterwithaddons.item.rbdtools.ItemMatchPick;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLantern
extends BlockBase {
    public static PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    public static PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockLantern(String name, Material materialIn) {
        super(name, materialIn);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        boolean canStay = false;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!this.canBlockStay(worldIn, pos, facing)) continue;
            canStay = true;
        }
        return super.func_176196_c(worldIn, pos) && canStay;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDrop(worldIn, state, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos frompos) {
        super.func_189540_a(state, worldIn, pos, blockIn, frompos);
        this.checkAndDrop(worldIn, state, pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean isLit = (Boolean)state.func_177229_b((IProperty)LIT);
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!isLit && !heldItem.func_190926_b() && (heldItem.func_77973_b() instanceof ItemFlintAndSteel || heldItem.func_77973_b() instanceof ItemMatchPick)) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
            worldIn.func_184133_a(null, pos, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, 1.5f);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, 0.2f);
            heldItem.func_77972_a(1, (EntityLivingBase)playerIn);
            return true;
        }
        if (isLit && heldItem.func_190926_b() && playerIn.func_70093_af()) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
            worldIn.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 3.0f);
            return true;
        }
        return false;
    }

    public void checkAndDrop(World worldIn, IBlockState state, BlockPos pos) {
        if (!worldIn.field_72995_K && !this.canBlockStay(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, EnumFacing attachDir) {
        BlockPos attachPos = pos.func_177972_a(attachDir);
        IBlockState attach = worldIn.func_180495_p(attachPos);
        return this.isSuitableAttachment(attach.func_193401_d((IBlockAccess)worldIn, attachPos, attachDir.func_176734_d()), attachDir);
    }

    private boolean isSuitableAttachment(BlockFaceShape shape, EnumFacing attachDir) {
        switch (shape) {
            case SOLID: 
            case CENTER_BIG: {
                return true;
            }
            case CENTER_SMALL: {
                return attachDir == EnumFacing.DOWN;
            }
            case CENTER: {
                return attachDir.func_176740_k() == EnumFacing.Axis.Y;
            }
        }
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing attachDir = facing.func_176734_d();
        if (this.canBlockStay(worldIn, pos, attachDir)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)attachDir);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canBlockStay(worldIn, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 8) == 8));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() | ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 8 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIT, FACING});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN && state.func_177229_b((IProperty)FACING) == EnumFacing.DOWN ? BlockFaceShape.CENTER_BIG : BlockFaceShape.UNDEFINED;
    }
}

