/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.BetterWithAddons;
import betterwithaddons.block.ColorHandlers;
import betterwithaddons.block.IColorable;
import betterwithaddons.block.ModBlocks;
import betterwithaddons.util.IHasVariants;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockSand;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockExtraGrass
extends BlockGrass
implements IColorable,
IHasVariants {
    private boolean disabled;
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", ExtraGrassType.class);

    @Override
    public IBlockColor getBlockColor() {
        return ColorHandlers.GRASS_COLORING;
    }

    @Override
    public IItemColor getItemColor() {
        return ColorHandlers.BLOCK_ITEM_COLORING;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176498_a, VARIANT});
    }

    public BlockExtraGrass() {
        this.func_149711_c(0.6f);
        this.setHarvestLevel("shovel", 0);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)field_176498_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)VARIANT, (Comparable)((Object)ExtraGrassType.FARM)));
        this.func_149663_c("extra_grass");
        this.setRegistryName(new ResourceLocation("betterwithaddons", "extra_grass"));
        this.func_149647_a(BetterWithAddons.instance.creativeTab);
    }

    @Override
    public List<ModelResourceLocation> getVariantModels() {
        ArrayList<ModelResourceLocation> rlist = new ArrayList<ModelResourceLocation>();
        rlist.add(new ModelResourceLocation(this.getRegistryName(), "snowy=false,variant=" + ExtraGrassType.FARM.func_176610_l()));
        rlist.add(new ModelResourceLocation(this.getRegistryName(), "snowy=false,variant=" + ExtraGrassType.CLAY.func_176610_l()));
        rlist.add(new ModelResourceLocation(this.getRegistryName(), "snowy=false,variant=" + ExtraGrassType.SAND.func_176610_l()));
        rlist.add(new ModelResourceLocation(this.getRegistryName(), "snowy=false,variant=" + ExtraGrassType.REDSAND.func_176610_l()));
        return rlist;
    }

    @Override
    public String getVariantName(int meta) {
        return ExtraGrassType.values()[meta].func_176610_l();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab.equals((Object)BetterWithAddons.instance.creativeTab)) {
            items.add((Object)new ItemStack((Block)this, 1, 0));
            items.add((Object)new ItemStack((Block)this, 1, 1));
            items.add((Object)new ItemStack((Block)this, 1, 2));
            items.add((Object)new ItemStack((Block)this, 1, 3));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)ExtraGrassType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((ExtraGrassType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public boolean canSustainPlantType(IBlockAccess world, BlockPos pos, EnumPlantType plantType) {
        IBlockState state = world.func_180495_p(pos);
        switch ((ExtraGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case FARM: {
                if (plantType != EnumPlantType.Crop) break;
                return true;
            }
            case SAND: 
            case REDSAND: {
                if (plantType != EnumPlantType.Desert) break;
                return true;
            }
        }
        switch (plantType) {
            case Plains: 
            case Cave: {
                return true;
            }
            case Beach: {
                return !world.func_175623_d(pos.func_177974_f()) && world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || !world.func_175623_d(pos.func_177976_e()) && world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || !world.func_175623_d(pos.func_177978_c()) && world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || !world.func_175623_d(pos.func_177968_d()) && world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
            }
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState blockstate, IBlockAccess world, BlockPos blockpos, EnumFacing facing, IPlantable plantable) {
        return this.canSustainPlantType(world, blockpos, plantable.getPlantType(world, blockpos));
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        switch ((ExtraGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case SAND: 
            case REDSAND: {
                if (!(world.getBiomeForCoordsBody(pos).func_185353_n() >= 2.0f)) break;
                break;
            }
        }
        this.spreadGrass(world, pos, state, rand, 4, 1, 3, 1);
    }

    public void spreadGrass(World world, BlockPos pos, IBlockState state, Random rand, int tries, int xzSpread, int downSpread, int upSpread) {
        if (world.func_175671_l(pos.func_177984_a()) < 4 && world.func_180495_p(pos.func_177984_a()).func_177230_c().func_149717_k(world.func_180495_p(pos.func_177984_a())) > 2) {
            world.func_175656_a(pos, BlockExtraGrass.getDirtBlockState(state));
        } else if (world.func_175671_l(pos.func_177984_a()) >= 9) {
            for (int i = 0; i < tries; ++i) {
                BlockPos pos1 = pos.func_177982_a(rand.nextInt(xzSpread * 2 + 1) - xzSpread, rand.nextInt(downSpread + upSpread + 1) - downSpread, rand.nextInt(xzSpread * 2 + 1) - xzSpread);
                IBlockState target = world.func_180495_p(pos1);
                Block blockAboveTarget = world.func_180495_p(pos1.func_177984_a()).func_177230_c();
                IBlockState targetGrass = BlockExtraGrass.spreadsToGrass(state, target);
                if (targetGrass == null || world.func_175671_l(pos1.func_177984_a()) < 4 || blockAboveTarget.func_149717_k(target) > 2) continue;
                world.func_175656_a(pos1, targetGrass);
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public boolean isClay(IBlockState state) {
        return state.func_177229_b((IProperty)VARIANT) == ExtraGrassType.CLAY;
    }

    public int quantityDropped(IBlockState state, int n, Random random) {
        return this.isClay(state) ? 4 : 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.isClay(state) ? Items.field_151119_aD : Item.func_150898_a((Block)BlockExtraGrass.getDirtBlock(state));
    }

    public int func_180651_a(IBlockState state) {
        return this.isClay(state) ? 0 : BlockExtraGrass.getDirtBlockMeta(state);
    }

    public static IBlockState getDirtBlockState(IBlockState state) {
        switch ((ExtraGrassType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case CLAY: {
                return Blocks.field_150435_aG.func_176223_P();
            }
            case SAND: {
                return Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.SAND);
            }
            case REDSAND: {
                return Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND);
            }
        }
        return Blocks.field_150346_d.func_176203_a(BlockDirt.DirtType.DIRT.func_176925_a());
    }

    public static Block getDirtBlock(IBlockState state) {
        return BlockExtraGrass.getDirtBlockState(state).func_177230_c();
    }

    public static int getDirtBlockMeta(IBlockState state) {
        return BlockExtraGrass.getDirtBlock(state).func_176201_c(BlockExtraGrass.getDirtBlockState(state));
    }

    public static IBlockState spreadsToGrass(IBlockState source, IBlockState target) {
        if (target.func_177230_c() == Blocks.field_150346_d && target.func_177229_b((IProperty)BlockDirt.field_176386_a) == BlockDirt.DirtType.DIRT) {
            return Blocks.field_150349_c.func_176223_P();
        }
        if (target.func_177230_c() == Blocks.field_150435_aG) {
            return ModBlocks.GRASS.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)ExtraGrassType.CLAY));
        }
        if (target.func_177230_c() == Blocks.field_150354_m) {
            if (target.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.SAND) {
                return ModBlocks.GRASS.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)ExtraGrassType.SAND));
            }
            if (target.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND) {
                return ModBlocks.GRASS.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)ExtraGrassType.REDSAND));
            }
        }
        return null;
    }

    public static enum ExtraGrassType implements IStringSerializable
    {
        FARM,
        CLAY,
        SAND,
        REDSAND;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

