/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.world.gen;

import java.util.Random;
import net.daveyx0.primitivemobs.config.PrimitiveMobsConfigMobs;
import net.daveyx0.primitivemobs.config.PrimitiveMobsConfigSpecial;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenMimic
implements IWorldGenerator {
    private void generateMimicChest(Random rand, World world, BlockPos pos) {
        BlockPos tempPos = new BlockPos(pos.func_177958_n() + rand.nextInt(16) + 8, 0, pos.func_177952_p() + rand.nextInt(16) + 8);
        BlockPos newPos = this.getAboveSolidOrLiquidBlock(world, tempPos);
        if (newPos != null) {
            world.func_175656_a(newPos, Blocks.field_150486_ae.func_176223_P());
            TileEntity tileEntity = world.func_175625_s(newPos);
            if (tileEntity instanceof TileEntityChest) {
                ((TileEntityChest)tileEntity).getTileData().func_74768_a("Mimic", 1);
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int chance = PrimitiveMobsConfigSpecial.getMimicRarity();
        if (PrimitiveMobsConfigMobs.enableMimic && PrimitiveMobsConfigSpecial.getMimicGeneratesInCaves() && chance > 0 && world.field_73011_w.getDimension() == 0 && random.nextInt(chance) == 0) {
            BlockPos basePos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
            this.generateMimicChest(random, world, basePos);
        }
    }

    public BlockPos getAboveSolidOrLiquidBlock(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        BlockPos blockpos = null;
        for (int i = 5; i < 40; ++i) {
            blockpos = new BlockPos(pos.func_177958_n(), i, pos.func_177952_p());
            BlockPos blockpos1 = blockpos.func_177977_b();
            IBlockState state1 = chunk.func_177435_g(blockpos1);
            if (world.func_175623_d(blockpos) && state1.func_185904_a().func_76230_c() && !state1.func_177230_c().isLeaves(state1, (IBlockAccess)world, blockpos1) && !state1.func_177230_c().isFoliage((IBlockAccess)world, blockpos1)) break;
            blockpos = null;
        }
        return blockpos;
    }
}

