/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.passive;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.awt.Color;
import javax.annotation.Nullable;
import net.daveyx0.multimob.entity.IMultiMobPassive;
import net.daveyx0.multimob.message.MMMessageRegistry;
import net.daveyx0.multimob.message.MessageMMParticle;
import net.daveyx0.multimob.util.ColorUtil;
import net.daveyx0.multimob.util.EntityUtil;
import net.daveyx0.multimob.util.NBTUtil;
import net.daveyx0.primitivemobs.config.PrimitiveMobsConfigSpecial;
import net.daveyx0.primitivemobs.core.PrimitiveMobs;
import net.daveyx0.primitivemobs.core.PrimitiveMobsItems;
import net.daveyx0.primitivemobs.core.PrimitiveMobsSoundEvents;
import net.daveyx0.primitivemobs.entity.ai.EntityAIGroveSpriteTempt;
import net.daveyx0.primitivemobs.item.ItemGroveSpriteSap;
import net.daveyx0.primitivemobs.message.MessagePrimitiveColorSap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGroveSprite
extends EntityCreature
implements IMultiMobPassive {
    private float LeavesR = 0.0f;
    private float LeavesG = 0.0f;
    private float LeavesB = 0.0f;
    private float LogR = 0.0f;
    private float LogG = 0.0f;
    private float LogB = 0.0f;
    private float LogTopR = 0.0f;
    private float LogTopG = 0.0f;
    private float LogTopB = 0.0f;
    private boolean changedColor = false;
    private static final DataParameter<Boolean> IS_CINDER = EntityDataManager.func_187226_a(EntityGroveSprite.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SAPLING_AMOUNT = EntityDataManager.func_187226_a(EntityGroveSprite.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<IBlockState>> LEAVES = EntityDataManager.func_187226_a(EntityGroveSprite.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Optional<IBlockState>> LOG = EntityDataManager.func_187226_a(EntityGroveSprite.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<BlockPos> LEAVES_POS = EntityDataManager.func_187226_a(EntityGroveSprite.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> IS_BEGGING = EntityDataManager.func_187226_a(EntityGroveSprite.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CAN_DESPAWN = EntityDataManager.func_187226_a(EntityGroveSprite.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SAPLING_TIMER = EntityDataManager.func_187226_a(EntityGroveSprite.class, (DataSerializer)DataSerializers.field_187192_b);
    protected Block spawnableBlock = Blocks.field_150349_c;

    public EntityGroveSprite(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 1.0f);
        this.field_82174_bp[0] = 1.0f;
        this.field_82174_bp[1] = 1.0f;
    }

    protected void func_184651_r() {
        int prio = 0;
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIManageSaplings(this));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIGroveSpriteTempt(this, 1.1, false, Sets.newHashSet((Object[])new ItemStack[]{this.func_184614_ca(), new ItemStack(Items.field_151100_aR, 1, 15)})));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        int attackPrio = 1;
        this.field_70715_bh.func_75776_a(++attackPrio, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (!this.func_130014_f_().field_72995_K) {
            this.determineLogAndLeaves();
            ItemStack sapling = new ItemStack(this.getLeaves().func_177230_c().func_180660_a(this.getLeaves(), this.field_70146_Z, 100), 1, this.getLeaves().func_177230_c().func_180651_a(this.getLeaves()));
            ItemStack sap = new ItemStack((Item)PrimitiveMobsItems.WONDER_SAP, 1);
            if (this.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && !sapling.func_190926_b()) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, sapling);
            }
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, sap);
            this.setSaplingAmount(1 + this.field_70146_Z.nextInt(4));
            this.setSaplingTimer(this.field_70146_Z.nextInt(1000) + 1000);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    private void determineLogAndLeaves() {
        Object[] tree = null;
        if (PrimitiveMobs.proxy.DynamicTreesInt != null) {
            tree = PrimitiveMobs.proxy.DynamicTreesInt.searchDynamicTree((EntityLiving)this, 10.0);
        }
        if (tree == null || tree.length == 0) {
            tree = EntityUtil.searchTree((Entity)this, (double)10.0);
        }
        if (tree != null && tree.length > 0) {
            this.setLog((IBlockState)tree[0]);
            this.setLeaves((IBlockState)tree[1]);
            this.setLeavesPos((BlockPos)tree[2]);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23000000298023224);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    protected void func_70088_a() {
        Optional leaves = Optional.of((Object)Blocks.field_150362_t.func_176223_P());
        Optional log = Optional.of((Object)Blocks.field_150364_r.func_176223_P());
        this.func_184212_Q().func_187214_a(IS_CINDER, (Object)false);
        this.func_184212_Q().func_187214_a(SAPLING_AMOUNT, (Object)0);
        this.func_184212_Q().func_187214_a(LEAVES, (Object)leaves);
        this.func_184212_Q().func_187214_a(LOG, (Object)log);
        this.func_184212_Q().func_187214_a(LEAVES_POS, (Object)new BlockPos(0, 0, 0));
        this.func_184212_Q().func_187214_a(CAN_DESPAWN, (Object)true);
        this.func_184212_Q().func_187214_a(IS_BEGGING, (Object)false);
        this.func_184212_Q().func_187214_a(SAPLING_TIMER, (Object)0);
        super.func_70088_a();
    }

    public void func_70071_h_() {
        if (this.func_70083_f(0)) {
            this.setCinderSprite(true);
            this.changedColor = false;
        }
        if (this.isCinderSprite()) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O + (double)0.2f, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        } else {
            this.setSaplingTimer(this.getSaplingTimer() - 1);
            if (this.getSaplingTimer() <= 0) {
                this.setSaplingAmount(this.getSaplingAmount() + 1);
                for (int i = 0; i < 8; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat() + 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                }
                this.setSaplingTimer(this.field_70146_Z.nextInt(1000) + 1000);
            }
        }
        if (this.func_130014_f_().field_72995_K && !this.changedColor) {
            this.changedColor = true;
            if (!this.isCinderSprite()) {
                this.setLeavesRGB(this.getColor(this.func_130014_f_(), this.getLeaves(), this.getLeavesPos(), null));
                this.setLogRGB(this.getColor(this.func_130014_f_(), this.getLog(), null, EnumFacing.WEST));
                this.setLogTopRGB(this.getColor(this.func_130014_f_(), this.getLog(), null, null));
                ItemStack clientSap = this.func_184592_cb();
                if (this.getLog() != null) {
                    int[] logTop = this.getColor(this.field_70170_p, this.getLog(), null, null);
                    Color logTopColor = new Color(logTop[0], logTop[1], logTop[2]);
                    ItemGroveSpriteSap.setColor(clientSap, logTopColor.hashCode());
                    MMMessageRegistry.getNetwork().sendToServer((IMessage)new MessagePrimitiveColorSap(ItemGroveSpriteSap.getColor(clientSap), this.func_110124_au().toString()));
                }
            } else {
                this.setLeavesRGB(new int[]{177, 100, 0});
                this.setLogRGB(new int[]{90, 86, 80});
                this.setLogTopRGB(new int[]{102, 98, 94});
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Blocks.field_150478_aa));
                this.field_70178_ae = true;
            }
        }
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if ((source == DamageSource.field_76370_b || source == DamageSource.field_76371_c || source == DamageSource.field_76368_d) && this.isCinderSprite()) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if (this.isCinderSprite()) {
                entityIn.func_70015_d(8);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public int[] getColor(World worldIn, IBlockState state, @Nullable BlockPos pos, @Nullable EnumFacing face) {
        if (state.func_177230_c() != Blocks.field_150350_a) {
            int[] newColor = new int[3];
            newColor = face != null ? ColorUtil.getBlockStateColor((IBlockState)state, (BlockPos)pos, (World)worldIn, (EnumFacing)face, (boolean)true) : ColorUtil.getBlockStateColor((IBlockState)state, (BlockPos)pos, (World)worldIn, (boolean)true);
            if (newColor != null) {
                if (ColorUtil.isColorInvalid((int[])newColor)) {
                    if (state.func_177230_c() == this.getLeaves().func_177230_c()) {
                        newColor = new int[]{79, 146, 38, 255};
                    } else if (state.func_177230_c() == this.getLog().func_177230_c() && face == EnumFacing.WEST) {
                        newColor = new int[]{70, 59, 46, 255};
                    } else if (state.func_177230_c() == this.getLeaves().func_177230_c()) {
                        newColor = new int[]{152, 126, 98, 255};
                    }
                }
                return newColor;
            }
        }
        return new int[]{255, 255, 255, 255};
    }

    public EntityItem dropItemStack(ItemStack itemIn, float offsetY) {
        return this.func_70099_a(itemIn, offsetY);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == this.func_184614_ca().func_77973_b() && itemstack.func_77960_j() == this.func_184614_ca().func_77960_j();
        if (this.isCinderSprite()) {
            return false;
        }
        if (flag) {
            this.consumeItemFromStack(player, itemstack);
            if (((Boolean)this.field_70180_af.func_187225_a(CAN_DESPAWN)).booleanValue()) {
                this.setCanDespawn(false);
            }
            this.setSaplingAmount(this.getSaplingAmount() + 1);
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat() + 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
            }
            this.func_184185_a(PrimitiveMobsSoundEvents.ENTITY_GROVESPRITE_THANKS, 1.0f, 1.0f);
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_151014_N) {
            this.consumeItemFromStack(player, itemstack);
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat() + 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
            }
            this.func_184185_a(PrimitiveMobsSoundEvents.ENTITY_GROVESPRITE_THANKS, 1.0f, 1.0f);
            this.func_70606_j(this.func_110138_aP());
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_151100_aR && itemstack.func_77960_j() == 15 && this.getSaplingAmount() > 0) {
            if (this.getLog() != null) {
                this.consumeItemFromStack(player, itemstack);
                for (int i = 0; i < 8; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT_MAGIC, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat() + 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                }
                this.setSaplingAmount(this.getSaplingAmount() - 1);
                this.func_184185_a(PrimitiveMobsSoundEvents.ENTITY_GROVESPRITE_THANKS, 1.0f, 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    ItemStack sap = this.func_184592_cb().func_77946_l();
                    sap.func_190920_e(this.field_70146_Z.nextInt(4) + 1);
                    EntityItem item = this.func_70099_a(sap, 1.0f);
                    item.func_174869_p();
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void dropWonderSap() {
    }

    protected void consumeItemFromStack(EntityPlayer player, ItemStack stack) {
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (this.isCinderSprite()) {
            ItemStack coal = new ItemStack(Items.field_151044_h, this.field_70146_Z.nextInt(5) + lootingModifier);
            EntityItem entityItem = this.func_70099_a(coal, 1.0f);
        }
    }

    protected float func_70647_i() {
        return this.isCinderSprite() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.5f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f;
    }

    public float[] getLeavesRGB() {
        return new float[]{this.LeavesR, this.LeavesG, this.LeavesB};
    }

    public void setLeavesRGB(int[] RGB) {
        this.LeavesR = RGB[0];
        this.LeavesG = RGB[1];
        this.LeavesB = RGB[2];
    }

    public float[] getLogRGB() {
        return new float[]{this.LogR, this.LogG, this.LogB};
    }

    public void setLogRGB(int[] RGB) {
        this.LogR = RGB[0];
        this.LogG = RGB[1];
        this.LogB = RGB[2];
    }

    public float[] getLogTopRGB() {
        return new float[]{this.LogTopR, this.LogTopG, this.LogTopB};
    }

    public void setLogTopRGB(int[] RGB) {
        this.LogTopR = RGB[0];
        this.LogTopG = RGB[1];
        this.LogTopB = RGB[2];
    }

    public void setCinderSprite(boolean cinder) {
        this.func_184212_Q().func_187227_b(IS_CINDER, (Object)cinder);
    }

    public boolean isCinderSprite() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CINDER);
    }

    public void setSaplingAmount(int saplings) {
        this.func_184212_Q().func_187227_b(SAPLING_AMOUNT, (Object)saplings);
    }

    public int getSaplingAmount() {
        return (Integer)this.func_184212_Q().func_187225_a(SAPLING_AMOUNT);
    }

    public void setSaplingTimer(int timer) {
        this.func_184212_Q().func_187227_b(SAPLING_TIMER, (Object)timer);
    }

    public int getSaplingTimer() {
        return (Integer)this.func_184212_Q().func_187225_a(SAPLING_TIMER);
    }

    public void setLeaves(IBlockState leaves) {
        Optional newLeaves = Optional.of((Object)leaves);
        this.func_184212_Q().func_187227_b(LEAVES, (Object)newLeaves);
    }

    public IBlockState getLeaves() {
        Optional state = (Optional)this.func_184212_Q().func_187225_a(LEAVES);
        return state != null && state.isPresent() ? (IBlockState)state.get() : Blocks.field_150362_t.func_176223_P();
    }

    public void setLog(IBlockState log) {
        Optional newLog = Optional.of((Object)log);
        this.func_184212_Q().func_187227_b(LOG, (Object)newLog);
    }

    public IBlockState getLog() {
        Optional state = (Optional)this.func_184212_Q().func_187225_a(LOG);
        return state != null && state.isPresent() ? (IBlockState)state.get() : Blocks.field_150364_r.func_176223_P();
    }

    public void setLeavesPos(BlockPos pos) {
        this.func_184212_Q().func_187227_b(LEAVES_POS, (Object)pos);
    }

    public BlockPos getLeavesPos() {
        BlockPos pos = (BlockPos)this.func_184212_Q().func_187225_a(LEAVES_POS);
        return pos != null ? pos : new BlockPos(0, 0, 0);
    }

    protected SoundEvent func_184639_G() {
        return PrimitiveMobsSoundEvents.ENTITY_GROVESPRITE_IDLE;
    }

    public void setIsBegging(boolean begging) {
        this.func_184212_Q().func_187227_b(IS_BEGGING, (Object)begging);
    }

    public boolean isBegging() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_BEGGING);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public void setCanDespawn(boolean b) {
        this.field_70180_af.func_187227_b(CAN_DESPAWN, (Object)b);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTUtil.setBlockPosToNBT((BlockPos)this.getLeavesPos(), (String)"LeavesPos", (NBTTagCompound)compound);
        NBTUtil.setBlockStateToNBT((IBlockState)this.getLeaves(), (String)"LeavesState", (NBTTagCompound)compound);
        NBTUtil.setBlockStateToNBT((IBlockState)this.getLog(), (String)"LogState", (NBTTagCompound)compound);
        compound.func_74768_a("SaplingAmount", this.getSaplingAmount());
        compound.func_74768_a("SaplingTimer", this.getSaplingTimer());
        compound.func_74757_a("isCinder", this.isCinderSprite());
        compound.func_74757_a("canDespawn", ((Boolean)this.field_70180_af.func_187225_a(CAN_DESPAWN)).booleanValue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setLeavesPos(NBTUtil.getBlockPosFromNBT((String)"LeavesPos", (NBTTagCompound)compound));
        this.setLeaves(NBTUtil.getBlockStateFromNBT((String)"LeavesState", (NBTTagCompound)compound));
        this.setLog(NBTUtil.getBlockStateFromNBT((String)"LogState", (NBTTagCompound)compound));
        this.setSaplingAmount(compound.func_74762_e("SaplingAmount"));
        this.setSaplingTimer(compound.func_74762_e("SaplingTimer"));
        this.setCinderSprite(compound.func_74767_n("isCinder"));
        this.setCanDespawn(compound.func_74767_n("canDespawn"));
    }

    protected boolean func_70692_ba() {
        return (Boolean)this.field_70180_af.func_187225_a(CAN_DESPAWN);
    }

    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos blockpos = new BlockPos(i, j, k);
        return this.func_130014_f_().func_180495_p(blockpos.func_177977_b()).func_177230_c() == this.spawnableBlock && this.func_130014_f_().func_175699_k(blockpos) > 8 && super.func_70601_bi();
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        return super.isCreatureType(type, forSpawnCount);
    }

    static class EntityAIManageSaplings
    extends EntityAIMoveToBlock {
        private final EntityGroveSprite sprite;
        private int manageDelay = 0;
        boolean isNearGoal = false;
        int type = 0;
        private int timeoutCounter;
        boolean placeSapling = true;
        boolean hasChosen = false;

        public EntityAIManageSaplings(EntityGroveSprite sprite) {
            super((EntityCreature)sprite, (double)0.7f, 16);
            this.sprite = sprite;
            this.manageDelay = sprite.field_70170_p.field_73012_v.nextInt(100) + 100;
        }

        public boolean func_75250_a() {
            --this.manageDelay;
            return this.searchForDestination() && this.manageDelay <= 0;
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.sprite.func_70671_ap().func_75650_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)this.field_179494_b.func_177956_o(), (double)this.field_179494_b.func_177952_p() + 0.5, 10.0f, (float)this.sprite.func_70646_bf());
            if (this.sprite.func_174831_c(this.field_179494_b.func_177984_a()) < 12.0) {
                this.isNearGoal = true;
            }
            if (this.func_179487_f()) {
                if (this.type == 0) {
                    this.manageDelay = this.sprite.field_70170_p.field_73012_v.nextInt(200) + 200;
                    ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, 1, 15), (World)this.sprite.field_70170_p, (BlockPos)this.field_179494_b);
                    MMMessageRegistry.getNetwork().sendToAll((IMessage)new MessageMMParticle(EnumParticleTypes.VILLAGER_HAPPY.func_179348_c(), 10, (float)this.field_179494_b.func_177958_n() + 0.5f + (this.sprite.field_70146_Z.nextFloat() - this.sprite.field_70146_Z.nextFloat()), (float)this.field_179494_b.func_177956_o() + 0.5f, (float)this.field_179494_b.func_177952_p() + 0.5f + (this.sprite.field_70146_Z.nextFloat() - this.sprite.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0, 0));
                    this.isNearGoal = false;
                } else {
                    this.manageDelay = this.sprite.field_70170_p.field_73012_v.nextInt(300) + 300;
                    ItemStack heldItem = this.sprite.func_184614_ca();
                    if (heldItem != null && !heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemBlock) {
                        ItemBlock item = (ItemBlock)heldItem.func_77973_b();
                        item.placeBlockAt(heldItem, null, this.sprite.field_70170_p, this.field_179494_b, EnumFacing.NORTH, 0.0f, 0.0f, 0.0f, item.func_179223_d().func_176203_a(this.sprite.func_184614_ca().func_77960_j()));
                        this.sprite.field_70170_p.func_184134_a((double)this.field_179494_b.func_177958_n(), (double)this.field_179494_b.func_177956_o(), (double)this.field_179494_b.func_177952_p(), SoundEvents.field_187567_bP, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                        this.sprite.setSaplingAmount(this.sprite.getSaplingAmount() - 1);
                    }
                    this.isNearGoal = false;
                }
                this.hasChosen = false;
                this.placeSapling = true;
            }
        }

        private boolean searchForDestination() {
            int i = 16;
            boolean j = true;
            BlockPos blockpos = new BlockPos((Entity)this.sprite);
            boolean flag = this.sprite.func_130014_f_().func_82736_K().func_82766_b("mobGriefing");
            if (!(flag && PrimitiveMobsConfigSpecial.getGroveSpritesPlant() || this.sprite.getSaplingAmount() > 0 && (this.hasChosen || this.sprite.field_70146_Z.nextInt(20) == 0))) {
                this.placeSapling = false;
            }
            this.hasChosen = true;
            int k = 0;
            while (k <= 1) {
                for (int l = 0; l < i; ++l) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            BlockPos blockpos1 = blockpos.func_177982_a(i1, k - 1, j1);
                            if (this.sprite.func_180485_d(blockpos1)) {
                                if (this.placeSapling && this.sprite.getSaplingAmount() > 0 && this.func_179488_a(this.sprite.field_70170_p, blockpos1)) {
                                    this.field_179494_b = blockpos1;
                                    this.type = 1;
                                    return true;
                                }
                                if (!this.placeSapling && this.shouldMoveToSapling(this.sprite.field_70170_p, blockpos1)) {
                                    this.field_179494_b = blockpos1;
                                    this.type = 0;
                                    return true;
                                }
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                }
                k = k > 0 ? -k : 1 - k;
            }
            this.hasChosen = false;
            return false;
        }

        protected boolean func_179487_f() {
            return this.isNearGoal;
        }

        protected boolean shouldMoveToSapling(World worldIn, BlockPos pos) {
            ItemStack heldItem = this.sprite.func_184614_ca();
            if (heldItem != null && !heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemBlock) {
                Block block;
                ItemStack droppedItem;
                IBlockState state = worldIn.func_180495_p(pos);
                ItemBlock item = (ItemBlock)heldItem.func_77973_b();
                if (state != null && state.func_177230_c() != this.sprite.getLeaves().func_177230_c() && (droppedItem = new ItemStack((block = worldIn.func_180495_p(pos).func_177230_c()).func_180660_a(state, this.sprite.field_70146_Z, 100), 1, block.func_180651_a(state))) != null && this.sprite.func_184614_ca() != null && this.sprite.func_184614_ca().func_77973_b() == droppedItem.func_77973_b() && this.sprite.func_184614_ca().func_77960_j() == droppedItem.func_77960_j() && worldIn.func_175623_d(pos = pos.func_177984_a())) {
                    return true;
                }
            }
            return false;
        }

        protected boolean func_179488_a(World worldIn, BlockPos pos) {
            ItemStack heldItem = this.sprite.func_184614_ca();
            if (heldItem != null && !heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemBlock) {
                ItemBlock item = (ItemBlock)heldItem.func_77973_b();
                Block block = worldIn.func_180495_p(pos).func_177230_c();
                if (block != null && block.func_176196_c(worldIn, pos)) {
                    return true;
                }
            }
            return false;
        }
    }
}

