/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.monster;

import javax.annotation.Nullable;
import net.daveyx0.multimob.entity.IMultiMob;
import net.daveyx0.multimob.entity.ai.EntityAISenseEntityNearestPlayer;
import net.daveyx0.multimob.message.MMMessageRegistry;
import net.daveyx0.multimob.message.MessageMMParticle;
import net.daveyx0.multimob.util.NBTUtil;
import net.daveyx0.primitivemobs.config.PrimitiveMobsConfigSpecial;
import net.daveyx0.primitivemobs.core.PrimitiveMobsSoundEvents;
import net.daveyx0.primitivemobs.entity.IAnimatedMob;
import net.daveyx0.primitivemobs.entity.ai.EntityAITrollagerAttacks;
import net.daveyx0.primitivemobs.entity.item.EntityThrownBlock;
import net.daveyx0.primitivemobs.entity.monster.EntityGoblin;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityTrollager
extends EntityMob
implements IAnimatedMob,
IMultiMob {
    private static final DataParameter<Integer> ANIMATION_STATE = EntityDataManager.func_187226_a(EntityTrollager.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> CURRENT_THROWN_BLOCK = EntityDataManager.func_187226_a(EntityTrollager.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> IS_STONE = EntityDataManager.func_187226_a(EntityTrollager.class, (DataSerializer)DataSerializers.field_187198_h);
    private int previousState = 0;
    private float animVar = 0.0f;
    private float previousYawStone = -2.0f;
    private float previousPitchStone = -2.0f;
    private float previousYawHeadStone = -2.0f;
    public boolean isBeingSupported;

    public EntityTrollager(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.25f, 3.0f);
        this.isBeingSupported = false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_184651_r() {
        int prio = 0;
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(++prio, new EntityAITrollagerAttacks(this, 1.25, 2.5f, 20.0f));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(++prio, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        int attackPrio = 1;
        this.field_70715_bh.func_75776_a(++attackPrio, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(++attackPrio, (EntityAIBase)new EntityAISenseEntityNearestPlayer((EntityLiving)this, 40));
        this.field_70715_bh.func_75776_a(++attackPrio, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.field_70170_p.field_73012_v.nextInt(20) == 0) {
            EntityGoblin goblin = new EntityGoblin(this.field_70170_p);
            goblin.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            goblin.func_180482_a(difficulty, null);
            this.field_70170_p.func_72838_d((Entity)goblin);
            goblin.func_184220_m((Entity)this);
        }
        return livingdata;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.9;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_184207_aI() && !this.field_70170_p.field_72995_K) {
            EntityLiving ridingEntity;
            if (this.func_184188_bt().get(0) != null && this.func_184188_bt().get(0) instanceof EntityLivingBase && (ridingEntity = (EntityLiving)this.func_184188_bt().get(0)).func_70638_az() != null) {
                this.func_70624_b(ridingEntity.func_70638_az());
            }
            if (this.field_70123_F) {
                this.func_70664_aZ();
            }
        }
        if (this.func_70638_az() != null && this.func_70638_az().field_70128_L) {
            this.func_70624_b(null);
        }
        this.animationHandling();
        if (this.getAnimationState() != 1 && this.getAnimationState() != 2 && this.field_70173_aa % 5 == 0) {
            this.setThrowingBlockFromFloor();
        }
        if (this.isBeingSupported) {
            this.setStone(false);
        }
        if (this.isStone()) {
            this.func_70623_bb();
            this.func_70661_as().func_75484_a(null, 0.0);
            this.func_70624_b(null);
            this.func_94061_f(true);
            if (this.previousYawStone == -2.0f) {
                this.previousYawStone = this.field_70177_z;
                this.previousYawHeadStone = this.field_70759_as;
                this.previousPitchStone = this.field_70125_A;
            }
            this.func_70101_b(this.previousYawStone, this.previousPitchStone);
            this.func_70034_d(this.previousYawHeadStone);
            if (this.func_184207_aI() && this.func_184188_bt().get(0) != null) {
                ((Entity)this.func_184188_bt().get(0)).func_184210_p();
            }
        } else {
            this.previousPitchStone = -2.0f;
            this.previousYawHeadStone = -2.0f;
            this.previousYawStone = -2.0f;
            this.func_94061_f(false);
        }
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof EntityBoat) {
            if (entityIn.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entityIn);
            }
        } else if (entityIn.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entityIn);
        }
    }

    public boolean func_85031_j(Entity p_85031_1_) {
        if (this.isStone() && p_85031_1_ != null && p_85031_1_ instanceof EntityLivingBase) {
            ItemStack stack = ((EntityLivingBase)p_85031_1_).func_184582_a(EntityEquipmentSlot.MAINHAND);
            return stack == null || !stack.func_150998_b(Blocks.field_150348_b.func_176223_P());
        }
        return false;
    }

    public EntityItem dropItemStack(ItemStack itemIn, float offsetY) {
        return this.func_70099_a(itemIn, offsetY);
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (!this.isStone() && !this.func_130014_f_().field_72995_K) {
            int i = 1 + this.field_70146_Z.nextInt(2);
            if (lootingModifier > 0) {
                i += this.field_70146_Z.nextInt(lootingModifier + 1);
            }
            for (int j = 0; j < i; ++j) {
                ItemStack newStack = this.getRandomLoot();
                if (newStack == null) continue;
                this.dropItemStack(newStack, 1.0f);
            }
        } else if (this.isStone() && !this.func_130014_f_().field_72995_K) {
            this.dropItemStack(new ItemStack(Item.func_150898_a((Block)Blocks.field_150348_b), 32), 1.0f);
        }
    }

    public ItemStack getRandomLoot() {
        int chance = this.field_70146_Z.nextInt(100);
        if (chance > 50) {
            return new ItemStack(Item.func_150898_a((Block)Blocks.field_150343_Z));
        }
        if (chance > 10) {
            return new ItemStack(Items.field_151166_bC);
        }
        return new ItemStack(Items.field_151153_ao);
    }

    public void func_70636_d() {
        boolean flag = false;
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            float f = this.func_70013_c();
            if (this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
                ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
                if (!itemstack.func_190926_b()) {
                    this.setStone(false);
                } else {
                    this.setStone(true);
                }
            } else {
                this.setStone(false);
            }
        } else if (!this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            this.setStone(false);
        }
        super.func_70636_d();
    }

    public void setStone(boolean b) {
        this.field_70180_af.func_187227_b(IS_STONE, (Object)b);
    }

    public boolean isStone() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STONE);
    }

    public void animationHandling() {
        if (!this.isStone()) {
            if (this.getPreviousAnimationState() != this.getAnimationState()) {
                this.setPreviousAnimationState(this.getAnimationState());
                this.animVar = 0.0f;
            }
            this.animVar = this.animVar < 1.0f ? (this.animVar += 0.01f) : 1.0f;
        }
    }

    public void setThrowingBlockFromFloor() {
        for (int i = 1; i < 64; ++i) {
            BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b - (double)i, this.field_70161_v);
            if (blockPos == null) continue;
            if (this.getThrownBlock().equals((Object)blockPos)) break;
            IBlockState state = this.func_130014_f_().func_180495_p(blockPos);
            if (state == null || !state.func_177230_c().func_149730_j(state)) continue;
            this.setThrownBlock(blockPos);
            break;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANIMATION_STATE, (Object)0);
        this.field_70180_af.func_187214_a(CURRENT_THROWN_BLOCK, (Object)new BlockPos(0, 0, 0));
        this.field_70180_af.func_187214_a(IS_STONE, (Object)false);
    }

    @Override
    public void setAnimationState(int state) {
        this.field_70180_af.func_187227_b(ANIMATION_STATE, (Object)state);
    }

    @Override
    public int getAnimationState() {
        return (Integer)this.field_70180_af.func_187225_a(ANIMATION_STATE);
    }

    protected SoundEvent func_184639_G() {
        if (this.isStone()) {
            return null;
        }
        return PrimitiveMobsSoundEvents.ENTITY_TROLLAGER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        if (this.isStone()) {
            return SoundEvents.field_187835_fT;
        }
        return PrimitiveMobsSoundEvents.ENTITY_TROLLAGER_HIT;
    }

    protected SoundEvent func_184615_bR() {
        return PrimitiveMobsSoundEvents.ENTITY_TROLLAGER_DEATH;
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.5f;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187605_cG;
    }

    public boolean canBlockAreaSeeEntity(Entity entityIn) {
        boolean flag = true;
        for (int i = 0; i < 4; ++i) {
            flag = this.field_70170_p.func_147447_a(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + (double)i, this.field_70161_v), new Vec3d(entityIn.field_70165_t, entityIn.field_70163_u + (double)entityIn.func_70047_e(), entityIn.field_70161_v), false, true, false) == null;
        }
        return flag;
    }

    @Override
    public void performAction(EntityLivingBase target, int id) {
        switch (id) {
            case 0: {
                EntityThrownBlock thownBlock = new EntityThrownBlock(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, (EntityLivingBase)this, this.getThrownBlock());
                thownBlock.func_70012_b(this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, this.field_70177_z, 0.0f);
                thownBlock.field_70159_w = (target.field_70165_t - thownBlock.field_70165_t) / 18.0;
                thownBlock.field_70181_x = (target.field_70163_u - thownBlock.field_70163_u) / 18.0 + 0.5;
                thownBlock.field_70179_y = (target.field_70161_v - this.field_70161_v) / 18.0;
                this.func_130014_f_().func_72838_d((Entity)thownBlock);
                this.func_184185_a(PrimitiveMobsSoundEvents.ENTITY_TROLLAGER_ATTACK, this.func_70599_aP(), ((this.func_70681_au().nextFloat() - this.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                break;
            }
            case 1: {
                double distanceX = this.func_70671_ap().func_180423_e() - this.field_70165_t;
                double distanceZ = this.func_70671_ap().func_180421_g() - this.field_70161_v;
                double length = Math.sqrt(distanceX * distanceX + distanceZ * distanceZ);
                if (length != 0.0) {
                    distanceX /= length;
                    distanceZ /= length;
                }
                double addedHeight = 0.0;
                if (target.field_70163_u > this.field_70163_u) {
                    addedHeight = 0.5;
                } else if (target.field_70163_u < this.field_70163_u) {
                    addedHeight = -0.5;
                }
                double explosionX = this.field_70165_t + distanceX * 2.0;
                double explosionZ = this.field_70161_v + distanceZ * 2.0;
                double explosionY = this.field_70163_u + addedHeight;
                boolean flag = true;
                if (!this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") || !PrimitiveMobsConfigSpecial.getTrollDestruction()) {
                    flag = false;
                }
                this.newExplosion((Entity)this, explosionX, this.field_70163_u + (double)this.func_70047_e(), explosionZ, 3.0f, false, flag);
                MMMessageRegistry.getNetwork().sendToAll((IMessage)new MessageMMParticle(EnumParticleTypes.EXPLOSION_LARGE.func_179348_c(), 10, (float)explosionX, (float)explosionY, (float)explosionZ, 1.0, 0.0, 0.0, 0));
                this.func_184185_a(PrimitiveMobsSoundEvents.ENTITY_TROLLAGER_ATTACK, this.func_70599_aP(), ((this.func_70681_au().nextFloat() - this.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                break;
            }
            case 2: {
                if (this.func_70638_az() == null || this.isStone()) break;
                double d0 = this.getAttackReachSqr(this.func_70638_az()) + 4.0;
                double d1 = this.func_70092_e(this.func_70638_az().field_70165_t, this.func_70638_az().func_174813_aQ().field_72338_b, this.func_70638_az().field_70161_v);
                boolean flag = this.func_70635_at().func_75522_a((Entity)this.func_70638_az());
                if (d1 <= d0 && flag) {
                    this.func_70652_k((Entity)this.func_70638_az());
                }
                this.func_184185_a(PrimitiveMobsSoundEvents.ENTITY_TROLLAGER_ATTACK, this.func_70599_aP(), ((this.func_70681_au().nextFloat() - this.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
        }
    }

    protected double getAttackReachSqr(EntityLivingBase attackTarget) {
        return this.field_70130_N * 2.0f * this.field_70130_N * 2.0f + attackTarget.field_70130_N;
    }

    public Explosion newExplosion(@Nullable Entity entityIn, double x, double y, double z, float strength, boolean isFlaming, boolean isSmoking) {
        Explosion explosion = new Explosion(this.field_70170_p, entityIn, x, y, z, strength, isFlaming, isSmoking);
        if (ForgeEventFactory.onExplosionStart((World)this.field_70170_p, (Explosion)explosion)) {
            return explosion;
        }
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        return explosion;
    }

    public void setThrownBlock(BlockPos pos) {
        this.func_184212_Q().func_187227_b(CURRENT_THROWN_BLOCK, (Object)pos);
    }

    public BlockPos getThrownBlock() {
        BlockPos pos = (BlockPos)this.func_184212_Q().func_187225_a(CURRENT_THROWN_BLOCK);
        return pos != null ? pos : new BlockPos(0, 0, 0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTUtil.setBlockPosToNBT((BlockPos)this.getThrownBlock(), (String)"ThrownBlock", (NBTTagCompound)compound);
        compound.func_74757_a("Stone", this.isStone());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setThrownBlock(NBTUtil.getBlockPosFromNBT((String)"ThrownBlock", (NBTTagCompound)compound));
        this.setStone(compound.func_74767_n("Stone"));
    }

    @Override
    public int getPreviousAnimationState() {
        return this.previousState;
    }

    @Override
    public void setPreviousAnimationState(int state) {
        this.previousState = state;
    }

    @Override
    public float getAnimVar() {
        return this.animVar;
    }

    public boolean func_70601_bi() {
        boolean flag = true;
        if (this.field_70163_u > 40.0 && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            flag = this.field_70146_Z.nextInt(5) == 0;
        }
        return flag && super.func_70601_bi();
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        if (this.isStone()) {
            return entityIn.func_174813_aQ();
        }
        return super.func_70114_g(entityIn);
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        if (this.isStone()) {
            return this.func_174813_aQ();
        }
        return super.func_70046_E();
    }

    public boolean func_70058_J() {
        return !this.field_70170_p.func_72953_d(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72321_a(1.5, 1.5, 1.5)).isEmpty() && this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    @Override
    public void setAnimVar(float var) {
        this.animVar = var;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (type == EnumCreatureType.MONSTER) {
            return false;
        }
        return super.isCreatureType(type, forSpawnCount);
    }
}

