/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.discordrpc;

import de.erdbeerbaerlp.discordrpc.Command;
import de.erdbeerbaerlp.discordrpc.DRPCEventHandler;
import de.erdbeerbaerlp.discordrpc.DRPCLog;
import de.erdbeerbaerlp.discordrpc.Discord;
import de.erdbeerbaerlp.discordrpc.Message_Icon;
import de.erdbeerbaerlp.discordrpc.Message_Message;
import de.erdbeerbaerlp.discordrpc.RPCconfig;
import de.erdbeerbaerlp.discordrpc.RequestMessage;
import de.erdbeerbaerlp.discordrpc.ServerCommand;
import de.erdbeerbaerlp.discordrpc.ServerConfig;
import java.time.Instant;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="discordrpc", name="DiscordRichPresence", version="1.3.3", dependencies="required-after-client:eguilib", acceptedMinecraftVersions="[1.12,1.12.2]", acceptableRemoteVersions="*", guiFactory="de.erdbeerbaerlp.discordrpc.CfgGuiFactory", updateJSON="https://raw.githubusercontent.com/ErdbeerbaerLP/DiscordRichPresence/1.12/discordrpc.json")
public class ModClass {
    public static final String MODID = "discordrpc";
    public static final String VERSION = "1.3.3";
    public static final String NAME = "DiscordRichPresence";
    public static final long gameStarted = Instant.now().getEpochSecond();
    protected static final SimpleNetworkWrapper REQUEST = NetworkRegistry.INSTANCE.newSimpleChannel("DiscordReq");
    protected static final SimpleNetworkWrapper MSG = NetworkRegistry.INSTANCE.newSimpleChannel("DiscordMSG");
    protected static final SimpleNetworkWrapper ICO = NetworkRegistry.INSTANCE.newSimpleChannel("DiscordIcon");
    protected static boolean isEnabled = true;
    protected static boolean isClient = true;
    protected static boolean logtochat = false;
    protected static boolean preventConfigLoad = false;

    @Mod.EventHandler
    public void modConstruction(FMLConstructionEvent evt) {
        System.out.println("Constructing");
        if (evt.getSide() == Side.CLIENT) {
            DRPCLog.Info("Running on Client side... starting");
            isClient = true;
            if (!preventConfigLoad) {
                RPCconfig.loadConfigFromFile();
            }
            DRPCLog.Debug("Player UUID is " + Minecraft.func_71410_x().func_110432_I().func_148255_b());
            REQUEST.registerMessage(RequestMessage.CommunicationMessageHandler.class, RequestMessage.class, 0, Side.SERVER);
            MSG.registerMessage(Message_Message.MSGReceiveHandler.class, Message_Message.class, 1, Side.CLIENT);
            ICO.registerMessage(Message_Icon.ICOReceiveHandler.class, Message_Icon.class, 1, Side.CLIENT);
            if (isEnabled) {
                Discord.initDiscord();
            }
            if (!preventConfigLoad) {
                RPCconfig.loadConfigFromFile();
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                DRPCLog.Info("Shutting down DiscordHook.");
                Discord.shutdown();
            }));
            if (isEnabled) {
                Discord.setPresence(RPCconfig.NAME, "Starting game...", "34565655649643693");
            }
        } else {
            isClient = false;
            DRPCLog.Info("Loading serverside stuff...");
            ServerConfig.preInit();
            REQUEST.registerMessage(RequestMessage.CommunicationMessageHandler.class, RequestMessage.class, 0, Side.SERVER);
            MSG.registerMessage(Message_Message.MSGReceiveHandler.class, Message_Message.class, 1, Side.CLIENT);
            ICO.registerMessage(Message_Icon.ICOReceiveHandler.class, Message_Icon.class, 1, Side.CLIENT);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        ModMetadata meta = evt.getModMetadata();
        meta.autogenerated = false;
        meta.modId = MODID;
        meta.name = NAME;
        meta.authorList.add("ErdbeerbaerLP");
        meta.description = "Gives you an nice discord rich presence";
        meta.version = VERSION;
        meta.url = "https://minecraft.curseforge.com/projects/discordrichpresence";
        meta.updateJSON = "http://erdbeerbaerapi.tk/discordrpc.json";
        if (isClient && isEnabled) {
            MinecraftForge.EVENT_BUS.register(DRPCEventHandler.class);
            ClientCommandHandler.instance.func_71560_a((ICommand)new Command());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (isClient && isEnabled) {
            Discord.setPresence(RPCconfig.NAME, "Starting game...", "3454083453475893469");
        }
    }

    @Mod.EventHandler
    public void starting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new ServerCommand());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
    }
}

