/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.discordrpc;

import de.erdbeerbaerlp.discordrpc.RPCconfig;
import de.erdbeerbaerlp.guilib.components.Button;
import de.erdbeerbaerlp.guilib.components.CheckBox;
import de.erdbeerbaerlp.guilib.components.GuiComponent;
import de.erdbeerbaerlp.guilib.components.Image;
import de.erdbeerbaerlp.guilib.components.Label;
import de.erdbeerbaerlp.guilib.components.TextField;
import de.erdbeerbaerlp.guilib.gui.BetterGuiScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;

public class ConfigGui
extends BetterGuiScreen {
    private final GuiScreen parentScreen;
    private Label title;
    private Button cancel;
    private Button save;
    private Button backToMenu;
    private Image discordLogo;
    private Button general;
    private Button developers;
    private Button serverIntegrations;
    private TextField gameName;
    private TextField singleplayerText;
    private TextField multiplayerText;
    private Label gameNameLabel;
    private Label singleplayerLabel;
    private Label multiplayerLabel;
    private CheckBox devCommands;
    private CheckBox disableConfigMenu;
    private CheckBox hypixel;
    private CheckBox hive;
    private CheckBox customMsg;

    public ConfigGui(GuiScreen parentScreen) {
        this.parentScreen = parentScreen;
        this.setAmountOfPages(5);
    }

    public void buildGui() {
        this.title = new Label("Discord RPC Config", 0, 5);
        this.discordLogo = new Image(0, 0, 200, 68, "https://discordapp.com/assets/fc0b01fe10a0b8c602fb0106d8189d9b.png");
        this.cancel = new Button(0, 0, 65, "Cancel", Button.DefaultButtonIcons.DELETE);
        this.save = new Button(0, 0, 65, "Save", Button.DefaultButtonIcons.SAVE);
        this.backToMenu = new Button(0, 0, 134, "Back", Button.DefaultButtonIcons.ARROW_LEFT);
        this.general = new Button(0, 0, 120, "General Settings", new ResourceLocation("discordrpc", "textures/gui/buttonicons/discord.png"));
        this.developers = new Button(0, 0, 146, "Developer Settings", Button.DefaultButtonIcons.FILE);
        this.serverIntegrations = new Button(0, 0, 270, "Server Integration Settings", new ResourceLocation("discordrpc", "textures/gui/buttonicons/server.png"));
        this.gameNameLabel = new Label("Game Name", 0, 0);
        this.singleplayerLabel = new Label("Singleplayer Message", 0, 0);
        this.multiplayerLabel = new Label("Multiplayer Message", 0, 0);
        this.gameName = new TextField(0, 0, 200);
        this.singleplayerText = new TextField(0, 0, 200);
        this.multiplayerText = new TextField(0, 0, 200);
        this.devCommands = new CheckBox(0, 0, "Enable Developer Subcommand", RPCconfig.DEV_COMMANDS);
        this.disableConfigMenu = new CheckBox(0, 0, "Disable Config Menu", !RPCconfig.CONFIG_GUI_ENABLED);
        this.hypixel = new CheckBox(0, 0, "Enable Hypixel Integration", RPCconfig.ENABLE_HYPIXEL_INTEGRATION);
        this.hive = new CheckBox(0, 0, "Enable HiveMC Integration", RPCconfig.ENABLE_HIVEMC_INTEGRATION);
        this.customMsg = new CheckBox(0, 0, "Enable Custom Server Integration", RPCconfig.ENABLE_CUSTOM_INTEGRATION);
        this.backToMenu.setTooltips(new String[]{"Back to main config menu"});
        this.general.setTooltips(new String[]{"Some basic settings"});
        this.gameName.setTooltips(new String[]{"The first line of your Rich Presence", "Default: Minecraft 1.12"});
        this.singleplayerText.setTooltips(new String[]{"The second line of the Rich Presence when in singleplayer", "", "PLACEHOLDERS: ", "%coords% - Coordinates (X:??? Y:??? Z:???)", "%world% World name", "%dimensionName% - The name of the dimension", "%dimensionID% - The ID of the current dimension", "%biome% - The current Biome"});
        this.multiplayerText.setTooltips(new String[]{"The default second line of the Rich Presence when in multiplayer", "", "PLACEHOLDERS: ", "%ip%  Server IP", "%online% - Online players", "%coords% - Coordinates (X:??? Y:??? Z:???)", "%max% - Server\u00c2\u00b4s maximum amount of players (unless bungeecord!)", "%otherpl% - Amount of players -1 (except you)", "%dimensionName% - The name of the dimension", "%dimensionID% - The ID of the current dimension", "%biome% - The current Biome"});
        this.developers.setTooltips(new String[]{"Some config entries for developers / modpack creators"});
        this.disableConfigMenu.setTooltips(new String[]{"\u00c2\u00a7cWARNING:", "\u00c2\u00a7cThis disables the config menu!", "\u00c2\u00a7cOnly use when you really want to disable it!"});
        this.serverIntegrations.setTooltips(new String[]{"Configurate how some servers will show up"});
        this.hypixel.setTooltips(new String[]{"When enabled, this mod will show details about your current game if available"});
        this.hive.setTooltips(new String[]{"When enabled, the discord rich presence will show your current game using HiveMCs API"});
        this.customMsg.setTooltips(new String[]{"When enabled, every server can define custom messages using this mod or an spigot plugin", "Also disables hardcoded custom icons and text of not fully integrated servers like mineplex"});
        this.general.assignToPage(0);
        this.developers.assignToPage(0);
        this.serverIntegrations.assignToPage(0);
        this.discordLogo.assignToPage(0);
        this.save.assignToPage(0);
        this.cancel.assignToPage(0);
        this.gameName.assignToPage(1);
        this.gameNameLabel.assignToPage(1);
        this.singleplayerText.assignToPage(1);
        this.singleplayerLabel.assignToPage(1);
        this.multiplayerText.assignToPage(1);
        this.multiplayerLabel.assignToPage(1);
        this.devCommands.assignToPage(2);
        this.disableConfigMenu.assignToPage(2);
        this.hypixel.assignToPage(3);
        this.hive.assignToPage(3);
        this.customMsg.assignToPage(3);
        this.save.setClickListener(() -> {
            RPCconfig.DEV_COMMANDS = this.devCommands.isChecked();
            RPCconfig.NAME = this.gameName.getText();
            RPCconfig.ENABLE_HIVEMC_INTEGRATION = this.hive.isChecked();
            RPCconfig.ENABLE_HYPIXEL_INTEGRATION = this.hypixel.isChecked();
            RPCconfig.ENABLE_CUSTOM_INTEGRATION = this.customMsg.isChecked();
            RPCconfig.WORLD_MESSAGE = this.singleplayerText.getText();
            RPCconfig.SERVER_MESSAGE = this.multiplayerText.getText();
            RPCconfig.CONFIG_GUI_ENABLED = !this.disableConfigMenu.isChecked();
            RPCconfig.saveChanges();
            this.openGui(this.parentScreen);
        });
        this.cancel.setClickListener(() -> this.openGui(this.parentScreen));
        this.general.setClickListener(() -> this.setPage(1));
        this.developers.setClickListener(() -> this.setPage(2));
        this.serverIntegrations.setClickListener(() -> this.setPage(3));
        this.backToMenu.setClickListener(() -> this.setPage(0));
        this.title.setCentered();
        this.backToMenu.setVisible(false);
        this.gameName.setText(RPCconfig.NAME);
        this.singleplayerText.setText(RPCconfig.WORLD_MESSAGE);
        this.multiplayerText.setText(RPCconfig.SERVER_MESSAGE);
        this.addAllComponents(new GuiComponent[]{this.title, this.discordLogo, this.cancel, this.save, this.general, this.developers, this.serverIntegrations, this.backToMenu, this.gameName, this.gameNameLabel, this.singleplayerLabel, this.singleplayerText, this.multiplayerLabel, this.multiplayerText, this.devCommands, this.disableConfigMenu, this.hypixel, this.hive, this.customMsg});
    }

    public void updateGui() {
        this.singleplayerText.setEnabled(Minecraft.func_71410_x().field_71441_e == null);
        this.multiplayerText.setEnabled(Minecraft.func_71410_x().field_71441_e == null);
        this.title.setX(this.field_146294_l / 2);
        this.title.setY(10);
        this.discordLogo.setPosition(this.field_146294_l / 2 - this.discordLogo.getWidth() / 2, 20);
        this.save.setX(this.field_146294_l / 2 - 65);
        this.save.setY(this.field_146295_m - 40);
        this.cancel.setY(this.save.getY());
        this.cancel.setX(this.save.getX() + 69);
        this.backToMenu.setY(this.save.getY());
        this.backToMenu.setX(this.save.getX());
        this.backToMenu.setVisible(this.getCurrentPage() > 0);
        this.general.setX(this.field_146294_l / 2 - this.general.getWidth());
        this.general.setY(this.discordLogo.getY() + this.discordLogo.getHeight() + 30);
        this.developers.setX(this.general.getX() + this.general.getWidth() + 4);
        this.developers.setY(this.general.getY());
        this.serverIntegrations.setX(this.general.getX());
        this.serverIntegrations.setY(this.general.getY() + this.general.getHeight() + 5);
        this.gameName.setX(this.field_146294_l / 8);
        this.gameName.setY(this.field_146295_m / 5);
        this.gameNameLabel.setX(this.gameName.getX());
        this.gameNameLabel.setY(this.gameName.getY() - 12);
        this.singleplayerText.setPosition(this.gameName.getX(), this.gameName.getY() + 55);
        this.singleplayerLabel.setX(this.singleplayerText.getX());
        this.singleplayerLabel.setY(this.singleplayerText.getY() - 12);
        this.multiplayerText.setPosition(this.singleplayerText.getX(), this.singleplayerText.getY() + 55);
        this.multiplayerLabel.setX(this.multiplayerText.getX());
        this.multiplayerLabel.setY(this.multiplayerText.getY() - 12);
        this.devCommands.setX(this.field_146294_l / 8);
        this.devCommands.setY(this.field_146295_m / 3);
        this.disableConfigMenu.setPosition(this.devCommands.getX(), this.devCommands.getY() + 15);
        this.hypixel.setPosition(this.field_146294_l / 8, this.field_146295_m / 4);
        this.hive.setPosition(this.hypixel.getX(), this.hypixel.getY() + 15);
        this.customMsg.setPosition(this.hypixel.getX(), this.hive.getY() + 15);
    }

    public boolean doesEscCloseGui() {
        return false;
    }

    public boolean func_73868_f() {
        return false;
    }
}

