/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.common.storage;

import com.daposeidonguy.teamsmod.common.storage.StorageHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class TeamDataManager
extends WorldSavedData {
    private static final String NAME = "teamsmod";

    public TeamDataManager() {
        super(NAME);
    }

    public TeamDataManager(String name) {
        super(name);
        this.func_76185_a();
    }

    public static TeamDataManager get(World world) {
        MapStorage storage = world.func_175693_T();
        TeamDataManager data = (TeamDataManager)storage.func_75742_a(TeamDataManager.class, NAME);
        if (data == null) {
            data = new TeamDataManager();
            world.func_72823_a(NAME, (WorldSavedData)data);
        }
        return data;
    }

    public void func_76184_a(@Nonnull NBTTagCompound nbt) {
        StorageHandler.readFromNBT(nbt);
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound compound) {
        return StorageHandler.writeToNBT(compound);
    }

    public void addTeam(String name, EntityPlayer player) {
        ArrayList<UUID> tempList = new ArrayList<UUID>();
        tempList.add(player.func_110124_au());
        StorageHandler.teamToUuidsMap.put(name, tempList);
        StorageHandler.uuidToTeamMap.put(player.func_110124_au(), name);
        HashMap<String, Boolean> newSettingsMap = new HashMap<String, Boolean>();
        newSettingsMap.put("disableAdvancementSync", false);
        newSettingsMap.put("enableFriendlyFire", false);
        StorageHandler.teamSettingsMap.put(name, newSettingsMap);
        this.func_76185_a();
    }

    public void addPlayer(String team, UUID uid) {
        StorageHandler.teamToUuidsMap.get(team).add(uid);
        StorageHandler.uuidToTeamMap.put(uid, team);
        this.func_76185_a();
    }

    public void removePlayer(String team, UUID uid) {
        StorageHandler.teamToUuidsMap.get(team).remove(uid);
        StorageHandler.uuidToTeamMap.remove(uid);
        this.func_76185_a();
    }

    public void removeTeam(String name) {
        for (UUID id : StorageHandler.teamToUuidsMap.get(name)) {
            StorageHandler.uuidToTeamMap.remove(id);
        }
        StorageHandler.teamToUuidsMap.remove(name);
        StorageHandler.teamSettingsMap.remove(name);
        this.func_76185_a();
    }
}

