/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.common.storage;

import com.daposeidonguy.teamsmod.client.ClientHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class StorageHandler {
    static final Map<UUID, String> uuidToTeamMap = new HashMap<UUID, String>();
    static final Map<String, List<UUID>> teamToUuidsMap = new HashMap<String, List<UUID>>();
    static final Map<String, Map<String, Boolean>> teamSettingsMap = new HashMap<String, Map<String, Boolean>>();

    public static void syncPlayers(String team, EntityPlayerMP player) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && player != null) {
            Iterable advancements = FMLCommonHandler.instance().getMinecraftServerInstance().func_191949_aK().func_192780_b();
            for (Advancement adv : advancements) {
                for (UUID id : teamToUuidsMap.get(team)) {
                    EntityPlayerMP teammate = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(id);
                    if (teammate == null) continue;
                    if (teammate.func_192039_O().func_192747_a(adv).func_192105_a()) {
                        for (String s : teammate.func_192039_O().func_192747_a(adv).func_192102_e()) {
                            player.func_192039_O().func_192750_a(adv, s);
                        }
                        continue;
                    }
                    if (!player.func_192039_O().func_192747_a(adv).func_192105_a()) continue;
                    for (String s : player.func_192039_O().func_192747_a(adv).func_192102_e()) {
                        teammate.func_192039_O().func_192750_a(adv, s);
                    }
                }
            }
        }
    }

    public static void readFromNBT(NBTTagCompound nbt) {
        StorageHandler.clearData();
        try {
            for (NBTBase nbtBase : nbt.func_150295_c("Teams", 10)) {
                NBTTagCompound teamTag = (NBTTagCompound)nbtBase;
                String teamName = teamTag.func_74779_i("Team Name");
                NBTTagList playersTag = teamTag.func_150295_c("Player List", 10);
                if (playersTag.func_74745_c() == 0) continue;
                StorageHandler.readPlayers(teamTag, teamName);
                StorageHandler.readSettings(teamTag, teamName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void clearData() {
        teamToUuidsMap.clear();
        uuidToTeamMap.clear();
        teamSettingsMap.clear();
    }

    private static void readSettings(NBTTagCompound teamTag, String teamName) {
        NBTTagCompound teamSettings = (NBTTagCompound)teamTag.func_74781_a("Settings");
        HashMap<String, Boolean> settingsMap = new HashMap<String, Boolean>();
        if (teamSettings == null) {
            settingsMap.put("disableAdvancementSync", false);
            settingsMap.put("enableFriendlyFire", false);
        } else {
            settingsMap.put("disableAdvancementSync", teamSettings.func_74767_n("disableAdvancementSync"));
            settingsMap.put("enableFriendlyFire", teamSettings.func_74767_n("enableFriendlyFire"));
        }
        teamSettingsMap.put(teamName, settingsMap);
    }

    private static void readPlayers(NBTTagCompound teamTag, String teamName) {
        Iterator playerTagListIterator = teamTag.func_150295_c("Player List", 10).iterator();
        ArrayList<UUID> uuidList = new ArrayList<UUID>();
        while (playerTagListIterator.hasNext()) {
            NBTTagCompound playerTag = (NBTTagCompound)playerTagListIterator.next();
            UUID playerId = UUID.fromString(playerTag.func_74779_i("uuid"));
            StorageHandler.addPlayerMapping(playerId);
            uuidToTeamMap.put(playerId, teamName);
            uuidList.add(playerId);
        }
        teamToUuidsMap.put(teamName, uuidList);
    }

    private static void addPlayerMapping(UUID playerId) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            try {
                String name = Minecraft.func_71410_x().func_147114_u().func_175102_a(playerId).func_178845_a().getName();
                ClientHelper.addPlayerMapping(name, playerId);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public static NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagList tagList = new NBTTagList();
        for (String teamName : teamToUuidsMap.keySet()) {
            NBTTagCompound teamTag = new NBTTagCompound();
            teamTag.func_74778_a("Team Name", teamName);
            teamTag.func_74782_a("Player List", (NBTBase)StorageHandler.writePlayers(teamName));
            teamTag.func_74782_a("Settings", (NBTBase)StorageHandler.writeSettings(teamName));
            tagList.func_74742_a((NBTBase)teamTag);
        }
        compound.func_74782_a("Teams", (NBTBase)tagList);
        return compound;
    }

    private static NBTTagList writePlayers(String teamName) {
        NBTTagList playerListTag = new NBTTagList();
        for (UUID id : teamToUuidsMap.get(teamName)) {
            NBTTagCompound playerTag = new NBTTagCompound();
            playerTag.func_74778_a("uuid", id.toString());
            playerListTag.func_74742_a((NBTBase)playerTag);
        }
        return playerListTag;
    }

    private static NBTTagCompound writeSettings(String teamName) {
        NBTTagCompound teamSettings = new NBTTagCompound();
        teamSettings.func_74757_a("disableAdvancementSync", teamSettingsMap.get(teamName).get("disableAdvancementSync").booleanValue());
        teamSettings.func_74757_a("enableFriendlyFire", teamSettingsMap.get(teamName).get("enableFriendlyFire").booleanValue());
        return teamSettings;
    }
}

