/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.common.network;

import com.daposeidonguy.teamsmod.common.config.TeamConfig;
import com.daposeidonguy.teamsmod.common.network.NetworkHelper;
import com.daposeidonguy.teamsmod.common.network.messages.MessageConfig;
import com.daposeidonguy.teamsmod.common.network.messages.MessageDeath;
import com.daposeidonguy.teamsmod.common.network.messages.MessageHealth;
import com.daposeidonguy.teamsmod.common.network.messages.MessageHunger;
import com.daposeidonguy.teamsmod.common.network.messages.MessageNewChat;
import com.daposeidonguy.teamsmod.common.network.messages.MessagePos;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="teamsmod")
public class PacketEvents {
    private static int ticks = 0;

    @SubscribeEvent
    public static void tickEvent(TickEvent.ServerTickEvent event) {
        if (++ticks == 150 && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            List playerMPList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
            for (EntityPlayerMP playerMP : playerMPList) {
                NetworkHelper.sendToTeam(playerMP, new MessageHealth(playerMP.func_110124_au(), MathHelper.func_76123_f((float)playerMP.func_110143_aJ())));
                NetworkHelper.sendToTeam(playerMP, new MessageHunger(playerMP.func_110124_au(), MathHelper.func_76123_f((float)playerMP.func_71024_bL().func_75116_a())));
            }
            ticks = 0;
        }
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingHurtEvent event) {
        if (event.getEntity() instanceof EntityPlayer && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            UUID playerID = event.getEntity().func_110124_au();
            EntityPlayerMP playerEntity = (EntityPlayerMP)event.getEntityLiving();
            if (event.getAmount() > event.getEntityLiving().func_110143_aJ()) {
                NetworkHelper.sendToTeam(playerEntity, new MessageHealth(playerID, 0));
            } else {
                NetworkHelper.sendToTeam(playerEntity, new MessageHealth(playerID, MathHelper.func_76123_f((float)(event.getEntityLiving().func_110143_aJ() - event.getAmount()))));
            }
            NetworkHelper.sendToTeam(playerEntity, new MessageHunger(playerID, playerEntity.func_71024_bL().func_75116_a()));
        }
    }

    @SubscribeEvent
    public static void onPlayerHeal(LivingHealEvent event) {
        if (event.getEntity() instanceof EntityPlayer && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            UUID playerID = event.getEntity().func_110124_au();
            EntityPlayerMP playerEntity = (EntityPlayerMP)event.getEntityLiving();
            NetworkHelper.sendToTeam(playerEntity, new MessageHealth(playerID, MathHelper.func_76123_f((float)(event.getEntityLiving().func_110143_aJ() + event.getAmount()))));
            NetworkHelper.sendToTeam(playerEntity, new MessageHunger(playerID, playerEntity.func_71024_bL().func_75116_a()));
        }
    }

    @SubscribeEvent
    public static void onPlayerChat(ServerChatEvent event) {
        boolean teamChat = event.getPlayer().getEntityData().func_74767_n("teamChat");
        NetworkHelper.sendToAll(new MessageNewChat(event.getPlayer().func_146103_bH().getName(), event.getMessage(), teamChat));
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayer && FMLCommonHandler.instance().getEffectiveSide().isServer() && !TeamConfig.common.disableDeathSound) {
            NetworkHelper.sendToTeam((EntityPlayerMP)event.getEntityLiving(), new MessageDeath());
        }
    }

    @SubscribeEvent
    public static void onPlayerMove(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K && event.getEntity() instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)event.getEntityLiving();
            NetworkHelper.sendToTeam(playerMP, new MessagePos(playerMP));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            NetworkHelper.sendToPlayer((EntityPlayerMP)event.player, new MessageConfig());
        }
    }
}

