/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.common.command;

import com.daposeidonguy.teamsmod.common.config.TeamConfig;
import com.daposeidonguy.teamsmod.common.network.NetworkHelper;
import com.daposeidonguy.teamsmod.common.network.messages.MessageInvite;
import com.daposeidonguy.teamsmod.common.network.messages.MessageSaveData;
import com.daposeidonguy.teamsmod.common.storage.StorageEvents;
import com.daposeidonguy.teamsmod.common.storage.StorageHandler;
import com.daposeidonguy.teamsmod.common.storage.StorageHelper;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CommandTeam
extends CommandBase {
    private final List<String> aliases = new ArrayList<String>();
    private final String help = "Teams Commands: \n/teamsmod create <name> : creates team with the name <name>\n/teamsmod list : lists all created teams\n/teamsmod info <name> : lists all players in the team with name <name>\n/teamsmod player <name> : prints the team of the player with name <name>\n/teamsmod invite <name> : invites player with name <name> to your team\n/teamsmod accept : accepts invitation to team\n/teamsmod kick <name> : kicks player with name <name> from your team\n/teamsmod leave : leaves your team\n/teamsmod remove <name> : ADMIN ONLY - deletes the team with name <name>";

    public CommandTeam() {
        this.aliases.add("t");
        this.aliases.add("teams");
        this.aliases.add("teamsmod");
    }

    public String func_71517_b() {
        return "teamsmod";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Teams Commands: \n/teamsmod create <name> : creates team with the name <name>\n/teamsmod list : lists all created teams\n/teamsmod info <name> : lists all players in the team with name <name>\n/teamsmod player <name> : prints the team of the player with name <name>\n/teamsmod invite <name> : invites player with name <name> to your team\n/teamsmod accept : accepts invitation to team\n/teamsmod kick <name> : kicks player with name <name> from your team\n/teamsmod leave : leaves your team\n/teamsmod remove <name> : ADMIN ONLY - deletes the team with name <name>";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && args.length > 0) {
            switch (args[0]) {
                case "create": {
                    this.checkLength(args, 2);
                    this.teamCreate(server, sender, args[1]);
                    break;
                }
                case "list": {
                    this.teamList(sender);
                    break;
                }
                case "info": {
                    this.checkLength(args, 2);
                    this.teamInfo(server, sender, args[1]);
                    break;
                }
                case "player": {
                    this.checkLength(args, 2);
                    this.teamPlayer(server, sender, args[1]);
                    break;
                }
                case "invite": {
                    this.checkLength(args, 2);
                    this.teamInvite(sender, args[1]);
                    break;
                }
                case "accept": {
                    this.teamAccept(server, sender);
                    break;
                }
                case "kick": {
                    this.checkLength(args, 2);
                    this.teamKick(server, sender, args[1]);
                    break;
                }
                case "leave": {
                    this.teamLeave(server, sender);
                    break;
                }
                case "remove": {
                    this.checkLength(args, 2);
                    this.teamRemove(server, sender, args[1]);
                    break;
                }
                case "config": {
                    this.checkLength(args, 3);
                    if (!args[2].equalsIgnoreCase("false") && !args[2].equalsIgnoreCase("true")) {
                        throw new CommandException(new TextComponentTranslation("teamsmod.badarguments", new Object[0]).func_150254_d(), new Object[0]);
                    }
                    this.teamConfig(server, sender, args[1], Boolean.valueOf(args[2]));
                }
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
        }
    }

    private void teamCreate(MinecraftServer server, ICommandSender sender, String teamName) throws CommandException {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            if (StorageHelper.doesTeamExist(teamName)) {
                throw new CommandException(new TextComponentTranslation("teamsmod.create.nametaken", new Object[0]).func_150254_d(), new Object[0]);
            }
            if (StorageHelper.isPlayerInTeam(player.func_110124_au())) {
                throw new CommandException(new TextComponentTranslation("teamsmod.inteam", new Object[0]).func_150254_d(), new Object[0]);
            }
            sender.func_145747_a(new TextComponentTranslation("teamsmod.create.success", new Object[0]).func_150258_a(teamName));
            StorageEvents.data.addTeam(teamName, player);
            NetworkHelper.sendToAll(new MessageSaveData());
        }
    }

    private void teamList(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("teamsmod.list.success", new Object[0]));
        for (String s : StorageHelper.getTeamSet()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(s));
        }
    }

    private void teamInfo(MinecraftServer server, ICommandSender sender, String teamName) throws CommandException {
        if (!StorageHelper.doesTeamExist(teamName)) {
            throw new CommandException(new TextComponentTranslation("teamsmod.info.invalidteam", new Object[0]).func_150254_d(), new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("teamsmod.info.success", new Object[0]));
        for (UUID id : StorageHelper.getTeamPlayers(teamName)) {
            GameProfile profile = server.func_152358_ax().func_152652_a(id);
            if (profile == null) continue;
            sender.func_145747_a((ITextComponent)new TextComponentString(profile.getName()));
        }
    }

    private void teamPlayer(MinecraftServer server, ICommandSender sender, String playerName) throws CommandException {
        GameProfile profile = server.func_152358_ax().func_152655_a(playerName);
        if (profile == null) {
            throw new CommandException(new TextComponentTranslation("teamsmod.nosuchplayer", new Object[]{playerName}).func_150254_d(), new Object[0]);
        }
        if (!StorageHelper.isPlayerInTeam(profile.getId())) {
            throw new CommandException(new TextComponentTranslation("teamsmod.player.teamless", new Object[]{playerName}).func_150254_d(), new Object[0]);
        }
        String playerTeam = StorageHelper.getTeam(profile.getId());
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("teamsmod.player.success", new Object[]{playerName, playerTeam}));
    }

    private void teamInvite(ICommandSender sender, String playerName) throws CommandException {
        if (sender instanceof EntityPlayer) {
            EntityPlayerMP newPlayer = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(playerName);
            EntityPlayer oldPlayer = (EntityPlayer)sender;
            String teamName = StorageHelper.getTeam(oldPlayer.func_110124_au());
            if (teamName != null) {
                if (newPlayer == null) {
                    throw new CommandException(new TextComponentTranslation("teamsmod.invite.nosuchplayer", new Object[0]).func_150254_d(), new Object[0]);
                }
                if (StorageHelper.getTeamPlayers(teamName).contains(newPlayer.func_110124_au())) {
                    throw new CommandException(new TextComponentTranslation("teamsmod.invite.alreadyinteam", new Object[0]).func_150254_d(), new Object[0]);
                }
                newPlayer.getEntityData().func_74778_a("invitedto", teamName);
                newPlayer.getEntityData().func_186854_a("invitedby", oldPlayer.func_110124_au());
                oldPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("teamsmod.invite.success", new Object[]{newPlayer.func_146103_bH().getName()}));
                NetworkHelper.sendToPlayer(newPlayer, new MessageInvite(teamName));
                newPlayer.func_145747_a(new TextComponentTranslation("teamsmod.invitedtoteam", new Object[0]).func_150258_a(teamName));
            } else {
                throw new CommandException(new TextComponentTranslation("teamsmod.notinteam", new Object[0]).func_150254_d(), new Object[0]);
            }
        }
    }

    private void teamAccept(MinecraftServer server, ICommandSender sender) throws CommandException {
        if (sender instanceof EntityPlayer) {
            EntityPlayerMP invitee = (EntityPlayerMP)sender;
            String teamName = invitee.getEntityData().func_74779_i("invitedto");
            UUID uid = invitee.func_110124_au();
            if (teamName.equals("")) {
                throw new CommandException(new TextComponentTranslation("teamsmod.accept.notinvited", new Object[0]).func_150254_d(), new Object[0]);
            }
            if (StorageHelper.isPlayerInTeam(uid)) {
                throw new CommandException(new TextComponentTranslation("teamsmod.inteam", new Object[0]).func_150254_d(), new Object[0]);
            }
            StorageEvents.data.addPlayer(teamName, uid);
            if (!TeamConfig.server.disableAdvancementSync) {
                StorageHandler.syncPlayers(teamName, invitee);
            }
            NetworkHelper.sendToAll(new MessageSaveData());
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("teamsmod.accept.success", new Object[]{teamName}));
            EntityPlayerMP inviter = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(invitee.getEntityData().func_186857_a("invitedby"));
            if (inviter != null) {
                inviter.func_145747_a((ITextComponent)new TextComponentTranslation("teamsmod.accept.joined", new Object[]{invitee.func_146103_bH().getName()}));
            }
        }
    }

    private void teamKick(MinecraftServer server, ICommandSender sender, String playerName) throws CommandException {
        if (sender instanceof EntityPlayer) {
            GameProfile profile = server.func_152358_ax().func_152655_a(playerName);
            if (profile == null) {
                throw new CommandException(new TextComponentTranslation("teamsmod.nosuchplayer", new Object[0]).func_150254_d(), new Object[0]);
            }
            UUID kickID = profile.getId();
            UUID senderID = ((EntityPlayer)sender).func_110124_au();
            if (!StorageHelper.isPlayerInTeam(senderID)) {
                throw new CommandException(new TextComponentTranslation("teamsmod.notinteam", new Object[0]).func_150254_d(), new Object[0]);
            }
            if (!StorageHelper.isPlayerInTeam(kickID) || !StorageHelper.getTeam(senderID).equals(StorageHelper.getTeam(kickID))) {
                throw new CommandException(new TextComponentTranslation("teamsmod.playernotinteam", new Object[]{profile.getName()}).func_150254_d(), new Object[0]);
            }
            String myTeam = StorageHelper.getTeam(senderID);
            if (!StorageHelper.getTeamOwner(myTeam).equals(senderID)) {
                throw new CommandException(new TextComponentTranslation("teamsmod.notowner", new Object[]{profile.getName()}).func_150254_d(), new Object[0]);
            }
            StorageEvents.data.removePlayer(myTeam, kickID);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("teamsmod.kick.success", new Object[]{profile.getName()}));
            if (server.func_184103_al().func_177451_a(kickID) != null) {
                server.func_184103_al().func_177451_a(kickID).func_145747_a((ITextComponent)new TextComponentTranslation("teamsmod.kicked", new Object[0]));
            }
            NetworkHelper.sendToAll(new MessageSaveData());
        }
    }

    private void teamLeave(MinecraftServer server, ICommandSender sender) throws CommandException {
        if (sender instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)sender;
            String toLeave = StorageHelper.getTeam(p.func_110124_au());
            if (toLeave == null) {
                throw new CommandException(new TextComponentTranslation("teamsmod.notinteam", new Object[0]).func_150254_d(), new Object[0]);
            }
            if (StorageHelper.getTeamOwner(toLeave).equals(p.func_146103_bH().getId()) && StorageHelper.getTeamPlayers(toLeave).size() > 1) {
                throw new CommandException(new TextComponentTranslation("teamsmod.leave.owner", new Object[0]).func_150254_d(), new Object[0]);
            }
            StorageEvents.data.removePlayer(toLeave, p.func_110124_au());
            p.func_145747_a((ITextComponent)new TextComponentTranslation("teamsmod.leave.success", new Object[0]));
            if (StorageHelper.getTeamPlayers(toLeave).isEmpty()) {
                StorageEvents.data.removeTeam(toLeave);
            }
            NetworkHelper.sendToAll(new MessageSaveData());
        }
    }

    private void teamRemove(MinecraftServer server, ICommandSender sender, String teamName) throws CommandException {
        if (sender.func_70003_b(2, this.func_71517_b()) || FMLCommonHandler.instance().getMinecraftServerInstance().func_71264_H() || TeamConfig.server.noOpRemoveTeam) {
            if (!StorageHelper.doesTeamExist(teamName)) {
                throw new CommandException(new TextComponentTranslation("teamsmod.remove.nosuchteam", new Object[]{teamName}).func_150254_d(), new Object[0]);
            }
        } else {
            throw new CommandException("Missing permissions", new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("teamsmod.remove.success", new Object[]{teamName}));
        StorageEvents.data.removeTeam(teamName);
        NetworkHelper.sendToAll(new MessageSaveData());
    }

    private void teamConfig(MinecraftServer server, ICommandSender sender, String configOption, boolean configValue) throws CommandException {
        if (sender instanceof EntityPlayer) {
            String teamName = StorageHelper.getTeam(((EntityPlayer)sender).func_110124_au());
            if (teamName == null) {
                throw new CommandException(new TextComponentTranslation("teamsmod.notinteam", new Object[0]).func_150254_d(), new Object[0]);
            }
            if (!configOption.equals("disableAdvancementSync") && !configOption.equals("enableFriendlyFire")) {
                throw new CommandException(new TextComponentTranslation("teamsmod.config.invalid", new Object[0]).func_150254_d(), new Object[0]);
            }
            if (!((EntityPlayer)sender).func_110124_au().equals(StorageHelper.getTeamOwner(teamName))) {
                throw new CommandException(new TextComponentTranslation("teamsmod.notowner", new Object[0]).func_150254_d(), new Object[0]);
            }
            StorageHelper.setTeamSetting(teamName, configOption, configValue);
            NetworkHelper.sendToAll(new MessageSaveData());
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("teamsmod.config.success", new Object[0]));
        }
    }

    private void checkLength(String[] args, int length) throws CommandException {
        if (args.length != length) {
            throw new CommandException(new TextComponentTranslation("teamsmod.badarguments", new Object[0]).func_150254_d(), new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> tabCompletions;
        block40: {
            block39: {
                tabCompletions = new ArrayList<String>();
                if (args.length == 1) {
                    char[] charArray = args[0].toCharArray();
                    if (charArray.length < 1) {
                        tabCompletions.add("config");
                        tabCompletions.add("remove");
                        tabCompletions.add("leave");
                        tabCompletions.add("kick");
                        tabCompletions.add("accept");
                        tabCompletions.add("invite");
                        tabCompletions.add("player");
                        tabCompletions.add("info");
                        tabCompletions.add("list");
                        tabCompletions.add("create");
                    } else if (charArray[0] == 'c') {
                        tabCompletions.add("config");
                        tabCompletions.add("create");
                    } else if (charArray[0] == 'r') {
                        tabCompletions.add("remove");
                    } else if (charArray[0] == 'l') {
                        tabCompletions.add("leave");
                        tabCompletions.add("list");
                    } else if (charArray[0] == 'k') {
                        tabCompletions.add("kick");
                    } else if (charArray[0] == 'a') {
                        tabCompletions.add("accept");
                    } else if (charArray[0] == 'i') {
                        tabCompletions.add("info");
                        tabCompletions.add("invite");
                    } else if (charArray[0] == 'p') {
                        tabCompletions.add("player");
                    } else {
                        tabCompletions.add("config");
                        tabCompletions.add("remove");
                        tabCompletions.add("leave");
                        tabCompletions.add("kick");
                        tabCompletions.add("accept");
                        tabCompletions.add("invite");
                        tabCompletions.add("player");
                        tabCompletions.add("info");
                        tabCompletions.add("list");
                        tabCompletions.add("create");
                    }
                }
                if (args.length != 2) break block39;
                switch (args[0]) {
                    case "config": {
                        tabCompletions.add("disableAdvancementSync");
                        tabCompletions.add("enableFriendlyFire");
                        break;
                    }
                    case "remove": {
                        for (String team : StorageHelper.getTeamSet()) {
                            tabCompletions.add(team);
                        }
                        break block40;
                    }
                    case "kick": {
                        String teamName = StorageHelper.getTeam(sender.func_174793_f().func_110124_au());
                        for (UUID playerId : StorageHelper.getTeamPlayers(teamName)) {
                            tabCompletions.add(FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(playerId).getName());
                        }
                        break block40;
                    }
                    case "invite": {
                        for (String playerName : FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z()) {
                            tabCompletions.add(playerName);
                        }
                        break block40;
                    }
                    case "player": {
                        for (String playerName : FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z()) {
                            tabCompletions.add(playerName);
                        }
                        break block40;
                    }
                    case "info": {
                        for (String team : StorageHelper.getTeamSet()) {
                            tabCompletions.add(team);
                        }
                        break;
                    }
                }
                break block40;
            }
            if (args.length == 3) {
                tabCompletions.add("true");
                tabCompletions.add("false");
            }
        }
        return tabCompletions;
    }
}

