/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.common;

import com.daposeidonguy.teamsmod.common.config.TeamConfig;
import com.daposeidonguy.teamsmod.common.storage.StorageHandler;
import com.daposeidonguy.teamsmod.common.storage.StorageHelper;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="teamsmod")
class TeamEvents {
    TeamEvents() {
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        String team;
        if (!event.player.func_130014_f_().field_72995_K && !TeamConfig.server.disableAdvancementSync && StorageHelper.isPlayerInTeam(event.player.func_110124_au()) && !StorageHelper.getTeamSetting(team = StorageHelper.getTeam(event.player.func_110124_au()), "disableAdvancementSync")) {
            StorageHandler.syncPlayers(team, (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void playerHitPlayer(LivingAttackEvent event) {
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && !TeamConfig.server.enableFriendlyFire && event.getSource().func_76346_g() instanceof EntityPlayer && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer attacker = (EntityPlayer)event.getSource().func_76346_g();
            EntityPlayer target = (EntityPlayer)event.getEntityLiving();
            String targetTeam = StorageHelper.getTeam(target.func_110124_au());
            String attackerTeam = StorageHelper.getTeam(attacker.func_110124_au());
            if (targetTeam != null && targetTeam.equals(attackerTeam) && !StorageHelper.getTeamSetting(targetTeam, "enableFriendlyFire")) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void achievementGet(AdvancementEvent event) {
        String team;
        if (!TeamConfig.server.disableAdvancementSync && !event.getEntity().func_130014_f_().field_72995_K && StorageHelper.doesTeamExist(team = StorageHelper.getTeam(event.getEntityPlayer().func_110124_au())) && !StorageHelper.getTeamSetting(team, "disableAdvancementSync")) {
            Advancement adv = event.getAdvancement();
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
            for (UUID playerID : StorageHelper.getTeamPlayers(team)) {
                EntityPlayerMP teammate = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(playerID);
                if (teammate == null) continue;
                for (String s : player.func_192039_O().func_192747_a(adv).func_192102_e()) {
                    if (teammate.func_192039_O().func_192747_a(adv).func_192106_c(s).func_192151_a()) continue;
                    teammate.func_192039_O().func_192750_a(adv, s);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerChat(ServerChatEvent event) {
        String teamName;
        if (!TeamConfig.common.disablePrefix && (teamName = StorageHelper.getTeam(event.getPlayer().func_110124_au())) != null) {
            TextComponentString prefix = new TextComponentString("[" + teamName + "] ");
            event.setComponent(prefix.func_150257_a(event.getComponent()));
        }
    }
}

