/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.client.gui.overlay;

import com.daposeidonguy.teamsmod.client.gui.GuiHandler;
import com.daposeidonguy.teamsmod.common.storage.StorageHelper;
import java.awt.Color;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameType;

public class StatusOverlay
extends Gui {
    private final Minecraft mc;
    private final int scaledWidth;
    private final int scaledHeight;
    private int offsetY;
    private int count;

    public StatusOverlay(Minecraft mc, String teamName) {
        this.mc = mc;
        ScaledResolution res = new ScaledResolution(mc);
        this.scaledWidth = res.func_78326_a();
        this.scaledHeight = res.func_78328_b();
        this.offsetY = 0;
        this.count = 0;
        Iterator<UUID> priorityIterator = GuiHandler.priorityPlayers.iterator();
        Iterator<UUID> teamIterator = StorageHelper.getTeamPlayers(teamName).iterator();
        this.renderStatuses(priorityIterator, true);
        this.renderStatuses(teamIterator, false);
    }

    private void renderStatuses(Iterator<UUID> uuidIterator, boolean isPriority) {
        while (uuidIterator.hasNext() && this.count < 4) {
            UUID playerId = uuidIterator.next();
            if (!this.shouldRenderStatus(playerId, isPriority)) continue;
            this.renderStatus(playerId);
            this.offsetY += 46;
            ++this.count;
        }
    }

    private boolean shouldRenderStatus(UUID playerId, boolean isPriority) {
        boolean isDifferentOnlinePlayer;
        boolean bl = isDifferentOnlinePlayer = !playerId.equals(this.mc.field_71439_g.func_110124_au()) && this.mc.func_147114_u().func_175102_a(playerId) != null;
        if (isPriority) {
            return isDifferentOnlinePlayer;
        }
        return isDifferentOnlinePlayer && !GuiHandler.priorityPlayers.contains(playerId);
    }

    private void renderStatus(UUID playerUUID) {
        NetworkPlayerInfo info = this.mc.func_147114_u().func_175102_a(playerUUID);
        if (info.func_178848_b() == GameType.SPECTATOR) {
            return;
        }
        String playerName = info.func_178845_a().getName();
        ResourceLocation skinLoc = info.func_178837_g();
        int health = GuiHandler.healthMap.getOrDefault(playerUUID, 20);
        int hunger = GuiHandler.hungerMap.getOrDefault(playerUUID, 20);
        if (health < 0) {
            return;
        }
        this.mc.func_110434_K().func_110577_a(new ResourceLocation("teamsmod", "textures/gui/icon.png"));
        this.func_73729_b((int)Math.round((double)this.scaledWidth * 0.002) + 20, this.scaledHeight / 4 - 5 + this.offsetY, 0, 0, 9, 9);
        this.func_73731_b(this.mc.field_71466_p, String.valueOf(health), (int)Math.round((double)this.scaledWidth * 0.002) + 32, this.scaledHeight / 4 - 5 + this.offsetY, Color.WHITE.getRGB());
        this.mc.func_110434_K().func_110577_a(new ResourceLocation("teamsmod", "textures/gui/icon.png"));
        this.func_73729_b((int)Math.round((double)this.scaledWidth * 0.002) + 46, this.scaledHeight / 4 - 5 + this.offsetY, 9, 0, 9, 9);
        this.func_73731_b(this.mc.field_71466_p, String.valueOf(hunger), (int)Math.round((double)this.scaledWidth * 0.002) + 58, this.scaledHeight / 4 - 5 + this.offsetY, Color.WHITE.getRGB());
        this.mc.func_110434_K().func_110577_a(skinLoc);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        this.func_73729_b((int)Math.round((double)this.scaledWidth * 0.002) + 4, this.scaledHeight / 2 - 34 + 2 * this.offsetY, 32, 32, 32, 32);
        GlStateManager.func_179121_F();
        this.func_73731_b(this.mc.field_71466_p, playerName, (int)Math.round((double)this.scaledWidth * 0.001) + 20, this.scaledHeight / 4 - 20 + this.offsetY, Color.WHITE.getRGB());
    }
}

