/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.client.gui.overlay;

import com.daposeidonguy.teamsmod.client.ClientHelper;
import com.daposeidonguy.teamsmod.common.storage.StorageHelper;
import com.mojang.realmsclient.util.Pair;
import java.awt.Color;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.world.GameType;

public class CompassOverlay
extends Gui {
    private static final int HUD_WIDTH = 182;
    private static final int HUD_HEIGHT = 5;
    private final Minecraft mc;
    private final int scaledWidth;
    private final int scaledHeight;

    public CompassOverlay(Minecraft mc, String teamName) {
        this.mc = mc;
        ScaledResolution res = new ScaledResolution(mc);
        this.scaledWidth = res.func_78326_a();
        this.scaledHeight = res.func_78328_b();
        double rotationHead = this.caculateRotationHead();
        Iterator<UUID> uuidIterator = StorageHelper.getTeamPlayers(teamName).iterator();
        int onlineCount = 0;
        while (uuidIterator.hasNext()) {
            Pair<Integer, Vec2f> posPair;
            NetworkPlayerInfo player;
            UUID playerId = uuidIterator.next();
            if (playerId.equals(mc.field_71439_g.func_110124_au()) || (player = mc.func_147114_u().func_175102_a(playerId)) == null || (posPair = ClientHelper.idtoPosMap.get(playerId)) == null || ((Integer)posPair.first()).intValue() != mc.field_71439_g.func_130014_f_().field_73011_w.getDimension() || player.func_178848_b() == GameType.SPECTATOR) continue;
            ++onlineCount;
            double magnitude = this.calculateMagnitude((Vec2f)posPair.second());
            double renderFactor = this.calculateRenderFactor((Vec2f)posPair.second(), rotationHead, magnitude);
            ResourceLocation skin = player.func_178837_g();
            this.renderHUDHead(skin, renderFactor, magnitude);
        }
        if (onlineCount != 0) {
            mc.func_110434_K().func_110577_a(field_110324_m);
            this.func_73729_b(this.scaledWidth / 2 - 91, (int)((double)this.scaledHeight * 0.01) + 10, 0, 74, 182, 5);
        }
    }

    private double caculateRotationHead() {
        double rotationHead = this.mc.field_71439_g.func_70079_am() % 360.0f;
        if (rotationHead > 180.0) {
            rotationHead -= 360.0;
        } else if (rotationHead < -180.0) {
            rotationHead = 360.0 + rotationHead;
        }
        return rotationHead;
    }

    private double calculateMagnitude(Vec2f pos) {
        double diffPosX = (double)pos.field_189982_i - this.mc.field_71439_g.field_70165_t;
        double diffPosZ = (double)pos.field_189983_j - this.mc.field_71439_g.field_70161_v;
        return Math.sqrt(diffPosX * diffPosX + diffPosZ * diffPosZ);
    }

    private double calculateRenderFactor(Vec2f pos, double rotationHead, double magnitude) {
        double renderFactor;
        double diffPosX = (double)pos.field_189982_i - this.mc.field_71439_g.field_70165_t;
        double diffPosZ = (double)pos.field_189983_j - this.mc.field_71439_g.field_70161_v;
        double angle = Math.atan((diffPosZ /= magnitude) / (diffPosX /= magnitude)) * 180.0 / Math.PI + 90.0;
        if (diffPosX >= 0.0) {
            angle -= 180.0;
        }
        if ((renderFactor = (angle - rotationHead) / 180.0) > 1.0) {
            renderFactor -= 2.0;
        }
        if (renderFactor < -1.0) {
            renderFactor = 2.0 + renderFactor;
        }
        return renderFactor;
    }

    private void renderHUDHead(ResourceLocation skin, double renderFactor, double magnitude) {
        this.mc.func_110434_K().func_110577_a(skin);
        int x = (int)((double)(this.scaledWidth / 2 - 45) + renderFactor * 182.0 / 2.0 + 41.0);
        int y = (int)((double)this.scaledHeight * 0.01 + 16.0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
        String strMagnitude = String.valueOf(Math.round(magnitude * 1000.0) / 1000L) + "m";
        if (1.0 - Math.abs(renderFactor) < 0.6) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(1.2 - Math.abs(renderFactor))));
            this.func_73729_b(4 * x, 4 * y, 32, 32, 32, 32);
            Color colorText = new Color(1.0f, 1.0f, 1.0f, (float)(1.2 - Math.abs(renderFactor)));
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            this.func_73731_b(this.mc.field_71466_p, strMagnitude, 2 * x - this.mc.field_71466_p.func_78256_a(strMagnitude) / 2 + 8, 2 * y + 17, colorText.getRGB());
            GlStateManager.func_179084_k();
        } else {
            this.func_73729_b(4 * x, 4 * y, 32, 32, 32, 32);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            this.func_73731_b(this.mc.field_71466_p, strMagnitude, 2 * x - this.mc.field_71466_p.func_78256_a(strMagnitude) / 2 + 8, 2 * y + 17, Color.WHITE.getRGB());
        }
        GlStateManager.func_179121_F();
    }
}

