/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.client.chat;

import com.daposeidonguy.teamsmod.client.chat.ChatHelper;
import com.daposeidonguy.teamsmod.client.gui.GuiHandler;
import com.daposeidonguy.teamsmod.common.config.ConfigHelper;
import com.daposeidonguy.teamsmod.common.config.TeamConfig;
import com.daposeidonguy.teamsmod.common.storage.StorageHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="teamsmod", value={Side.CLIENT})
class ChatEvents {
    ChatEvents() {
    }

    @SubscribeEvent
    public static void onChatReceived(ClientChatReceivedEvent event) {
        if (event.getType() == ChatType.CHAT) {
            if (ChatHelper.getLastMessageSender() == null) {
                return;
            }
            if (TeamConfig.common.disablePrefix && !event.getMessage().func_150253_a().isEmpty()) {
                event.setMessage((ITextComponent)event.getMessage().func_150253_a().get(0));
            }
            String senderTeam = StorageHelper.getTeam(ChatHelper.getLastMessageSender());
            String myTeam = StorageHelper.getTeam(Minecraft.func_71410_x().field_71439_g.func_110124_au());
            boolean doPing = ChatEvents.doPing(ChatHelper.getLastMessage(), Minecraft.func_71410_x().field_71439_g.func_146103_bH().getName(), myTeam);
            if (doPing) {
                event.getMessage().func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)));
            }
            ChatEvents.handleTeamChat(event, senderTeam, myTeam);
            if (doPing && (!ChatHelper.wasLastMessageTeam() || senderTeam.equals(myTeam))) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 3.0f);
            }
            ChatHelper.clear();
        } else if (GuiHandler.displayTeamChat) {
            GuiHandler.backupChatGUI.func_146227_a(event.getMessage());
        }
    }

    private static void handleTeamChat(ClientChatReceivedEvent event, String senderTeam, String myTeam) {
        if (GuiHandler.displayTeamChat) {
            if (ChatHelper.wasLastMessageTeam()) {
                if (senderTeam == null || !senderTeam.equals(myTeam)) {
                    event.setCanceled(true);
                }
            } else {
                GuiHandler.backupChatGUI.func_146227_a(event.getMessage());
                if (senderTeam == null || !senderTeam.equals(myTeam)) {
                    event.setCanceled(true);
                }
            }
        } else if (ChatHelper.wasLastMessageTeam()) {
            event.setCanceled(true);
            if (senderTeam != null && senderTeam.equals(myTeam)) {
                GuiHandler.backupChatGUI.func_146227_a(event.getMessage());
            }
        } else if (senderTeam != null && senderTeam.equals(myTeam)) {
            GuiHandler.backupChatGUI.func_146227_a(event.getMessage());
        }
    }

    private static boolean doPing(String msg, String player, String team) {
        boolean mentionsPlayer;
        if (TeamConfig.common.disablePing || ConfigHelper.serverDisablePing) {
            return false;
        }
        boolean bl = mentionsPlayer = msg.contains(" " + player) || msg.contains(player + " ") || msg.equals(player);
        if (team == null) {
            return mentionsPlayer;
        }
        boolean mentionsTeam = msg.contains(" " + team) || msg.contains(team + " ") || msg.equals(team);
        return mentionsPlayer || mentionsTeam;
    }
}

