/*
 * Decompiled with CFR 0.152.
 */
package com.daposeidonguy.teamsmod.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.mojang.realmsclient.util.Pair;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber(modid="teamsmod", value={Side.CLIENT})
public class ClientHelper {
    private static final Map<UUID, String> idtoNameMap = new HashMap<UUID, String>();
    private static final Map<String, UUID> nametoIdMap = new HashMap<String, UUID>();
    public static final Map<UUID, Pair<Integer, Vec2f>> idtoPosMap = new HashMap<UUID, Pair<Integer, Vec2f>>();
    public static final Minecraft mc = Minecraft.func_71410_x();
    public static long ticks = 0L;

    public static ScaledResolution getWindow() {
        return new ScaledResolution(mc);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        ++ticks;
    }

    public static UUID getIdFromName(String name) {
        return nametoIdMap.get(name);
    }

    public static String getNameFromId(UUID uuid) {
        String playerName = ClientHelper.getOnlineUsernameFromUUID(uuid);
        if (playerName == null) {
            String uuidString = uuid.toString().replace("-", "");
            String url = "https://api.mojang.com/user/profiles/" + uuidString + "/names";
            try {
                String nameJson = IOUtils.toString((URL)new URL(url), (String)"ANSI");
                JsonArray jsonArray = new JsonParser().parse(nameJson).getAsJsonArray();
                playerName = jsonArray.get(0).getAsJsonObject().get("name").getAsString();
            }
            catch (Exception ex) {
                playerName = I18n.func_135052_a((String)"teamsmod.unknownplayer", (Object[])new Object[0]);
            }
        }
        return playerName;
    }

    public static String getOnlineUsernameFromUUID(UUID uuid) {
        String playerName = idtoNameMap.get(uuid);
        if (playerName == null) {
            playerName = UsernameCache.getLastKnownUsername((UUID)uuid);
        }
        if (playerName == null) {
            try {
                playerName = mc.func_147114_u().func_175102_a(uuid).func_178845_a().getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return playerName;
    }

    public static void addPlayerMapping(String name, UUID playerId) {
        idtoNameMap.put(playerId, name);
        nametoIdMap.put(name, playerId);
    }
}

