/*
 * Decompiled with CFR 0.152.
 */
package com.noobanidus.superflatcaves;

import com.noobanidus.superflatcaves.Handler;
import com.noobanidus.superflatcaves.WorldProviderCaves;
import com.noobanidus.superflatcaves.WorldTypeFlat;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(modid="superflatcaves", name="SuperflatCaves", version="1.3.1", dependencies="after:voidislandcontrol;", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
public class SuperflatCaves {
    public static final String MODID = "superflatcaves";
    public static final String MODNAME = "SuperflatCaves";
    public static final String VERSION = "1.3.1";
    public static final String DEPENDS = "after:voidislandcontrol;";
    public static final Logger LOG = LogManager.getLogger((String)"superflatcaves");
    @Mod.Instance(value="superflatcaves")
    public static SuperflatCaves instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOG.info("Replacing FLAT world generator with delightful, cave-filled generator!");
        WorldTypeFlat.createFlatWorld();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (!SuperflatConfig.OVERRIDE_PROVIDER) {
            try {
                DimensionManager.unregisterDimension((int)0);
                DimensionManager.registerDimension((int)0, (DimensionType)DimensionType.register((String)"OVERWORLD_CAVES", (String)"", (int)0, WorldProviderCaves.class, (boolean)true));
            }
            catch (Exception e) {
                LOG.error("Unable to replace overworld provider with overworld_caves provider.");
                e.printStackTrace();
            }
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        WorldServer world = DimensionManager.getWorld((int)0);
        world.func_181544_b(SuperflatConfig.SEA_LEVEL);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        if (Loader.isModLoaded((String)"voidislandcontrol")) {
            LOG.info("Allowing Void Island Control into the tendril-like folds of caves...");
            Handler.replaceVoid();
        }
    }

    @Config(modid="superflatcaves")
    public static class SuperflatConfig {
        @Config.Comment(value={"Set to false to prevent caves from generating above 128 (Vanilla Default) (only works with vanilla caves as other cave generating mods handle cave generation)"})
        @Config.Name(value="Allow Higher Caves")
        public static boolean HIGHER_CAVES = true;
        @Config.Comment(value={"Set to whatever value between 1-256 you wish caves to stop at"})
        @Config.Name(value="Cave Height Limit")
        @Config.RangeInt(min=1, max=256)
        public static int CAVE_HEIGHT = 256;
        @Config.Comment(value={"The average ground level the world provider should return for the overworld"})
        @Config.Name(value="Average ground level")
        public static int AVERAGE_GROUND_LEVEL = 23;
        @Config.Comment(value={"The sea level the world provider should return for the overworld"})
        @Config.Name(value="Sea level")
        public static int SEA_LEVEL = 63;
        @Config.Comment(value={"Set to true to override the celestial angle and prevent the day/night cycle from having a visual"})
        @Config.Name(value="Override Celestial Angle")
        public static boolean OVERRIDE_CELESTIAL_ANGLE = false;
        @Config.Comment(value={"Set to the value you wish the sun/moon to be at. 0f = midnight"})
        @Config.Name(value="Celestial Angle Value")
        public static float CELESTIAL_ANGLE = 0.0f;
        @Config.Comment(value={"Set to false to prevent the sky from being coloured"})
        @Config.Name(value="Sky Coloured")
        public static boolean SKY_COLOURED = false;
        @Config.Comment(value={"Set to true to override x/y shows fog from returning default and using the value specified below"})
        @Config.Name(value="Override Fog Value")
        public static boolean OVERRIDE_FOG = false;
        @Config.Comment(value={"Set to true or false to determine if all coordinates show or don't show fog"})
        @Config.Name(value="Fog Value (Overriden)")
        public static boolean FOG_VALUE = false;
        @Config.Comment(value={"Set to true to disable overriding the overworld world provider. Disabling this will prevent fog, sea level, celestial angle, and coloured sky options."})
        @Config.Name(value="Disable world provider override")
        public static boolean OVERRIDE_PROVIDER = false;

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals(SuperflatCaves.MODID)) {
                ConfigManager.sync((String)SuperflatCaves.MODID, (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

