/*
 * Decompiled with CFR 0.152.
 */
package com.noobanidus.superflatcaves;

import com.noobanidus.superflatcaves.MapGenCaves256;
import com.noobanidus.superflatcaves.SuperflatCaves;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorFlat;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkGeneratorFlatCaves
extends ChunkGeneratorFlat {
    private World world;
    private MapGenBase caveGenerator = SuperflatCaves.SuperflatConfig.HIGHER_CAVES ? new MapGenCaves256() : new MapGenCaves();
    private MapGenBase ravineGenerator = new MapGenRavine();
    private WorldGenLakes waterLakeGenerator = null;
    private WorldGenLakes lavaLakeGenerator = null;
    private final boolean hasDecoration;
    private final boolean hasDungeons;
    private final boolean hasAnimals;
    private final boolean hasIce;
    private final boolean hasCaves;
    private final boolean hasRavines;

    public ChunkGeneratorFlatCaves(World worldIn, long seed, boolean generateStructures, String flatGeneratorSettings) {
        super(worldIn, seed, generateStructures, flatGeneratorSettings);
        this.world = worldIn;
        SuperflatCaves.LOG.info(this.caveGenerator.getClass().toString());
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        SuperflatCaves.LOG.info(this.caveGenerator.getClass().toString());
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.field_82699_e = FlatGeneratorInfo.func_82651_a((String)flatGeneratorSettings);
        Map map = this.field_82699_e.func_82644_b();
        if (generateStructures) {
            MapGenScatteredFeature temp;
            if (map.containsKey("village")) {
                Map map1 = (Map)map.get("village");
                if (!map1.containsKey("size")) {
                    map1.put("size", "1");
                }
                MapGenVillage temp2 = new MapGenVillage(map1);
                MapGenVillage villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)temp2, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
                this.field_82696_f.put("Village", villageGenerator);
            }
            if (map.containsKey("biome_1")) {
                temp = new MapGenScatteredFeature((Map)map.get("biome_1"));
                MapGenScatteredFeature scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)temp, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
                this.field_82696_f.put("Temple", scatteredFeatureGenerator);
            }
            if (map.containsKey("mineshaft")) {
                temp = new MapGenMineshaft((Map)map.get("mineshaft"));
                MapGenMineshaft mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)temp, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
                this.field_82696_f.put("Mineshaft", mineshaftGenerator);
            }
            if (map.containsKey("stronghold")) {
                temp = new MapGenStronghold((Map)map.get("stronghold"));
                MapGenStronghold strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)temp, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
                this.field_82696_f.put("Stronghold", strongholdGenerator);
            }
            if (map.containsKey("oceanmonument")) {
                temp = new StructureOceanMonument((Map)map.get("oceanmonument"));
                StructureOceanMonument oceanMonumentGenerator = (StructureOceanMonument)TerrainGen.getModdedMapGen((MapGenBase)temp, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.OCEAN_MONUMENT);
                this.field_82696_f.put("Monument", oceanMonumentGenerator);
            }
        }
        if (map.containsKey("lake")) {
            this.waterLakeGenerator = new WorldGenLakes((Block)Blocks.field_150355_j);
        }
        if (map.containsKey("lava_lake")) {
            this.lavaLakeGenerator = new WorldGenLakes((Block)Blocks.field_150353_l);
        }
        this.hasCaves = map.containsKey("caves");
        this.hasRavines = map.containsKey("ravines");
        this.hasDungeons = map.containsKey("dungeon");
        this.hasDecoration = map.containsKey("decoration");
        this.hasAnimals = map.containsKey("animals");
        this.hasIce = map.containsKey("ice");
    }

    @Nonnull
    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        for (int i = 0; i < this.field_82700_c.length; ++i) {
            IBlockState iblockstate = this.field_82700_c[i];
            if (iblockstate == null) continue;
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    chunkprimer.func_177855_a(j, i, k, iblockstate);
                }
            }
        }
        if (this.hasCaves) {
            this.caveGenerator.func_186125_a(this.world, x, z, chunkprimer);
        }
        if (this.hasRavines) {
            this.ravineGenerator.func_186125_a(this.world, x, z, chunkprimer);
        }
        for (MapGenBase mapgenbase : this.field_82696_f.values()) {
            mapgenbase.func_186125_a(this.world, x, z, chunkprimer);
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        Biome[] abiome = this.world.func_72959_q().func_76933_b(null, x * 16, z * 16, 16, 16);
        byte[] abyte = chunk.func_76605_m();
        for (int l = 0; l < abyte.length; ++l) {
            abyte[l] = (byte)Biome.func_185362_a((Biome)abiome[l]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        BlockPos blockpos1;
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(new BlockPos(i + 16, 0, j + 16));
        boolean flag = false;
        this.field_73161_b.setSeed(this.world.func_72905_C());
        long k = this.field_73161_b.nextLong() / 2L * 2L + 1L;
        long l = this.field_73161_b.nextLong() / 2L * 2L + 1L;
        this.field_73161_b.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        ChunkPos chunkpos = new ChunkPos(x, z);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.field_73161_b, (int)x, (int)z, (boolean)flag);
        for (MapGenStructure mapgenstructure : this.field_82696_f.values()) {
            boolean flag1 = mapgenstructure.func_175794_a(this.world, this.field_73161_b, chunkpos);
            if (!(mapgenstructure instanceof MapGenVillage)) continue;
            flag |= flag1;
        }
        if (this.waterLakeGenerator != null && !flag && this.field_73161_b.nextInt(4) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.field_73161_b, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            this.waterLakeGenerator.func_180709_b(this.world, this.field_73161_b, blockpos.func_177982_a(this.field_73161_b.nextInt(16) + 8, this.field_73161_b.nextInt(256), this.field_73161_b.nextInt(16) + 8));
        }
        if (this.lavaLakeGenerator != null && !flag && this.field_73161_b.nextInt(8) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.field_73161_b, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && ((blockpos1 = blockpos.func_177982_a(this.field_73161_b.nextInt(16) + 8, this.field_73161_b.nextInt(this.field_73161_b.nextInt(248) + 8), this.field_73161_b.nextInt(16) + 8)).func_177956_o() < this.world.func_181545_F() || this.field_73161_b.nextInt(10) == 0)) {
            this.lavaLakeGenerator.func_180709_b(this.world, this.field_73161_b, blockpos1);
        }
        if (this.hasDungeons && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.field_73161_b, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (int i1 = 0; i1 < 8; ++i1) {
                new WorldGenDungeons().func_180709_b(this.world, this.field_73161_b, blockpos.func_177982_a(this.field_73161_b.nextInt(16) + 8, this.field_73161_b.nextInt(256), this.field_73161_b.nextInt(16) + 8));
            }
        }
        if (this.hasDecoration) {
            biome.func_180624_a(this.world, this.field_73161_b, blockpos);
        }
        if (this.hasAnimals && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.field_73161_b, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.field_73161_b);
        }
        if (this.hasIce) {
            TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.field_73161_b, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.field_73161_b, (int)x, (int)z, (boolean)flag);
        BlockFalling.field_149832_M = false;
    }
}

