/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.recipes;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.recipes.SharedRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.BannerPattern;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class RatsRecipeRegistry {
    public static List<SharedRecipe> CAULDRON_RECIPES = new ArrayList<SharedRecipe>();
    public static List<SharedRecipe> RAT_CHEF_RECIPES = new ArrayList<SharedRecipe>();
    public static List<SharedRecipe> RAT_ARCHEOLOGIST_RECIPES = new ArrayList<SharedRecipe>();
    public static List<SharedRecipe> RAT_GEMCUTTER_RECIPES = new ArrayList<SharedRecipe>();

    public static void preRegister() {
        RAT_CHEF_RECIPES.add(new SharedRecipe(new ItemStack(RatsItemRegistry.ASSORTED_VEGETABLES), new ItemStack(RatsItemRegistry.CONFIT_BYALDI)));
        RAT_CHEF_RECIPES.add(new SharedRecipe(new ItemStack(RatsItemRegistry.CHEESE), new ItemStack(RatsItemRegistry.STRING_CHEESE, 4)));
        RAT_CHEF_RECIPES.add(new SharedRecipe(new ItemStack(RatsItemRegistry.CENTIPEDE), new ItemStack(RatsItemRegistry.POTATO_KNISHES)));
        RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack(Items.field_151166_bC), new ItemStack(RatsItemRegistry.GEM_OF_RATLANTIS)));
        RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack(RatsItemRegistry.RAT_UPGRADE_BASIC), new ItemStack(RatsItemRegistry.RAT_UPGRADE_BASIC_RATLANTEAN)));
        RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack(RatsItemRegistry.PIPER_HAT), new ItemStack(RatsItemRegistry.PIRAT_HAT)));
        RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack(Items.field_151065_br), new ItemStack(RatsItemRegistry.RATLANTEAN_FLAME)));
        RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((Item)Items.field_151027_R), new ItemStack(RatsItemRegistry.RAT_TOGA)));
        RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack(Items.field_179556_br), new ItemStack(RatsItemRegistry.FERAL_RAT_CLAW)));
        RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack(Items.field_151059_bz), new ItemStack(RatsItemRegistry.CHEESE_CANNONBALL)));
        RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack(Items.field_151040_l), new ItemStack(RatsItemRegistry.PIRAT_CUTLASS)));
        RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack(Items.field_179555_bs), new ItemStack(RatsItemRegistry.RAT_PELT)));
        if (RatsMod.CONFIG_OPTIONS.disableRatlantis) {
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((Block)Blocks.field_150461_bJ), new ItemStack(RatsItemRegistry.ARCANE_TECHNOLOGY)));
            RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack(Items.field_185157_bK), new ItemStack(RatsItemRegistry.PSIONIC_RAT_BRAIN)));
        }
        RAT_GEMCUTTER_RECIPES.add(new SharedRecipe(new ItemStack(Items.field_151045_i), new ItemStack(RatsItemRegistry.RAT_DIAMOND, 4)));
        RAT_GEMCUTTER_RECIPES.add(new SharedRecipe(new ItemStack(Items.field_151044_h), new ItemStack(RatsItemRegistry.LITTLE_BLACK_SQUASH_BALLS)));
        RAT_GEMCUTTER_RECIPES.add(new SharedRecipe(new ItemStack(RatsItemRegistry.LITTLE_BLACK_WORM), new ItemStack(RatsItemRegistry.CENTIPEDE)));
    }

    public static void register() {
        CAULDRON_RECIPES.add(new SharedRecipe(new ItemStack(Items.field_151117_aB), new ItemStack(RatsBlockRegistry.BLOCK_OF_CHEESE)));
        RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack(RatsBlockRegistry.BLOCK_OF_CHEESE), new ItemStack(RatsBlockRegistry.MARBLED_CHEESE_RAW)));
        RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack(Items.field_151144_bL), new ItemStack(RatsBlockRegistry.MARBLED_CHEESE_RAT_HEAD)));
        RAT_ARCHEOLOGIST_RECIPES.add(new SharedRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, 1), new ItemStack(RatsBlockRegistry.RATGLOVE_FLOWER)));
        OreDictionary.registerOre((String)"foodCheese", (Item)RatsItemRegistry.CHEESE);
        OreDictionary.registerOre((String)"listAllmeatraw", (Item)RatsItemRegistry.RAW_RAT);
        OreDictionary.registerOre((String)"foodRatraw", (Item)RatsItemRegistry.RAW_RAT);
        OreDictionary.registerOre((String)"listAllmeatcooked", (Item)RatsItemRegistry.COOKED_RAT);
        OreDictionary.registerOre((String)"foodRatcooked", (Item)RatsItemRegistry.COOKED_RAT);
        OreDictionary.registerOre((String)"blockCheese", (Block)RatsBlockRegistry.BLOCK_OF_CHEESE);
        OreDictionary.registerOre((String)"foodVegetable", (Item)Items.field_151174_bG);
        OreDictionary.registerOre((String)"foodVegetable", (Item)Items.field_151172_bF);
        OreDictionary.registerOre((String)"foodVegetable", (Item)Items.field_185164_cV);
        OreDictionary.registerOre((String)"foodVegetable", (Block)Blocks.field_150423_aK);
        if (RatsMod.CONFIG_OPTIONS.disablePlastic) {
            OreDictionary.registerOre((String)"plasticOrGlass", (Block)Blocks.field_150410_aZ);
            OreDictionary.registerOre((String)"plasticOrBottle", (Item)Items.field_151069_bo);
        } else {
            OreDictionary.registerOre((String)"plasticOrGlass", (Item)RatsItemRegistry.RAW_PLASTIC);
            OreDictionary.registerOre((String)"plasticOrBottle", (Item)RatsItemRegistry.PLASTIC_WASTE);
            OreDictionary.registerOre((String)"plastic", (Item)RatsItemRegistry.RAW_PLASTIC);
            OreDictionary.registerOre((String)"ingotPlastic", (Item)RatsItemRegistry.RAW_PLASTIC);
        }
        OreDictionary.registerOre((String)"listAllwater", (Item)Items.field_151131_as);
        OreDictionary.registerOre((String)"listAllseed", (Item)Items.field_151014_N);
        OreDictionary.registerOre((String)"listAllseed", (Item)Items.field_151080_bb);
        OreDictionary.registerOre((String)"listAllseed", (Item)Items.field_185163_cU);
        OreDictionary.registerOre((String)"listAllseed", (Item)Items.field_151081_bc);
        OreDictionary.registerOre((String)"flower", (ItemStack)new ItemStack((Block)Blocks.field_150328_O, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"flower", (ItemStack)new ItemStack((Block)Blocks.field_150327_N, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"fish", (ItemStack)new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE));
        if (RatsMod.CONFIG_OPTIONS.disableRatlantis) {
            OreDictionary.registerOre((String)"tokenOrIdolFlag", (Item)RatsItemRegistry.CHUNKY_CHEESE_TOKEN);
        } else {
            OreDictionary.registerOre((String)"tokenOrIdolFlag", (Item)RatsItemRegistry.IDOL_OF_RATLANTIS);
        }
        for (Block block : RatsBlockRegistry.RAT_TUBE_COLOR) {
            OreDictionary.registerOre((String)"ratTube", (Block)block);
        }
        for (Block block : RatsItemRegistry.RAT_IGLOOS) {
            OreDictionary.registerOre((String)"ratIgloo", (Item)block);
        }
        for (Block block : RatsItemRegistry.RAT_HAMMOCKS) {
            OreDictionary.registerOre((String)"ratHammock", (Item)block);
        }
        for (Block block : EnumDyeColor.values()) {
            String woolColor = block.func_176762_d();
            woolColor = woolColor.substring(0, 1).toUpperCase() + woolColor.substring(1).toLowerCase();
            OreDictionary.registerOre((String)("wool" + woolColor), (ItemStack)new ItemStack(Blocks.field_150325_L, 1, block.func_176765_a()));
        }
        OreDictionary.registerOre((String)"woolLightBlue", (ItemStack)new ItemStack(Blocks.field_150325_L, 1, 3));
        OreDictionary.registerOre((String)"ratPoop", (Item)RatsItemRegistry.RAT_NUGGET);
        GameRegistry.addSmelting((Item)RatsItemRegistry.RAW_RAT, (ItemStack)new ItemStack(RatsItemRegistry.COOKED_RAT), (float)0.4f);
        GameRegistry.addSmelting((Block)RatsBlockRegistry.MARBLED_CHEESE_RAW, (ItemStack)new ItemStack(RatsBlockRegistry.MARBLED_CHEESE), (float)0.1f);
        GameRegistry.addSmelting((Block)RatsBlockRegistry.MARBLED_CHEESE_BRICK, (ItemStack)new ItemStack(RatsBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED), (float)0.1f);
        GameRegistry.addSmelting((Item)RatsItemRegistry.PLASTIC_WASTE, (ItemStack)new ItemStack(RatsItemRegistry.RAW_PLASTIC), (float)0.5f);
        RatsRecipeRegistry.addBanner("rat", new ItemStack(RatsItemRegistry.RAT_PELT));
        RatsRecipeRegistry.addBanner("cheese", new ItemStack(RatsItemRegistry.CHEESE));
        RatsRecipeRegistry.addBanner("rat_and_crossbones", new ItemStack(RatsItemRegistry.PIRAT_HAT));
        RatsItemRegistry.CHEF_TOQUE_ARMOR_MATERIAL.setRepairItem(new ItemStack(Blocks.field_150325_L));
        RatsItemRegistry.HAT_ARMOR_MATERIAL.setRepairItem(new ItemStack(Items.field_151116_aA));
        RatsItemRegistry.PIRAT_CUTLASS_MATERIAL.setRepairItem(new ItemStack(Items.field_151042_j));
        RatsItemRegistry.BAGHNAKHS_MATERIAL.setRepairItem(new ItemStack(RatsItemRegistry.FERAL_RAT_CLAW));
        RatsItemRegistry.PLAGUE_SCYTHE_MATERIAL.setRepairItem(new ItemStack(RatsItemRegistry.PLAGUE_ESSENCE));
        RatsItemRegistry.PLAGUE_MASK_MATERIAL.setRepairItem(new ItemStack(RatsItemRegistry.PLAGUE_ESSENCE));
    }

    public static BannerPattern addBanner(String name, ItemStack craftingStack) {
        Class[] classes = new Class[]{String.class, String.class, ItemStack.class};
        Object[] names = new Object[]{name, "rats." + name, craftingStack};
        return (BannerPattern)EnumHelper.addEnum(BannerPattern.class, (String)name.toUpperCase(), (Class[])classes, (Object[])names);
    }

    public static SharedRecipe getRatChefRecipe(ItemStack stack) {
        for (SharedRecipe recipe : RAT_CHEF_RECIPES) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe;
        }
        return null;
    }

    public static SharedRecipe getArcheologistRecipe(ItemStack stack) {
        for (SharedRecipe recipe : RAT_ARCHEOLOGIST_RECIPES) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe;
        }
        return null;
    }

    public static SharedRecipe getGemcutterRecipe(ItemStack stack) {
        for (SharedRecipe recipe : RAT_GEMCUTTER_RECIPES) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe;
        }
        return null;
    }
}

