/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.entity.EntityRat;
import io.netty.buffer.ByteBuf;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageUpdateRatFluid
extends AbstractMessage<MessageUpdateRatFluid> {
    public int ratId;
    public FluidStack fluid;

    public MessageUpdateRatFluid() {
    }

    public MessageUpdateRatFluid(int ratId, FluidStack fluid) {
        this.ratId = ratId;
        this.fluid = fluid;
    }

    public void onClientReceived(Minecraft client, MessageUpdateRatFluid message, EntityPlayer player, MessageContext messageContext) {
        Entity entity = player.field_70170_p.func_73045_a(message.ratId);
        if (entity instanceof EntityRat) {
            EntityRat rat = (EntityRat)entity;
            rat.transportingFluid = message.fluid;
        }
    }

    public void onServerReceived(MinecraftServer server, MessageUpdateRatFluid message, EntityPlayer player, MessageContext messageContext) {
        Entity entity = player.field_70170_p.func_73045_a(message.ratId);
        if (entity instanceof EntityRat) {
            EntityRat rat = (EntityRat)entity;
            rat.transportingFluid = message.fluid;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.ratId = buf.readInt();
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.ratId);
        NBTTagCompound fluidTag = new NBTTagCompound();
        if (this.fluid != null) {
            this.fluid.writeToNBT(fluidTag);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)fluidTag);
    }
}

