/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.entity.tile.TileEntityAutoCurdler;
import io.netty.buffer.ByteBuf;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageAutoCurdlerFluid
extends AbstractMessage<MessageAutoCurdlerFluid> {
    public long blockPos;
    public FluidStack fluid;

    public MessageAutoCurdlerFluid() {
    }

    public MessageAutoCurdlerFluid(long blockPos, FluidStack fluid) {
        this.blockPos = blockPos;
        this.fluid = fluid;
    }

    public void onClientReceived(Minecraft client, MessageAutoCurdlerFluid message, EntityPlayer player, MessageContext messageContext) {
        BlockPos pos = BlockPos.func_177969_a((long)message.blockPos);
        if (player.field_70170_p.func_175625_s(pos) instanceof TileEntityAutoCurdler) {
            TileEntityAutoCurdler table = (TileEntityAutoCurdler)player.field_70170_p.func_175625_s(pos);
            table.tank.setFluid(message.fluid);
        }
    }

    public void onServerReceived(MinecraftServer server, MessageAutoCurdlerFluid message, EntityPlayer player, MessageContext messageContext) {
        BlockPos pos = BlockPos.func_177969_a((long)message.blockPos);
        if (player.field_70170_p.func_175625_s(pos) instanceof TileEntityAutoCurdler) {
            TileEntityAutoCurdler table = (TileEntityAutoCurdler)player.field_70170_p.func_175625_s(pos);
            table.tank.setFluid(message.fluid);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.blockPos = buf.readLong();
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.blockPos);
        NBTTagCompound fluidTag = new NBTTagCompound();
        if (this.fluid != null) {
            this.fluid.writeToNBT(fluidTag);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)fluidTag);
    }
}

