/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.events;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.compat.TinkersCompatBridge;
import com.github.alexthe666.rats.server.entity.EntityBlackDeath;
import com.github.alexthe666.rats.server.entity.EntityIllagerPiper;
import com.github.alexthe666.rats.server.entity.EntityPlagueDoctor;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.message.MessageRatDismount;
import com.github.alexthe666.rats.server.message.MessageSwingArm;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class ServerEvents {
    Predicate<Entity> UNTAMED_RAT_SELECTOR = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_ instanceof EntityRat && !((EntityRat)p_apply_1_).func_70909_n();
        }
    };

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == RatsItemRegistry.CHEESE_STICK || event.getEntityPlayer().func_184586_b(EnumHand.OFF_HAND).func_77973_b() == RatsItemRegistry.CHEESE_STICK) {
            event.setUseBlock(Event.Result.DENY);
        }
        if (!(event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b() != RatsItemRegistry.CHUNKY_CHEESE_TOKEN && event.getEntityPlayer().func_184586_b(EnumHand.OFF_HAND).func_77973_b() != RatsItemRegistry.CHUNKY_CHEESE_TOKEN || RatsMod.CONFIG_OPTIONS.disableRatlantis)) {
            if (!event.getEntityPlayer().func_184812_l_()) {
                event.getItemStack().func_190918_g(1);
            }
            boolean canBuild = true;
            BlockPos pos = event.getPos().func_177972_a(event.getFace());
            for (int i = 0; i < 4; ++i) {
                IBlockState state = event.getWorld().func_180495_p(pos.func_177981_b(i));
                if (state.func_185887_b(event.getWorld(), pos.func_177981_b(i)) != -1.0f) continue;
                canBuild = false;
            }
            if (canBuild) {
                event.getEntityPlayer().func_184185_a(SoundEvents.field_193782_bq, 1.0f, 1.0f);
                event.getWorld().func_175656_a(pos, RatsBlockRegistry.MARBLED_CHEESE_RAW.func_176223_P());
                event.getWorld().func_175656_a(pos.func_177984_a(), RatsBlockRegistry.RATLANTIS_PORTAL.func_176223_P());
                event.getWorld().func_175656_a(pos.func_177981_b(2), RatsBlockRegistry.RATLANTIS_PORTAL.func_176223_P());
                event.getWorld().func_175656_a(pos.func_177981_b(3), RatsBlockRegistry.MARBLED_CHEESE_RAW.func_176223_P());
            }
        }
        if (RatsMod.CONFIG_OPTIONS.cheesemaking && event.getWorld().func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150383_bp && this.isMilk(event.getItemStack()) && (Integer)event.getWorld().func_180495_p(event.getPos()).func_177229_b((IProperty)BlockCauldron.field_176591_a) == 0) {
            event.getWorld().func_175656_a(event.getPos(), RatsBlockRegistry.MILK_CAULDRON.func_176223_P());
            if (!event.getWorld().field_72995_K) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)event.getEntityPlayer(), event.getPos(), new ItemStack(RatsBlockRegistry.MILK_CAULDRON));
            }
            event.getEntityPlayer().func_184185_a(SoundEvents.field_187624_K, 1.0f, 1.0f);
            if (!event.getEntityPlayer().func_184812_l_()) {
                IFluidHandlerItem fluidHandler;
                if (event.getItemStack().func_77973_b() == Items.field_151117_aB) {
                    event.getItemStack().func_190918_g(1);
                    event.getEntityPlayer().func_191521_c(new ItemStack(Items.field_151133_ar));
                } else if (this.isMilk(event.getItemStack()) && (fluidHandler = FluidUtil.getFluidHandler((ItemStack)event.getItemStack())) != null) {
                    fluidHandler.drain(1000, true);
                }
            }
            event.setUseItem(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    private boolean isMilk(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151117_aB) {
            return true;
        }
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
        return fluidStack != null && fluidStack.amount >= 1000 && (fluidStack.getFluid().getUnlocalizedName().contains("milk") || fluidStack.getFluid().getUnlocalizedName().contains("Milk"));
    }

    @SubscribeEvent
    public void onPlayerInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        PotionEffect plague;
        IRangedAttackMob doctor;
        Object villager;
        ItemStack heldItem;
        if (event.getTarget() instanceof EntityOcelot) {
            EntityOcelot ocelot = (EntityOcelot)event.getTarget();
            Item heldItem2 = event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b();
            Random random = event.getWorld().field_73012_v;
            if (ocelot.func_110143_aJ() < ocelot.func_110138_aP()) {
                int i;
                if (heldItem2 == RatsItemRegistry.RAW_RAT) {
                    ocelot.func_70691_i(4.0f);
                    event.getWorld().func_184148_a(null, ocelot.field_70165_t, ocelot.field_70163_u, ocelot.field_70161_v, SoundEvents.field_191253_dD, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    event.getWorld().func_184148_a(null, ocelot.field_70165_t, ocelot.field_70163_u, ocelot.field_70161_v, SoundEvents.field_187636_O, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    for (i = 0; i < 3; ++i) {
                        event.getWorld().func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, ocelot.field_70165_t + random.nextDouble() - random.nextDouble(), ocelot.field_70163_u + 0.5 + random.nextDouble() - random.nextDouble(), ocelot.field_70161_v + random.nextDouble() - random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (heldItem2 == RatsItemRegistry.COOKED_RAT) {
                    ocelot.func_70691_i(8.0f);
                    event.getWorld().func_184148_a(null, ocelot.field_70165_t, ocelot.field_70163_u, ocelot.field_70161_v, SoundEvents.field_191253_dD, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    event.getWorld().func_184148_a(null, ocelot.field_70165_t, ocelot.field_70163_u, ocelot.field_70161_v, SoundEvents.field_187636_O, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    for (i = 0; i < 3; ++i) {
                        event.getWorld().func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, ocelot.field_70165_t + random.nextDouble() - random.nextDouble(), ocelot.field_70163_u + 0.5 + random.nextDouble() - random.nextDouble(), ocelot.field_70161_v + random.nextDouble() - random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
        if (event.getTarget() instanceof EntityVillager && (heldItem = event.getEntityPlayer().func_184586_b(event.getHand())).func_77973_b() == RatsItemRegistry.PLAGUE_DOCTORATE && !((EntityVillager)event.getTarget()).func_70631_g_()) {
            villager = (EntityVillager)event.getTarget();
            doctor = new EntityPlagueDoctor(event.getWorld());
            doctor.func_82149_j((Entity)villager);
            villager.func_70106_y();
            doctor.func_180482_a(event.getWorld().func_175649_E(event.getPos()), null);
            if (!event.getWorld().field_72995_K) {
                event.getWorld().func_72838_d((Entity)doctor);
            }
            doctor.func_94061_f(villager.func_175446_cd());
            if (villager.func_145818_k_()) {
                doctor.func_96094_a(villager.func_95999_t());
                doctor.func_174805_g(villager.func_174833_aM());
            }
            event.getEntityPlayer().func_184609_a(event.getHand());
            if (!event.getEntityPlayer().func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
        }
        if (event.getTarget() instanceof EntityPlagueDoctor && (heldItem = event.getEntityPlayer().func_184586_b(event.getHand())).func_77973_b() == RatsItemRegistry.PLAGUE_TOME && !((EntityPlagueDoctor)event.getTarget()).func_70631_g_()) {
            villager = (EntityPlagueDoctor)event.getTarget();
            doctor = new EntityBlackDeath(event.getWorld());
            doctor.func_82149_j((Entity)villager);
            villager.func_70106_y();
            doctor.func_180482_a(event.getWorld().func_175649_E(event.getPos()), null);
            if (!event.getWorld().field_72995_K) {
                event.getWorld().func_72838_d((Entity)doctor);
            }
            doctor.func_94061_f(villager.func_175446_cd());
            if (villager.func_145818_k_()) {
                doctor.func_96094_a(villager.func_95999_t());
                doctor.func_174805_g(villager.func_174833_aM());
            }
            event.getEntityPlayer().func_184609_a(event.getHand());
            if (!event.getEntityPlayer().func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
        }
        if ((plague = event.getEntityPlayer().func_70660_b(RatsMod.PLAGUE_POTION)) != null && RatsMod.CONFIG_OPTIONS.plagueSpread && !(event.getTarget() instanceof EntityRat) && event.getTarget() instanceof EntityLivingBase && !((EntityLivingBase)event.getTarget()).func_70644_a(RatsMod.PLAGUE_POTION)) {
            ((EntityLivingBase)event.getTarget()).func_70690_d(new PotionEffect(RatsMod.PLAGUE_POTION, RatsMod.CONFIG_OPTIONS.plagueEffectDuration * 20));
            event.getTarget().func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public void onPlayerPunch(AttackEntityEvent event) {
        ItemStack itemstack = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
        TinkersCompatBridge.onPlayerSwing((EntityLivingBase)event.getEntityPlayer(), itemstack);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof EntityIronGolem && RatsMod.CONFIG_OPTIONS.golemsTargetRats) {
            EntityIronGolem golem = (EntityIronGolem)event.getEntity();
            golem.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)golem, EntityRat.class, 10, false, false, this.UNTAMED_RAT_SELECTOR));
        }
        if (event.getEntity() != null && RatUtils.isPredator(event.getEntity()) && event.getEntity() instanceof EntityAnimal) {
            EntityAnimal animal = (EntityAnimal)event.getEntity();
            animal.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)animal, EntityRat.class, true));
        }
        if (event.getEntity() != null && event.getEntity() instanceof EntityHusk && ((EntityHusk)event.getEntity()).func_70681_au().nextFloat() < RatsMod.CONFIG_OPTIONS.archeologistHatSpawnRate) {
            event.getEntity().func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(RatsItemRegistry.ARCHEOLOGIST_HAT));
            ((EntityLiving)event.getEntity()).func_184642_a(EntityEquipmentSlot.HEAD, 0.5f);
        }
        if (event.getEntity() != null && (event.getEntity() instanceof AbstractSkeleton || event.getEntity() instanceof EntityZombie) && BiomeDictionary.hasType((Biome)event.getWorld().func_180494_b(event.getEntity().func_180425_c()), (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) && ((EntityLiving)event.getEntity()).func_70681_au().nextFloat() < RatsMod.CONFIG_OPTIONS.archeologistHatSpawnRate) {
            event.getEntity().func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(RatsItemRegistry.ARCHEOLOGIST_HAT));
            ((EntityLiving)event.getEntity()).func_184642_a(EntityEquipmentSlot.HEAD, 0.5f);
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack itemstack = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
        if (TinkersCompatBridge.onPlayerSwing((EntityLivingBase)event.getEntityPlayer(), itemstack)) {
            RatsMod.NETWORK_WRAPPER.sendToServer((IMessage)new MessageSwingArm());
        }
        if (event.getEntityPlayer().func_70093_af() && !event.getEntityPlayer().func_184188_bt().isEmpty()) {
            for (Entity passenger : event.getEntityPlayer().func_184188_bt()) {
                if (!(passenger instanceof EntityRat)) continue;
                passenger.func_184210_p();
                passenger.func_70107_b(event.getEntityPlayer().field_70165_t, event.getEntityPlayer().field_70163_u, event.getEntityPlayer().field_70161_v);
                RatsMod.NETWORK_WRAPPER.sendToServer((IMessage)new MessageRatDismount(passenger.func_145782_y()));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack itemstack = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
        TinkersCompatBridge.onPlayerSwing((EntityLivingBase)event.getEntityPlayer(), itemstack);
    }

    @SubscribeEvent
    public void onGatherCollisionBoxes(GetCollisionBoxesEvent event) {
        if (event.getEntity() instanceof EntityRat) {
            event.getCollisionBoxesList().removeIf(aabb -> ((EntityRat)event.getEntity()).canPhaseThroughBlock(event.getWorld(), new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c)));
        }
    }

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof EntityIllagerPiper && event.getSource().func_76346_g() instanceof EntityPlayer && event.getEntityLiving().field_70170_p.field_73012_v.nextFloat() < RatsMod.CONFIG_OPTIONS.piperHatDropRate + RatsMod.CONFIG_OPTIONS.piperHatDropRate / 2.0f * (float)event.getLootingLevel()) {
            event.getDrops().add(new EntityItem(event.getEntity().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, new ItemStack(RatsItemRegistry.PIPER_HAT)));
        }
        if (event.getEntityLiving() instanceof EntityCreeper && ((EntityCreeper)event.getEntityLiving()).func_70830_n()) {
            event.getDrops().add(new EntityItem(event.getEntity().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, new ItemStack(RatsItemRegistry.CHARGED_CREEPER_CHUNK, event.getLootingLevel() + 1 + event.getEntityLiving().field_70170_p.field_73012_v.nextInt(2))));
        }
        if (event.getSource().func_76346_g() instanceof EntityRat && ((EntityRat)event.getSource().func_76346_g()).hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ARISTOCRAT)) {
            event.getDrops().add(new EntityItem(event.getEntity().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, new ItemStack(RatsItemRegistry.TINY_COIN)));
        }
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent event) {
        PotionEffect plague = event.getEntityLiving().func_70660_b(RatsMod.PLAGUE_POTION);
        if (plague != null) {
            if (plague.func_76458_c() == 0) {
                event.setAmount(event.getAmount() * RatsMod.CONFIG_OPTIONS.plagueStage1HealingDebuff);
            } else if (plague.func_76458_c() > 0) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        EntityLivingBase attacker;
        PotionEffect plague;
        if (event.getEntityLiving() instanceof EntityPlayer) {
            AxisAlignedBB axisalignedbb = event.getEntityLiving().func_174813_aQ().func_72314_b(RatsMod.CONFIG_OPTIONS.ratVoodooDistance, RatsMod.CONFIG_OPTIONS.ratVoodooDistance, RatsMod.CONFIG_OPTIONS.ratVoodooDistance);
            List list = event.getEntityLiving().field_70170_p.func_72872_a(EntityRat.class, axisalignedbb);
            ArrayList<EntityRat> voodooRats = new ArrayList<EntityRat>();
            boolean capturedRat = false;
            if (!list.isEmpty()) {
                for (EntityRat rat : list) {
                    if (!rat.func_70909_n() || !rat.func_152114_e(event.getEntityLiving()) || !rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_VOODOO)) continue;
                    voodooRats.add(rat);
                }
                if (!voodooRats.isEmpty()) {
                    float damage = event.getAmount() / (float)Math.max(1, voodooRats.size());
                    event.setCanceled(true);
                    for (EntityRat rat : voodooRats) {
                        rat.func_70097_a(event.getSource(), damage);
                    }
                }
            }
        }
        if (event.getSource().func_76364_f() instanceof EntityLivingBase && RatsMod.CONFIG_OPTIONS.plagueSpread && (plague = (attacker = (EntityLivingBase)event.getSource().func_76364_f()).func_70660_b(RatsMod.PLAGUE_POTION)) != null && !(event.getEntityLiving() instanceof EntityRat) && !event.getEntityLiving().func_70644_a(RatsMod.PLAGUE_POTION)) {
            event.getEntityLiving().func_70690_d(new PotionEffect(RatsMod.PLAGUE_POTION, RatsMod.CONFIG_OPTIONS.plagueEffectDuration * 20));
            event.getEntityLiving().func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Random rand;
        if (event.getEntityLiving().field_70170_p.field_72995_K && (event.getEntityLiving().func_70644_a(RatsMod.PLAGUE_POTION) || event.getEntityLiving() instanceof EntityRat && ((EntityRat)event.getEntityLiving()).hasPlague()) && (rand = event.getEntityLiving().func_70681_au()).nextInt(4) == 0) {
            int entitySize = 1;
            if (event.getEntityLiving().func_174813_aQ().func_72320_b() > 0.0) {
                entitySize = Math.max(1, (int)event.getEntityLiving().func_174813_aQ().func_72320_b());
            }
            for (int i = 0; i < entitySize; ++i) {
                float motionX = rand.nextFloat() * 0.2f - 0.1f;
                float motionZ = rand.nextFloat() * 0.2f - 0.1f;
                RatsMod.PROXY.spawnParticle("flea", event.getEntityLiving().field_70165_t + (double)(rand.nextFloat() * event.getEntityLiving().field_70130_N * 2.0f) - (double)event.getEntityLiving().field_70130_N, event.getEntityLiving().field_70163_u + (double)(rand.nextFloat() * event.getEntityLiving().field_70131_O), event.getEntityLiving().field_70161_v + (double)(rand.nextFloat() * event.getEntityLiving().field_70130_N * 2.0f) - (double)event.getEntityLiving().field_70130_N, motionX, 0.0, motionZ);
            }
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (!entity.field_70170_p.field_72995_K) {
            PotionEffect plague = entity.func_70660_b(RatsMod.PLAGUE_POTION);
            NBTTagCompound data = entity.getEntityData();
            if (plague != null) {
                if (data.func_74762_e("plague_level") == 0) {
                    data.func_74768_a("plague_level", plague.func_76458_c() + 1);
                    data.func_74772_a("plague_infected_time", entity.field_70170_p.func_82737_E());
                }
                if (entity.field_70170_p.func_82737_E() - data.func_74763_f("plague_infected_time") >= (long)RatsMod.CONFIG_OPTIONS.plagueStageDuration * 20L && data.func_74762_e("plague_level") < 4) {
                    int amp = data.func_74762_e("plague_level");
                    entity.func_70690_d(new PotionEffect(RatsMod.PLAGUE_POTION, RatsMod.CONFIG_OPTIONS.plagueEffectDuration * 20, amp));
                    data.func_74772_a("plague_infected_time", entity.field_70170_p.func_82737_E());
                    data.func_74768_a("plague_level", amp + 1);
                }
            } else {
                if (data.func_74763_f("plague_infected_time") < Long.MAX_VALUE) {
                    data.func_74772_a("plague_infected_time", Long.MAX_VALUE);
                }
                if (data.func_74762_e("plague_level") > 0) {
                    data.func_74768_a("plague_level", 0);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && event.getSource() == RatsMod.plagueDamage) {
            event.getEntityLiving().getEntityData().func_74757_a("was_plagued", true);
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            AttributeModifier healthMod = event.getOriginal().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111127_a(RatsMod.PLAGUE_MAX_HEALTH_MODIFIER_UUID);
            ArrayListMultimap modMap = ArrayListMultimap.create();
            PotionEffect plague = event.getOriginal().func_70660_b(RatsMod.PLAGUE_POTION);
            EntityPlayer rebornPlayer = event.getEntityPlayer();
            if (plague != null) {
                rebornPlayer.getEntityData().func_74772_a("plague_infected_time", event.getOriginal().getEntityData().func_74763_f("plague_infected_time"));
                if (plague.func_76458_c() > 2 && event.getOriginal().getEntityData().func_74767_n("was_plagued")) {
                    healthMod = healthMod != null ? new AttributeModifier(RatsMod.PLAGUE_MAX_HEALTH_MODIFIER_UUID, "Rats Plague Max health debuff", (double)(-RatsMod.CONFIG_OPTIONS.plagueMaxHealthDebuff) + healthMod.func_111164_d(), 0) : RatsMod.PLAGUE_MAX_HEALTH_MODIFIER;
                    modMap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)healthMod);
                } else if (RatsMod.CONFIG_OPTIONS.plagueRespawnStage == -1) {
                    rebornPlayer.func_70690_d(new PotionEffect(RatsMod.PLAGUE_POTION, plague.func_76459_b(), plague.func_76458_c()));
                    rebornPlayer.getEntityData().func_74768_a("plague_level", plague.func_76458_c() + 1);
                } else if (RatsMod.CONFIG_OPTIONS.plagueRespawnStage > 0) {
                    rebornPlayer.func_70690_d(new PotionEffect(RatsMod.PLAGUE_POTION, plague.func_76459_b(), RatsMod.CONFIG_OPTIONS.plagueRespawnStage - 1));
                    rebornPlayer.getEntityData().func_74768_a("plague_level", RatsMod.CONFIG_OPTIONS.plagueRespawnStage);
                }
            }
            if (healthMod != null) {
                modMap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)healthMod);
            }
            rebornPlayer.func_110140_aT().func_111147_b((Multimap)modMap);
        }
    }

    @SubscribeEvent
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (event.getItem().func_77973_b().getRegistryName().toString().equals(RatsMod.CONFIG_OPTIONS.plagueRestoreHealthItem)) {
            ArrayListMultimap modMap = ArrayListMultimap.create();
            modMap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)RatsMod.PLAGUE_MAX_HEALTH_MODIFIER);
            event.getEntityLiving().func_110140_aT().func_111148_a((Multimap)modMap);
        }
    }

    @SubscribeEvent
    public void onChestGenerated(LootTableLoadEvent event) {
        if (RatsMod.CONFIG_OPTIONS.addLoot) {
            LootPool pool;
            LootEntryItem item;
            RandomChance chance;
            if (event.getName().equals((Object)LootTableList.field_186422_d) || event.getName().equals((Object)LootTableList.field_186424_f) || event.getName().equals((Object)LootTableList.field_186429_k) || event.getName().equals((Object)LootTableList.field_186430_l) || event.getName().equals((Object)LootTableList.field_186428_j) || event.getName().equals((Object)LootTableList.field_186427_i) || event.getName().equals((Object)LootTableList.field_186431_m) || event.getName().equals((Object)LootTableList.field_191192_o) || event.getName().equals((Object)LootTableList.field_186423_e)) {
                chance = new RandomChance(0.4f);
                item = new LootEntryItem(RatsItemRegistry.CONTAMINATED_FOOD, 20, 1, new LootFunction[0], new LootCondition[0], "rats:contaminated_food");
                pool = new LootPool(new LootEntry[]{item}, new LootCondition[]{chance}, new RandomValueRange(1.0f, 5.0f), new RandomValueRange(0.0f, 3.0f), "rats:contaminated_food");
                event.getTable().addPool(pool);
            }
            if (event.getName().equals((Object)LootTableList.field_186422_d) || event.getName().equals((Object)LootTableList.field_186424_f) || event.getName().equals((Object)LootTableList.field_186429_k) || event.getName().equals((Object)LootTableList.field_186430_l) || event.getName().equals((Object)LootTableList.field_186428_j) || event.getName().equals((Object)LootTableList.field_186427_i)) {
                chance = new RandomChance(0.2f);
                item = new LootEntryItem(RatsItemRegistry.TOKEN_FRAGMENT, 8, 10, new LootFunction[0], new LootCondition[0], "rats:token_fragment");
                pool = new LootPool(new LootEntry[]{item}, new LootCondition[]{chance}, new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 1.0f), "token_fragment");
                event.getTable().addPool(pool);
            }
            if (event.getName().equals((Object)LootTableList.field_186422_d) || event.getName().equals((Object)LootTableList.field_186424_f) || event.getName().equals((Object)LootTableList.field_186429_k) || event.getName().equals((Object)LootTableList.field_186430_l) || event.getName().equals((Object)LootTableList.field_186428_j) || event.getName().equals((Object)LootTableList.field_186427_i)) {
                chance = new RandomChance(0.05f);
                item = new LootEntryItem(RatsItemRegistry.RAT_UPGRADE_BASIC, 3, 8, new LootFunction[0], new LootCondition[0], "rats:rat_upgrade_basic");
                pool = new LootPool(new LootEntry[]{item}, new LootCondition[]{chance}, new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "rat_upgrade_basic");
                event.getTable().addPool(pool);
            }
        }
    }
}

