/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.tile;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.message.MessageAutoCurdlerFluid;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityAutoCurdler
extends TileEntity
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{1};
    public int ticksExisted;
    public FluidTank tank = new FluidTank(5000);
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private NonNullList<ItemStack> curdlerStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private int cookTime;
    private int totalCookTime;
    private int prevFluid = 0;

    public static boolean isMilk(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151117_aB) {
            return true;
        }
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
        return fluidStack != null && (fluidStack.getFluid().getUnlocalizedName().contains("milk") || fluidStack.getFluid().getUnlocalizedName().contains("Milk"));
    }

    public int func_70302_i_() {
        return this.curdlerStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.curdlerStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.curdlerStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.curdlerStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.curdlerStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.curdlerStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.curdlerStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.func_70296_d();
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tank.readFromNBT(compound);
        this.curdlerStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.curdlerStacks);
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.tank.writeToNBT(compound);
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        compound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.curdlerStacks);
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean isBurning() {
        return this.tank.getFluidAmount() >= 1000 && this.tank.getFluid() != null && this.isMilkFluid(this.tank.getFluid());
    }

    public void func_73660_a() {
        IFluidHandlerItem fluidHandler;
        FluidStack fluidStack;
        if (!this.field_145850_b.field_72995_K && this.prevFluid != this.tank.getFluidAmount()) {
            RatsMod.NETWORK_WRAPPER.sendToAll((IMessage)new MessageAutoCurdlerFluid(this.func_174877_v().func_177986_g(), this.tank.getFluid()));
            this.prevFluid = this.tank.getFluidAmount();
        }
        this.totalCookTime = RatsMod.CONFIG_OPTIONS.milkCauldronTime;
        ++this.ticksExisted;
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.isBurning()) {
                if (this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = RatsMod.CONFIG_OPTIONS.milkCauldronTime;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
        }
        if (((ItemStack)this.curdlerStacks.get(0)).func_77973_b() == Items.field_151117_aB) {
            FluidBucketWrapper milkWrapper = new FluidBucketWrapper(new ItemStack(Items.field_151117_aB));
            if (this.tank.fill(milkWrapper.getFluid().copy(), false) != 0) {
                this.tank.fill(milkWrapper.getFluid().copy(), true);
                this.curdlerStacks.set(0, (Object)new ItemStack(Items.field_151133_ar));
            }
        } else if (TileEntityAutoCurdler.isMilk((ItemStack)this.curdlerStacks.get(0)) && (fluidStack = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.curdlerStacks.get(0)))) != null && (fluidHandler = FluidUtil.getFluidHandler((ItemStack)((ItemStack)this.curdlerStacks.get(0)))).drain(Integer.MAX_VALUE, false) != null && fluidHandler.drain((int)Integer.MAX_VALUE, (boolean)false).amount > 0 && this.tank.fill(fluidStack.copy(), false) != 0) {
            this.tank.fill(fluidStack.copy(), true);
            fluidHandler.drain(Integer.MAX_VALUE, true);
            this.curdlerStacks.set(0, (Object)fluidHandler.getContainer());
        }
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack toAdd = new ItemStack(RatsBlockRegistry.BLOCK_OF_CHEESE);
            if (this.func_70301_a(1).func_77969_a(toAdd) && this.func_70301_a(1).func_190916_E() < 64) {
                this.func_70301_a(1).func_190917_f(1);
            } else if (this.func_70301_a(1).func_190926_b()) {
                this.func_70299_a(1, toAdd.func_77946_l());
            }
            this.tank.drain(1000, true);
        }
    }

    public boolean canSmelt() {
        if (this.tank.getFluidAmount() < 1000) {
            return false;
        }
        ItemStack itemstack = new ItemStack(RatsBlockRegistry.BLOCK_OF_CHEESE);
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.curdlerStacks.get(1);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
            return true;
        }
        return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
    }

    public void func_174889_b(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            RatsMod.NETWORK_WRAPPER.sendToAll((IMessage)new MessageAutoCurdlerFluid(this.func_174877_v().func_177986_g(), this.tank.getFluid()));
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            RatsMod.NETWORK_WRAPPER.sendToAll((IMessage)new MessageAutoCurdlerFluid(this.func_174877_v().func_177986_g(), this.tank.getFluid()));
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 1) {
            return false;
        }
        return TileEntityAutoCurdler.isMilk(stack);
    }

    private boolean isMilkFluid(FluidStack fluid) {
        return fluid.getUnlocalizedName().contains("milk") || fluid.getUnlocalizedName().contains("Milk");
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.tank.getFluidAmount();
            }
            case 1: {
                return this.cookTime;
            }
            case 2: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                if (this.tank.getFluid() == null) break;
                this.tank.getFluid().amount = value;
                break;
            }
            case 1: {
                this.cookTime = value;
                break;
            }
            case 2: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        this.curdlerStacks.clear();
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return SLOTS_BOTTOM;
        }
        return SLOTS_TOP;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (direction == EnumFacing.DOWN && index == 1) {
            Item item = stack.func_77973_b();
            return true;
        }
        return false;
    }

    public String func_70005_c_() {
        return "container.auto_curdler";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            return (T)this.handlerTop;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }
}

