/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class RatAIWander
extends EntityAIWanderAvoidWater {
    private EntityRat rat;

    public RatAIWander(EntityRat creatureIn, double speedIn) {
        super((EntityCreature)creatureIn, speedIn);
        this.rat = creatureIn;
        this.field_179481_f = 200;
        this.func_75248_a(1);
    }

    @Nullable
    protected Vec3d func_190864_f() {
        if (this.field_75457_a.func_70090_H()) {
            Vec3d vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this.field_75457_a, (int)15, (int)7);
            return vec3d == null ? this.generateRatPosition() : vec3d;
        }
        return this.field_75457_a.func_70681_au().nextFloat() >= this.field_190865_h ? RandomPositionGenerator.func_191377_b((EntityCreature)this.field_75457_a, (int)10, (int)7) : this.generateRatPosition();
    }

    private Vec3d generateRatPosition() {
        boolean inCage;
        Vec3d vec3d = null;
        boolean bl = inCage = this.rat.isInCage() || this.rat.inTube();
        if (inCage) {
            if (this.rat.inTube()) {
                vec3d = RatUtils.generateRandomCagePos(this.rat, 30, 10, new Vec3d(-this.rat.field_70165_t, -this.rat.field_70163_u, -this.rat.field_70161_v), this.rat.waterBased);
                if (vec3d == null) {
                    vec3d = RatUtils.generateRandomCageOrTubePos(this.rat, 20, 20, null, false);
                }
            } else {
                vec3d = RatUtils.generateRandomTubePos(this.rat, 15, 3, new Vec3d(-this.rat.field_70165_t, -this.rat.field_70163_u, -this.rat.field_70161_v), this.rat.waterBased);
                if (vec3d == null) {
                    vec3d = RatUtils.findRandomCageOrTubeTarget(this.rat, 15, 2);
                }
            }
            if (vec3d != null) {
                vec3d = new Vec3d((Vec3i)RatUtils.findLowestRatCage(new BlockPos(vec3d), (EntityCreature)this.rat));
            }
        }
        if (!inCage || vec3d == null) {
            if (this.rat.waterBased) {
                vec3d = RatUtils.generateRandomWaterPos((EntityCreature)this.rat, this.rat.func_70909_n() ? 5 : 10, 7, null, true);
            } else if (this.rat.isHarvestCommand() && this.rat.func_110175_bO()) {
                BlockPos home = this.rat.func_180486_cf();
                vec3d = new Vec3d((Vec3i)home);
            } else {
                vec3d = RandomPositionGenerator.func_75463_a((EntityCreature)this.rat, (int)(this.rat.func_70909_n() ? 5 : 10), (int)7);
            }
        }
        return vec3d == null ? super.func_190864_f() : vec3d;
    }

    public boolean func_75250_a() {
        return this.shouldRatAIExecute() && super.func_75250_a();
    }

    private boolean shouldRatAIExecute() {
        return this.rat.canMove() && !this.rat.hasFlight() && !this.rat.isDancing() && !this.rat.isFleeing && this.rat.shouldWander();
    }
}

