/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.entity.ai.RatAIMoveToBlock;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class RatAIRaidChests
extends RatAIMoveToBlock {
    private final EntityRat entity;

    public RatAIRaidChests(EntityRat entity) {
        super((EntityCreature)entity, 1.0, entity.getSearchRadius());
        this.entity = entity;
    }

    public static boolean isChestRaidable(World world, BlockPos pos) {
        String[] blacklist = RatsMod.CONFIG_OPTIONS.blacklistedRatBlocks;
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockContainer) {
            TileEntity entity;
            Block block = world.func_180495_p(pos).func_177230_c();
            boolean listed = false;
            for (String name : blacklist) {
                if (!name.equalsIgnoreCase(block.getRegistryName().toString())) continue;
                listed = true;
                break;
            }
            if (!listed && (entity = world.func_175625_s(pos)) instanceof IInventory) {
                IInventory inventory = (IInventory)entity;
                try {
                    if (!inventory.func_191420_l() && inventory.func_70302_i_() > 0 && RatUtils.doesContainFood(inventory)) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public boolean func_75250_a() {
        if (!this.entity.canMove() || this.entity.func_70909_n() || this.entity.isInCage() || !RatsMod.CONFIG_OPTIONS.ratsStealItems) {
            return false;
        }
        if (!this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        if (this.runDelay <= 0 && !ForgeEventFactory.getMobGriefingEvent((World)this.entity.field_70170_p, (Entity)this.entity)) {
            return false;
        }
        return super.func_75250_a();
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b();
    }

    public boolean canSeeChest() {
        RayTraceResult rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.entity.field_70170_p, this.entity.func_174791_d(), new Vec3d((double)this.destinationBlock.func_177958_n() + 0.5, (double)this.destinationBlock.func_177956_o() + 0.5, (double)this.destinationBlock.func_177952_p() + 0.5), false);
        if (rayTrace != null && rayTrace.field_72307_f != null) {
            BlockPos sidePos = rayTrace.func_178782_a();
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            return this.entity.field_70170_p.func_175623_d(sidePos) || this.entity.field_70170_p.func_175623_d(pos) || this.entity.field_70170_p.func_175625_s(pos) == this.entity.field_70170_p.func_175625_s(this.destinationBlock);
        }
        return true;
    }

    @Override
    public void func_75246_d() {
        TileEntity entity;
        super.func_75246_d();
        if (this.getIsAboveDestination() && this.destinationBlock != null && (entity = this.entity.field_70170_p.func_175625_s(this.destinationBlock)) instanceof IInventory) {
            IInventory feeder = (IInventory)entity;
            double distance = this.entity.func_70011_f(this.destinationBlock.func_177958_n(), this.destinationBlock.func_177956_o(), this.destinationBlock.func_177952_p());
            if (distance < 2.5 && distance >= 1.5 && this.canSeeChest()) {
                this.toggleChest(feeder, true);
            }
            if (distance < 1.5 && this.canSeeChest()) {
                this.toggleChest(feeder, false);
                ItemStack stack = RatUtils.getFoodFromInventory(this.entity, feeder, this.entity.field_70170_p.field_73012_v);
                if (stack == ItemStack.field_190927_a) {
                    this.destinationBlock = null;
                    this.func_75251_c();
                } else {
                    int slotToReplace;
                    ItemStack duplicate = stack.func_77946_l();
                    duplicate.func_190920_e(1);
                    if (!this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && !this.entity.field_70170_p.field_72995_K) {
                        this.entity.func_70099_a(this.entity.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
                    }
                    this.entity.func_184611_a(EnumHand.MAIN_HAND, duplicate);
                    stack.func_190918_g(1);
                    if (RatsMod.CONFIG_OPTIONS.ratsContaminateFood && this.entity.func_70681_au().nextInt(3) == 0 && (slotToReplace = RatUtils.getContaminatedSlot(this.entity, feeder, this.entity.field_70170_p.field_73012_v)) != -1) {
                        if (feeder.func_70301_a(slotToReplace).func_190926_b()) {
                            ItemStack stack1 = new ItemStack(RatsItemRegistry.CONTAMINATED_FOOD);
                            feeder.func_70299_a(slotToReplace, stack1);
                        } else if (feeder.func_70301_a(slotToReplace).func_77973_b() == RatsItemRegistry.CONTAMINATED_FOOD) {
                            feeder.func_70301_a(slotToReplace).func_190917_f(1);
                        }
                    }
                    this.entity.fleePos = this.destinationBlock;
                    this.destinationBlock = null;
                    this.func_75251_c();
                }
            }
        }
    }

    @Override
    protected boolean shouldMoveTo(World worldIn, BlockPos pos) {
        return pos != null && RatAIRaidChests.isChestRaidable(worldIn, pos);
    }

    public void toggleChest(IInventory te, boolean open) {
        if (te instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)te;
            if (open) {
                ++chest.field_145987_o;
                this.entity.field_70170_p.func_175641_c(this.destinationBlock, chest.func_145838_q(), 1, chest.field_145987_o);
            } else if (chest.field_145987_o > 0) {
                chest.field_145987_o = 0;
                this.entity.field_70170_p.func_175641_c(this.destinationBlock, chest.func_145838_q(), 1, chest.field_145987_o);
            }
        }
    }
}

