/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;

public class RatAIHarvestFisherman
extends EntityAIBase {
    private final EntityRat entity;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = null;
    private boolean hasReachedWater = false;
    private int fishingCooldown = 1000;
    private int throwCooldown = 0;
    private Random rand = new Random();

    public RatAIHarvestFisherman(EntityRat entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!(this.entity.canMove() && this.entity.func_70909_n() && this.entity.getCommand() == RatCommand.HARVEST && !this.entity.isInCage() && this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FISHERMAN) && this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b())) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
        this.hasReachedWater = false;
        this.fishingCooldown = 250 + this.rand.nextInt(750);
    }

    public void func_75246_d() {
        if (this.targetBlock != null && this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            if (!this.hasReachedWater) {
                this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.0);
            }
            if (this.isShore(this.targetBlock, this.entity.field_70170_p)) {
                double distance = this.entity.func_70011_f(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p());
                if (distance < 2.0) {
                    if (this.throwCooldown == 0) {
                        this.entity.func_184185_a(SoundEvents.field_187612_G, 1.0f, 0.5f);
                        this.throwCooldown = 20;
                    }
                    this.hasReachedWater = true;
                } else {
                    this.hasReachedWater = false;
                }
            } else {
                this.targetBlock = null;
                this.func_75251_c();
            }
        }
        if (this.hasReachedWater) {
            this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)85);
            this.entity.crafting = true;
            if (this.fishingCooldown > 0) {
                --this.fishingCooldown;
            }
            if (this.fishingCooldown == 0) {
                this.spawnFishingLoot();
                this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)101);
                this.entity.func_184185_a(SoundEvents.field_187609_F, 1.0f, 1.0f);
            }
        } else {
            this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)86);
            this.entity.crafting = false;
        }
        if (this.throwCooldown > 0) {
            --this.throwCooldown;
        }
    }

    private void resetTarget() {
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        int RADIUS = this.entity.getSearchRadius();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.entity.getSearchCenter().func_177982_a(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.entity.getSearchCenter().func_177982_a(RADIUS, RADIUS, RADIUS))) {
            if (!this.isShore(pos, this.entity.field_70170_p)) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            this.targetBlock = (BlockPos)allBlocks.get(0);
        }
    }

    private boolean isShore(BlockPos pos, World world) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (world.func_180495_p(pos.func_177972_a(facing)).func_185904_a() != Material.field_151586_h || !world.func_180495_p(pos).func_185914_p() || !world.func_175623_d(pos.func_177984_a())) continue;
            return true;
        }
        return false;
    }

    public void spawnFishingLoot() {
        this.fishingCooldown = 250 + this.rand.nextInt(750);
        double luck = 0.1;
        LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.entity.field_70170_p);
        lootcontext$builder.func_186469_a((float)luck).func_186472_a((Entity)this.entity);
        List result = this.entity.field_70170_p.func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(this.entity.func_70681_au(), lootcontext$builder.func_186471_a());
        for (ItemStack itemstack : result) {
            EntityItem entityitem = new EntityItem(this.entity.field_70170_p, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, itemstack);
            if (this.entity.field_70170_p.field_72995_K) continue;
            this.entity.field_70170_p.func_72838_d((Entity)entityitem);
        }
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final Entity entity;

        public BlockSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = this.getDistance(pos1);
            double distance2 = this.getDistance(pos2);
            return Double.compare(distance1, distance2);
        }

        private double getDistance(BlockPos pos) {
            double deltaX = this.entity.field_70165_t - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.field_70163_u + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.field_70161_v - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

