/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatsMod;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPlagueShot
extends EntityArrow {
    public EntityPlagueShot(World worldIn) {
        super(worldIn);
        this.func_70239_b(6.0);
    }

    public EntityPlagueShot(World worldIn, double x, double y, double z, float r, float g, float b) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.func_70239_b(6.0);
    }

    public EntityPlagueShot(World worldIn, EntityLivingBase shooter, double dmg) {
        super(worldIn, shooter);
        this.func_70239_b(dmg);
    }

    public boolean func_70090_H() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        float sqrt = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        if ((sqrt < 0.1f || this.field_70254_i || this.field_70123_F) && this.field_70173_aa > 5) {
            this.func_70106_y();
        }
        double d0 = 0.0;
        double d1 = 0.01;
        double d2 = 0.0;
        double x = this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N;
        double y = this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - (double)this.field_70131_O;
        double z = this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N;
        float f = (this.field_70130_N + this.field_70131_O + this.field_70130_N) * 0.333f + 0.5f;
        if (this.particleDistSq(x, y, z) < (double)(f * f)) {
            if (this.field_70146_Z.nextBoolean()) {
                RatsMod.PROXY.spawnParticle("black_death", x, y + 0.5, z, d0, d1, d2);
            } else {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, x, y + 0.5, z, d0, d1, d2, new int[0]);
            }
        }
        super.func_70071_h_();
    }

    public double particleDistSq(double toX, double toY, double toZ) {
        double d0 = this.field_70165_t - toX;
        double d1 = this.field_70163_u - toY;
        double d2 = this.field_70161_v - toZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void func_184185_a(@Nonnull SoundEvent soundIn, float volume, float pitch) {
        if (!this.func_174814_R() && soundIn != SoundEvents.field_187731_t && soundIn != SoundEvents.field_187734_u) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundIn, this.func_184176_by(), volume, pitch);
        }
    }

    protected void func_184548_a(@Nonnull EntityLivingBase living) {
        super.func_184548_a(living);
        if (this.field_70250_c == null || !living.func_70028_i(this.field_70250_c)) {
            living.func_70690_d(new PotionEffect(RatsMod.PLAGUE_POTION, RatsMod.CONFIG_OPTIONS.plagueEffectDuration * 20, 0));
            if (living instanceof EntityPlayer) {
                this.damageShield((EntityPlayer)living, (float)this.func_70242_d());
            }
        }
    }

    protected void damageShield(EntityPlayer player, float damage) {
        if (damage >= 3.0f && player.func_184607_cu().func_77973_b().isShield(player.func_184607_cu(), (EntityLivingBase)player)) {
            ItemStack copyBeforeUse = player.func_184607_cu().func_77946_l();
            int i = 1 + MathHelper.func_76141_d((float)damage);
            player.func_184607_cu().func_77972_a(i, (EntityLivingBase)player);
            if (player.func_184607_cu().func_190926_b()) {
                EnumHand enumhand = player.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)enumhand);
                if (enumhand == EnumHand.MAIN_HAND) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
                player.func_184602_cy();
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_189652_ae() {
        return true;
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }
}

