/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.advancements.RatsAdvancementRegistry;
import com.github.alexthe666.rats.server.entity.EntityBlackDeath;
import com.github.alexthe666.rats.server.entity.EntityPurifyingLiquid;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.IPlagueLegion;
import com.github.alexthe666.rats.server.entity.ai.PlagueDoctorAIFollowGolem;
import com.github.alexthe666.rats.server.entity.ai.PlagueDoctorAILookAtTradePlayer;
import com.github.alexthe666.rats.server.entity.ai.PlagueDoctorAITradePlayer;
import com.github.alexthe666.rats.server.entity.ai.PlagueDoctorAIVillagerInteract;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.world.village.RatsVillageRegistry;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPlagueDoctor
extends EntityAgeable
implements IRangedAttackMob,
INpc,
IMerchant {
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("rats", "plague_doctor"));
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Item.func_150898_a((Block)Blocks.field_150328_O)});
    private static final Predicate<Entity> PLAGUE_PREDICATE = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(RatsMod.PLAGUE_POTION) || entity instanceof EntityRat && ((EntityRat)entity).hasPlague() || entity instanceof IPlagueLegion;
        }
    };
    private final InventoryBasic villagerInventory = new InventoryBasic("Items", false, 8);
    Village village;
    private boolean isMating;
    private boolean isPlaying;
    @Nullable
    private EntityPlayer buyingPlayer;
    @Nullable
    private MerchantRecipeList buyingList;
    private int timeUntilReset;
    private boolean needsInitilization;
    private boolean isWillingToMate;
    private int wealth;
    private UUID lastBuyingPlayer;
    private int careerId;
    private int careerLevel;
    private boolean isLookingForHome;
    private boolean areAdditionalTasksSet;
    private int randomTickDivider;

    public EntityPlagueDoctor(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.func_98053_h(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new PlagueDoctorAITradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new PlagueDoctorAILookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 60, 10.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new PlagueDoctorAIFollowGolem(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new PlagueDoctorAIVillagerInteract(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombieVillager.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, false, PLAGUE_PREDICATE));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null) {
            if (this.func_70638_az() instanceof EntityRat) {
                if (!((EntityRat)this.func_70638_az()).hasPlague()) {
                    this.func_70624_b(null);
                }
            } else if (this.func_70638_az() instanceof EntityZombieVillager) {
                if (((EntityZombieVillager)this.func_70638_az()).func_82230_o()) {
                    this.func_70624_b(null);
                }
            } else if (!this.func_70638_az().func_70644_a(RatsMod.PLAGUE_POTION) && !(this.func_70638_az() instanceof IPlagueLegion)) {
                this.func_70624_b(null);
            }
        }
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() != RatsMod.PLAGUE_POTION && super.func_70687_e(potioneffectIn);
    }

    protected void func_70619_bc() {
        if (--this.randomTickDivider <= 0) {
            BlockPos blockpos = new BlockPos((Entity)this);
            this.field_70170_p.func_175714_ae().func_176060_a(blockpos);
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            this.village = this.field_70170_p.func_175714_ae().func_176056_a(blockpos, 32);
            if (this.village == null) {
                this.func_110177_bN();
            } else {
                BlockPos blockpos1 = this.village.func_180608_a();
                this.func_175449_a(blockpos1, this.village.func_75568_b());
                if (this.isLookingForHome) {
                    this.isLookingForHome = false;
                    this.village.func_82683_b(5);
                }
            }
        }
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.needsInitilization) {
                    for (MerchantRecipe merchantrecipe : this.buyingList) {
                        if (!merchantrecipe.func_82784_g()) continue;
                        merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                    }
                    this.populateBuyingList();
                    this.needsInitilization = false;
                    if (this.village != null && this.lastBuyingPlayer != null) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                        this.village.modifyPlayerReputation(this.lastBuyingPlayer, 1);
                    }
                }
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb;
        if (!this.field_70170_p.field_72995_K) {
            RatsAdvancementRegistry.PLAGUE_DOCTOR_TRIGGER.trigger((EntityPlayerMP)player, (Entity)this);
        }
        if (flag) {
            itemstack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (!(this.func_190669_a(itemstack, ((Object)((Object)this)).getClass()) || !this.func_70089_S() || this.isTrading() || this.func_70631_g_() || player.func_70093_af())) {
            if (this.buyingList == null) {
                this.populateBuyingList();
            }
            if (hand == EnumHand.MAIN_HAND) {
                player.func_71029_a(StatList.field_188074_H);
            }
            if (!this.field_70170_p.field_72995_K && !this.buyingList.isEmpty()) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            } else if (this.buyingList.isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Riches", this.wealth);
        compound.func_74768_a("Career", this.careerId);
        compound.func_74768_a("CareerLevel", this.careerLevel);
        compound.func_74757_a("Willing", this.isWillingToMate);
        if (this.buyingList != null) {
            compound.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.villagerInventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            nbttaglist.func_74742_a((NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("Inventory", (NBTBase)nbttaglist);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.wealth = compound.func_74762_e("Riches");
        this.careerId = compound.func_74762_e("Career");
        this.careerLevel = compound.func_74762_e("CareerLevel");
        this.isWillingToMate = compound.func_74767_n("Willing");
        if (compound.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound = compound.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound);
        }
        NBTTagList nbttaglist = compound.func_150295_c("Inventory", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            ItemStack itemstack = new ItemStack(nbttaglist.func_150305_b(i));
            if (itemstack.func_190926_b()) continue;
            this.villagerInventory.func_174894_a(itemstack);
        }
        this.func_98053_h(true);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.isTrading() ? SoundEvents.field_187914_gn : SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    public boolean isMating() {
        return this.isMating;
    }

    public void setMating(boolean mating) {
        this.isMating = mating;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (this.village != null && livingBase != null) {
            this.village.func_75575_a(livingBase);
            if (livingBase instanceof EntityPlayer) {
                int i = -1;
                if (this.func_70631_g_()) {
                    i = -3;
                }
                this.village.modifyPlayerReputation(livingBase.func_110124_au(), i);
                if (this.func_70089_S()) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)13);
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (this.village != null) {
            Entity entity = cause.func_76346_g();
            if (entity != null) {
                if (entity instanceof EntityPlayer) {
                    this.village.modifyPlayerReputation(entity.func_110124_au(), -2);
                } else if (entity instanceof IMob) {
                    this.village.func_82692_h();
                }
            } else {
                EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 16.0);
                if (entityplayer != null) {
                    this.village.func_82692_h();
                }
            }
        }
        super.func_70645_a(cause);
    }

    @Nullable
    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public void func_70932_a_(@Nullable EntityPlayer player) {
        this.buyingPlayer = player;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public boolean getIsWillingToMate(boolean updateFirst) {
        if (!this.isWillingToMate && updateFirst && this.hasEnoughFoodToBreed()) {
            boolean flag = false;
            for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.villagerInventory.func_70301_a(i);
                if (!itemstack.func_190926_b()) {
                    if (itemstack.func_77973_b() == Items.field_151025_P && itemstack.func_190916_E() >= 3) {
                        flag = true;
                        this.villagerInventory.func_70298_a(i, 3);
                    } else if ((itemstack.func_77973_b() == Items.field_151174_bG || itemstack.func_77973_b() == Items.field_151172_bF) && itemstack.func_190916_E() >= 12) {
                        flag = true;
                        this.villagerInventory.func_70298_a(i, 12);
                    }
                }
                if (!flag) continue;
                this.field_70170_p.func_72960_a((Entity)this, (byte)18);
                this.isWillingToMate = true;
                break;
            }
        }
        return this.isWillingToMate;
    }

    public void setIsWillingToMate(boolean isWillingToMate) {
        this.isWillingToMate = isWillingToMate;
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.timeUntilReset = 40;
            this.needsInitilization = true;
            this.isWillingToMate = true;
            this.lastBuyingPlayer = this.buyingPlayer != null ? this.buyingPlayer.func_110124_au() : null;
            i += 5;
        }
        if (recipe.func_77394_a().func_77973_b() == Items.field_151166_bC) {
            this.wealth += recipe.func_77394_a().func_190916_E();
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(stack.func_190926_b() ? SoundEvents.field_187913_gm : SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Nullable
    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        return this.buyingList;
    }

    private void populateBuyingList() {
        if (this.careerId != 0 && this.careerLevel != 0) {
            ++this.careerLevel;
        } else {
            this.careerId = this.getProfessionForge().getRandomCareer(this.field_70146_Z) + 1;
            this.careerLevel = 1;
        }
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        int i = this.careerId - 1;
        int j = this.careerLevel - 1;
        List trades = this.getProfessionForge().getCareer(i).getTrades(j);
        if (trades != null) {
            for (EntityVillager.ITradeList entityvillager$itradelist : trades) {
                entityvillager$itradelist.func_190888_a((IMerchant)this, this.buyingList, this.field_70146_Z);
            }
        }
    }

    private VillagerRegistry.VillagerProfession getProfessionForge() {
        return RatsVillageRegistry.PLAGUE_DOCTOR;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(@Nullable MerchantRecipeList recipeList) {
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? 0.81f : 1.62f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.spawnParticles(EnumParticleTypes.HEART);
        } else if (id == 13) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_ANGRY);
        } else if (id == 14) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_HAPPY);
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EnumParticleTypes particleType) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        return this.finalizeMobSpawn(difficulty, livingdata, true);
    }

    public IEntityLivingData finalizeMobSpawn(DifficultyInstance p_190672_1_, @Nullable IEntityLivingData p_190672_2_, boolean p_190672_3_) {
        p_190672_2_ = super.func_180482_a(p_190672_1_, p_190672_2_);
        this.populateBuyingList();
        return p_190672_2_;
    }

    public void setLookingForHome() {
        this.isLookingForHome = true;
    }

    public EntityPlagueDoctor createChild(EntityAgeable ageable) {
        EntityPlagueDoctor entityvillager = new EntityPlagueDoctor(this.field_70170_p);
        entityvillager.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityvillager)), null);
        return entityvillager;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return true;
    }

    public InventoryBasic getVillagerInventory() {
        return this.villagerInventory;
    }

    protected void func_175445_a(EntityItem itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        Item item = itemstack.func_77973_b();
        if (this.canVillagerPickupItem(item)) {
            ItemStack itemstack1 = this.villagerInventory.func_174894_a(itemstack);
            if (itemstack1.func_190926_b()) {
                itemEntity.func_70106_y();
            } else {
                itemstack.func_190920_e(itemstack1.func_190916_E());
            }
        }
    }

    private boolean canVillagerPickupItem(Item itemIn) {
        return itemIn == Items.field_151025_P || itemIn == Items.field_151174_bG || itemIn == Items.field_151172_bF || itemIn == Items.field_151015_O || itemIn == Items.field_151014_N || itemIn == Items.field_185164_cV || itemIn == Items.field_185163_cU;
    }

    public boolean hasEnoughFoodToBreed() {
        return this.hasEnoughItems(1);
    }

    public boolean canAbondonItems() {
        return this.hasEnoughItems(2);
    }

    public boolean wantsMoreFood() {
        return !this.hasEnoughItems(5);
    }

    private boolean hasEnoughItems(int multiplier) {
        for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.villagerInventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b() == Items.field_151025_P && itemstack.func_190916_E() >= 3 * multiplier || itemstack.func_77973_b() == Items.field_151174_bG && itemstack.func_190916_E() >= 12 * multiplier || itemstack.func_77973_b() == Items.field_151172_bF && itemstack.func_190916_E() >= 12 * multiplier || itemstack.func_77973_b() == Items.field_185164_cV && itemstack.func_190916_E() >= 12 * multiplier) {
                return true;
            }
            if (itemstack.func_77973_b() != Items.field_151015_O || itemstack.func_190916_E() < 9 * multiplier) continue;
            return true;
        }
        return false;
    }

    public boolean isFarmItemInInventory() {
        for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.villagerInventory.func_70301_a(i);
            if (itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151014_N && itemstack.func_77973_b() != Items.field_151174_bG && itemstack.func_77973_b() != Items.field_151172_bF && itemstack.func_77973_b() != Items.field_185163_cU) continue;
            return true;
        }
        return false;
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (super.func_174820_d(inventorySlot, itemStackIn)) {
            return true;
        }
        int i = inventorySlot - 300;
        if (i >= 0 && i < this.villagerInventory.func_70302_i_()) {
            this.villagerInventory.func_70299_a(i, itemStackIn);
            return true;
        }
        return false;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
        double d1 = target.field_70165_t + target.field_70159_w - this.field_70165_t;
        double d2 = d0 - this.field_70163_u;
        double d3 = target.field_70161_v + target.field_70179_y - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
        EntityPurifyingLiquid entitypotion = new EntityPurifyingLiquid(this.field_70170_p, (EntityLivingBase)this, new ItemStack(RatsItemRegistry.PURIFYING_LIQUID));
        entitypotion.field_70125_A -= -20.0f;
        entitypotion.func_70186_c(d1, d2 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        this.field_70170_p.func_72838_d((Entity)entitypotion);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public void func_70077_a(@Nonnull EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && RatsMod.CONFIG_OPTIONS.convertPlagueDoctorToBlackDeath) {
            EntityBlackDeath entitywitch = new EntityBlackDeath(this.field_70170_p);
            entitywitch.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitywitch.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entitywitch)), null);
            entitywitch.func_94061_f(this.func_175446_cd());
            if (this.func_145818_k_()) {
                entitywitch.func_96094_a(this.func_95999_t());
                entitywitch.func_174805_g(this.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)entitywitch);
            this.func_70106_y();
        }
    }
}

