/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityBlackDeath;
import com.github.alexthe666.rats.server.entity.EntityFeralRatlantean;
import com.github.alexthe666.rats.server.entity.IPlagueLegion;
import com.github.alexthe666.rats.server.entity.ai.BlackDeathAITargetNonPlagued;
import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityPlagueBeast
extends EntityFeralRatlantean
implements IPlagueLegion {
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("rats", "plague_beast"));
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityPlagueBeast.class, (DataSerializer)DataSerializers.field_187203_m);

    public EntityPlagueBeast(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new BlackDeathAITargetNonPlagued((EntityCreature)this, EntityLivingBase.class, false));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == RatsMod.PLAGUE_POTION) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        double d0 = 0.0;
        double d1 = this.field_70146_Z.nextGaussian() * 0.05 + 0.5;
        double d2 = 0.0;
        this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        if (this.getOwnerId() != null && this.getOwner() != null && this.getOwner() instanceof EntityBlackDeath) {
            EntityBlackDeath death = (EntityBlackDeath)this.getOwner();
            if (death.func_70638_az() != null && !death.func_70638_az().field_70128_L) {
                this.func_70624_b(death.func_70638_az());
            } else {
                float radius = 8.0f - (float)Math.sin((double)death.field_70173_aa * 0.4) * 0.5f;
                int maxRatStuff = 360 / Math.max(death.getBeastsSummoned(), 1);
                int ratIndex = this.func_145782_y() % Math.max(death.getBeastsSummoned(), 1);
                float angle = (float)Math.PI / 180 * ((float)(ratIndex * maxRatStuff) + (float)this.field_70173_aa * 4.1f);
                double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + death.field_70165_t;
                double extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + death.field_70161_v;
                BlockPos runToPos = new BlockPos(extraX, death.field_70163_u, extraZ);
                for (int steps = 0; this.field_70170_p.func_180495_p(runToPos).func_185914_p() && steps < 10; ++steps) {
                    runToPos = runToPos.func_177984_a();
                }
                this.func_70661_as().func_75492_a(extraX, (double)runToPos.func_177956_o(), extraZ, 1.0);
            }
        }
        if (this.func_70638_az() != null && this.func_70638_az().field_70128_L) {
            this.func_70624_b(null);
        }
    }

    public void func_70106_y() {
        if (!this.field_70128_L && this.getOwnerId() != null && this.getOwner() != null && this.getOwner() instanceof EntityBlackDeath) {
            EntityBlackDeath illagerPiper = (EntityBlackDeath)this.getOwner();
            illagerPiper.setBeastsSummoned(illagerPiper.getBeastsSummoned() - 1);
        }
        this.field_70128_L = true;
    }

    @Override
    public boolean doExtraEffect(EntityLivingBase target) {
        target.func_70690_d(new PotionEffect(RatsMod.PLAGUE_POTION, RatsMod.CONFIG_OPTIONS.plagueEffectDuration * 20, 0));
        return true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
    }

    @Override
    public boolean hasToga() {
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getOwnerId() == null) {
            compound.func_74778_a("OwnerUUID", "");
        } else {
            compound.func_74778_a("OwnerUUID", this.getOwnerId().toString());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        if (compound.func_150297_b("OwnerUUID", 8)) {
            s = compound.func_74779_i("OwnerUUID");
        } else {
            String s1 = compound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    public EntityLivingBase getOwner() {
        try {
            Entity entity;
            EntityPlayer player;
            UUID uuid = this.getOwnerId();
            EntityPlayer entityPlayer = player = uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
            if (player != null) {
                return player;
            }
            if (!this.field_70170_p.field_72995_K && (entity = this.field_70170_p.func_73046_m().func_71218_a(this.field_71093_bK).func_175733_a(uuid)) instanceof EntityLivingBase) {
                return (EntityLivingBase)entity;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }
}

