/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatTrap;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockRatTrap
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final AxisAlignedBB NS_AABB = new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, (double)0.15f, 1.0);
    private static final AxisAlignedBB EW_AABB = new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, (double)0.15f, 0.8125);

    protected BlockRatTrap() {
        super(Material.field_151575_d);
        this.func_149711_c(1.0f);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(RatsMod.TAB);
        this.func_149663_c("rats.rat_trap");
        this.setRegistryName("rats", "rattrap");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        GameRegistry.registerTileEntity(TileEntityRatTrap.class, (String)"rats.rat_trap");
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityRatTrap) {
            if (!worldIn.field_72995_K && !((TileEntityRatTrap)tileentity).getBait().func_190926_b()) {
                worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), ((TileEntityRatTrap)tileentity).getBait()));
            }
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (entityIn != null && entityIn instanceof EntityRat) {
            return;
        }
        super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState actualState = this.func_176221_a(state, source, pos);
        if (actualState.func_177230_c() instanceof BlockRatTrap) {
            if (((EnumFacing)actualState.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X) {
                return EW_AABB;
            }
            return NS_AABB;
        }
        return NS_AABB;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityRatTrap) {
            TileEntityRatTrap ratTrap = (TileEntityRatTrap)tile;
            if (ratTrap.isShut) {
                ratTrap.isShut = false;
                worldIn.func_184133_a(null, pos, SoundEvents.field_187617_cK, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
            if (ratTrap.getBait().func_190926_b() && RatUtils.isRatFood(itemstack)) {
                ratTrap.setBaitStack(itemstack.func_77946_l());
                if (!playerIn.func_184812_l_()) {
                    itemstack.func_190920_e(0);
                }
                return true;
            }
            if (!ratTrap.getBait().func_190926_b()) {
                if (!RatUtils.isRatFood(itemstack)) {
                    // empty if block
                }
                if (!worldIn.field_72995_K) {
                    worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), ratTrap.getBait()));
                }
                ratTrap.setBaitStack(ItemStack.field_190927_a);
                return true;
            }
        }
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile instanceof TileEntityRatTrap) {
            TileEntityRatTrap ratTrap = (TileEntityRatTrap)tile;
            return ratTrap.calculateRedstone();
        }
        return 0;
    }

    @Deprecated
    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(blockState, blockAccess, pos, side);
    }

    @Deprecated
    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityRatTrap) {
            TileEntityRatTrap ratTrap = (TileEntityRatTrap)tile;
            return ratTrap.calculateRedstone();
        }
        return 0;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile;
        if (worldIn.func_175640_z(pos) && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityRatTrap) {
            TileEntityRatTrap ratTrap = (TileEntityRatTrap)tile;
            ratTrap.onRedstonePulse();
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityRatTrap();
    }
}

