/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatHole;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRatHole
extends BlockContainer {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private static final AxisAlignedBB TOP_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB NS_LEFT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 0.5, 1.0);
    private static final AxisAlignedBB NS_RIGHT_AABB = new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB EW_LEFT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.25);
    private static final AxisAlignedBB EW_RIGHT_AABB = new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB NORTH_CORNER_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 0.5, 0.25);
    private static final AxisAlignedBB EAST_CORNER_AABB = new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 0.5, 0.25);
    private static final AxisAlignedBB SOUTH_CORNER_AABB = new AxisAlignedBB(0.0, 1.0, 0.75, 0.25, 0.5, 1.0);
    private static final AxisAlignedBB WEST_CORNER_AABB = new AxisAlignedBB(0.75, 0.0, 0.75, 1.0, 0.5, 1.0);

    protected BlockRatHole() {
        super(Material.field_151575_d);
        this.func_149711_c(1.3f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(RatsMod.TAB);
        this.func_149663_c("rats.rat_hole");
        this.setRegistryName("rats", "rat_hole");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        GameRegistry.registerTileEntity(TileEntityRatHole.class, (String)"rats.rat_hole");
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof TileEntityRatHole) {
            TileEntityRatHole te = (TileEntityRatHole)worldIn.func_175625_s(pos);
            NonNullList ret = NonNullList.func_191196_a();
            te.getImmitatedBlockState().func_177230_c().getDrops(ret, (IBlockAccess)worldIn, pos, te.getImmitatedBlockState(), 1);
            for (ItemStack stack : ret) {
                EntityItem entityItem = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                if (worldIn.field_72995_K) continue;
                worldIn.func_72838_d((Entity)entityItem);
            }
        }
        worldIn.func_175713_t(pos);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.WEST)));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockRatHole.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)TOP_AABB);
        BlockRatHole.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_CORNER_AABB);
        BlockRatHole.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_CORNER_AABB);
        BlockRatHole.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_CORNER_AABB);
        BlockRatHole.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_CORNER_AABB);
        if (state.func_177230_c() instanceof BlockRatHole) {
            IBlockState actualState = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
            if (((Boolean)actualState.func_177229_b((IProperty)NORTH)).booleanValue()) {
                BlockRatHole.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EW_LEFT_AABB);
            }
            if (((Boolean)actualState.func_177229_b((IProperty)SOUTH)).booleanValue()) {
                BlockRatHole.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EW_RIGHT_AABB);
            }
            if (((Boolean)actualState.func_177229_b((IProperty)WEST)).booleanValue()) {
                BlockRatHole.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NS_LEFT_AABB);
            }
            if (((Boolean)actualState.func_177229_b((IProperty)EAST)).booleanValue()) {
                BlockRatHole.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NS_RIGHT_AABB);
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, SOUTH, EAST, WEST});
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    private boolean canFenceConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos other = pos.func_177972_a(facing);
        return world.func_180495_p(other).func_185914_p();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return false;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityRatHole) {
            TileEntityRatHole te = (TileEntityRatHole)world.func_175625_s(pos);
            return te.getImmitatedBlockState().func_177230_c().func_185467_w();
        }
        return SoundType.field_185848_a;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityRatHole();
    }
}

