/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.ModelRat;
import com.github.alexthe666.rats.client.render.entity.RenderRat;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;

public class LayerRatEyes
implements LayerRenderer<EntityRat> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_eye_glow.png");
    private static final ResourceLocation TEXTURE_PLAGUE = new ResourceLocation("rats:textures/entity/rat/rat_eye_plague.png");
    private static final ResourceLocation TEXTURE_ENDER = new ResourceLocation("rats:textures/entity/rat/rat_eye_ender_upgrade.png");
    private static final ResourceLocation TEXTURE_RATINATOR = new ResourceLocation("rats:textures/entity/rat/rat_eye_ratinator_upgrade.png");
    private static final ResourceLocation TEXTURE_NONBELIEVER = new ResourceLocation("rats:textures/entity/rat/rat_eye_nonbeliever_upgrade.png");
    private static final ResourceLocation TEXTURE_DRAGON = new ResourceLocation("rats:textures/entity/rat/rat_eye_dragon_upgrade.png");
    private final RenderRat ratRenderer;

    public LayerRatEyes(RenderRat ratRendererIn) {
        this.ratRenderer = ratRendererIn;
    }

    public void doRenderLayer(EntityRat rat, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!(this.ratRenderer.func_177087_b() instanceof ModelRat)) {
            return;
        }
        long roundedTime = rat.field_70170_p.func_72820_D() % 24000L;
        boolean night = roundedTime >= 13000L && roundedTime <= 22000L;
        BlockPos ratPos = rat.getLightPosition();
        int i = rat.field_70170_p.func_175642_b(EnumSkyBlock.SKY, ratPos);
        int j = rat.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, ratPos);
        int brightness = night ? j : Math.max(i, j);
        if (brightness < 7 || rat.shouldEyesGlow()) {
            if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON)) {
                this.ratRenderer.func_110776_a(TEXTURE_DRAGON);
            } else if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_NONBELIEVER)) {
                this.ratRenderer.func_110776_a(TEXTURE_NONBELIEVER);
            } else if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ENDER)) {
                this.ratRenderer.func_110776_a(TEXTURE_ENDER);
            } else if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_RATINATOR)) {
                this.ratRenderer.func_110776_a(TEXTURE_RATINATOR);
            } else if (rat.hasPlague()) {
                this.ratRenderer.func_110776_a(TEXTURE_PLAGUE);
            } else {
                this.ratRenderer.func_110776_a(TEXTURE);
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179140_f();
            GlStateManager.func_179143_c((int)514);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.0f);
            GlStateManager.func_179145_e();
            Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
            this.ratRenderer.func_177087_b().func_78088_a((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
            this.ratRenderer.func_177105_a((EntityLiving)rat);
            GlStateManager.func_179084_k();
            GlStateManager.func_179143_c((int)515);
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

