/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens;

import io.github.lgatodu47.screenshot_viewer.screens.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotImageHolder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Field;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

final class ScreenshotWidget
extends GuiButton
implements AutoCloseable,
ScreenshotImageHolder {
    private final ManageScreenshotsScreen mainScreen;
    private final Minecraft client;
    private final Context ctx;
    private File screenshotFile;
    private CompletableFuture<BufferedImage> image;
    @Nullable
    private DynamicTexture texture;
    private float bgOpacity = 0.0f;
    private int baseY;
    private static Field WIDTH;
    private static Field HEIGHT;

    public ScreenshotWidget(ManageScreenshotsScreen mainScreen, int x, int y, int width, int height, Context ctx, File screenshotFile) {
        super(-1, x, y, width, height, screenshotFile.getName());
        this.mainScreen = mainScreen;
        this.client = mainScreen.client();
        this.baseY = y;
        this.ctx = ctx;
        this.screenshotFile = screenshotFile;
        this.image = this.getImage(screenshotFile);
    }

    void updateBaseY(int baseY) {
        this.field_146129_i = this.baseY = baseY;
    }

    void updateY(int scrollY) {
        this.field_146129_i = this.baseY - scrollY;
    }

    void updateScreenshotFile(File screenshotFile) {
        this.screenshotFile = screenshotFile;
        if (this.texture != null) {
            this.texture.func_147631_c();
        }
        if (this.image != null) {
            this.image.thenAcceptAsync(image -> {
                if (image != null) {
                    image.flush();
                }
            }, (Executor)HttpUtil.field_180193_a);
        }
        this.texture = null;
        this.image = this.getImage(screenshotFile);
    }

    File getScreenshotFile() {
        return this.screenshotFile;
    }

    void updateHoverState(int mouseX, int mouseY, int viewportY, int viewportBottom, boolean updateHoverState) {
        this.field_146123_n = updateHoverState && mouseX >= this.field_146128_h && mouseY >= Math.max(this.field_146129_i, viewportY) && mouseX < this.field_146128_h + this.field_146120_f && mouseY < Math.min(this.field_146129_i + this.field_146121_g, viewportBottom);
        int maxOpacity = ManageScreenshotsScreen.CONFIG.screenshotElementBackgroundOpacity.getAsInt();
        if (maxOpacity > 0 && this.field_146123_n) {
            if (this.bgOpacity < (float)maxOpacity / 100.0f) {
                this.bgOpacity = Math.min((float)maxOpacity / 100.0f, this.bgOpacity + 0.05f);
            }
        } else if (this.bgOpacity > 0.0f) {
            this.bgOpacity = Math.max(0.0f, this.bgOpacity - 0.05f);
        }
    }

    void render(int viewportY, int viewportBottom) {
        this.renderBackground(viewportY, viewportBottom);
        int spacing = 2;
        DynamicTexture image = this.texture();
        if (image != null) {
            int texWidth = ScreenshotWidget.getWidth(image);
            int texHeight = ScreenshotWidget.getHeight(image);
            int renderY = Math.max(this.field_146129_i + 2, viewportY);
            int imgHeight = (int)((double)this.field_146121_g / 1.08 - 6.0);
            int topOffset = Math.max(0, viewportY - this.field_146129_i - 2);
            int bottomOffset = Math.max(0, this.field_146129_i + 2 + imgHeight - viewportBottom);
            int topV = topOffset * texHeight / imgHeight;
            int bottomV = bottomOffset * texHeight / imgHeight;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179144_i((int)image.func_110552_b());
            GlStateManager.func_179147_l();
            ScreenshotWidget.func_152125_a((int)(this.field_146128_h + 2), (int)renderY, (float)0.0f, (float)topV, (int)texWidth, (int)(texHeight - topV - bottomV), (int)(this.field_146120_f - 4), (int)(imgHeight - topOffset - bottomOffset), (float)texWidth, (float)texHeight);
            GlStateManager.func_179084_k();
        }
        float scaleFactor = (float)(new ScaledResolution(this.client).func_78328_b() / 96) / (float)this.ctx.screenshotsPerRow();
        int textY = this.field_146129_i + (int)((double)this.field_146121_g / 1.08) - 2;
        if (textY > viewportY && (float)textY + scaleFactor * (float)this.client.field_71466_p.field_78288_b < (float)viewportBottom) {
            int textColor;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)this.field_146128_h + (float)this.field_146120_f / 2.0f), (float)textY, (float)0.0f);
            GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
            String message = this.getMessage();
            float centerX = -this.client.field_71466_p.func_78256_a(this.getMessage()) / 2;
            try {
                textColor = Integer.parseInt(ManageScreenshotsScreen.CONFIG.screenshotElementTextColor.get().substring(1), 16);
            }
            catch (Throwable t) {
                textColor = 0xFFFFFF;
            }
            if (ManageScreenshotsScreen.CONFIG.renderScreenshotElementFontShadow.getAsBoolean()) {
                this.client.field_71466_p.func_175063_a(message, centerX, 0.0f, textColor);
            } else {
                this.client.field_71466_p.func_78276_b(message, (int)centerX, 0, textColor);
            }
            GlStateManager.func_179121_F();
        }
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float delta) {
    }

    private void renderBackground(int viewportY, int viewportBottom) {
        int renderY = Math.max(this.field_146129_i, viewportY);
        int renderHeight = Math.min(this.field_146129_i + this.field_146121_g, viewportBottom);
        ScreenshotWidget.func_73734_a((int)this.field_146128_h, (int)renderY, (int)(this.field_146128_h + this.field_146120_f), (int)renderHeight, (int)((int)(this.bgOpacity * 255.0f) << 24 | 0xFFFFFF));
    }

    private void onClick() {
        this.mainScreen.enlargeScreenshot(this);
    }

    private void onRightClick(double mouseX, double mouseY) {
        this.mainScreen.showScreenshotProperties(mouseX, mouseY, this);
    }

    private CompletableFuture<BufferedImage> getImage(File file) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return ImageIO.read(file);
            }
            catch (Exception e) {
                ManageScreenshotsScreen.LOGGER.error("Failed to load screenshot: {}", (Object)file.getName(), (Object)e);
                return null;
            }
        }, (Executor)HttpUtil.field_180193_a);
    }

    @Nullable
    public DynamicTexture texture() {
        if (this.texture != null) {
            return this.texture;
        }
        if (this.image == null) {
            this.image = this.getImage(this.screenshotFile);
        }
        if (this.image.isDone()) {
            this.texture = new DynamicTexture(this.image.join());
            return this.texture;
        }
        return null;
    }

    @Override
    public int indexInList() {
        return this.ctx.currentIndex(this);
    }

    @Override
    public int imageId() {
        DynamicTexture texture = this.texture();
        return texture != null ? texture.func_110552_b() : 0;
    }

    @Override
    @Nullable
    public BufferedImage image() {
        if (this.image == null) {
            this.image = this.getImage(this.screenshotFile);
        }
        return this.image.getNow(null);
    }

    public String getMessage() {
        return this.screenshotFile == null ? "" : this.screenshotFile.getName();
    }

    public void func_146113_a(SoundHandler soundManager) {
        soundManager.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.field_146123_n) {
            this.func_146113_a(this.client.func_147118_V());
            if (button == 0) {
                this.onClick();
            }
            if (button == 1) {
                this.onRightClick(mouseX, mouseY);
            }
            return true;
        }
        return false;
    }

    public boolean func_146116_c(@Nonnull Minecraft mc, int mouseX, int mouseY) {
        return false;
    }

    @Override
    public void close() {
        if (this.texture != null) {
            this.texture.func_147631_c();
        }
        if (this.image != null) {
            this.image.thenAcceptAsync(image -> {
                if (image != null) {
                    image.flush();
                }
            }, (Executor)HttpUtil.field_180193_a);
        }
        this.image = null;
        this.texture = null;
    }

    private static int getWidth(DynamicTexture texture) {
        if (WIDTH == null) {
            WIDTH = ObfuscationReflectionHelper.findField(DynamicTexture.class, (String)"field_94233_j");
        }
        try {
            return (Integer)WIDTH.get(texture);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getHeight(DynamicTexture texture) {
        if (HEIGHT == null) {
            HEIGHT = ObfuscationReflectionHelper.findField(DynamicTexture.class, (String)"field_94233_j");
        }
        try {
            return (Integer)HEIGHT.get(texture);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static interface Context {
        public int screenshotsPerRow();

        public int currentIndex(ScreenshotWidget var1);

        public static Context create(final IntSupplier screenshotsPerRow, final ToIntFunction<ScreenshotWidget> currentIndex) {
            return new Context(){

                @Override
                public int screenshotsPerRow() {
                    return screenshotsPerRow.getAsInt();
                }

                @Override
                public int currentIndex(ScreenshotWidget widget) {
                    return currentIndex.applyAsInt(widget);
                }
            };
        }
    }
}

